/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CfFileReader {
    protected Vector<Item> prop = new Vector();
    protected FileReader file = null;
    protected String cfStr = null;
    protected char currentChar;
    protected BufferedReader stream = null;

    protected char getCurrentChar() throws IOException {
        if (this.file != null) {
            return (char)this.file.read();
        }
        if (this.cfStr != null) {
            char c = this.cfStr.charAt(0);
            this.cfStr = this.cfStr.substring(1);
            return c;
        }
        if (this.stream != null) {
            return (char)this.stream.read();
        }
        return '\u0000';
    }

    protected boolean eof() throws IOException {
        if (this.file != null) {
            return !this.file.ready();
        }
        if (this.cfStr != null) {
            return this.cfStr.length() == 0;
        }
        if (this.stream != null) {
            return !this.stream.ready();
        }
        return true;
    }

    protected String readWord() throws IOException {
        boolean bl = this.currentChar > ' ';
        String string = "";
        while (!this.eof() && !bl) {
            this.currentChar = this.getCurrentChar();
            bl = this.currentChar > ' ';
        }
        if (!bl) {
            return null;
        }
        if (this.currentChar == '\'') {
            bl = false;
            while (!this.eof() && !bl) {
                this.currentChar = this.getCurrentChar();
                bl = this.currentChar == '\'';
                if (bl) continue;
                string = string + this.currentChar;
            }
            if (!bl) {
                System.out.println("CfFileReader.parse: ''' is missing");
                return null;
            }
            this.currentChar = this.getCurrentChar();
            return string;
        }
        string = string + this.currentChar;
        if (this.currentChar == ',' || this.currentChar == ':') {
            this.currentChar = this.getCurrentChar();
            return string;
        }
        bl = false;
        while (!this.eof() && !bl) {
            this.currentChar = this.getCurrentChar();
            bl = this.currentChar == ',' || this.currentChar == ':' || this.currentChar <= ' ';
            if (bl) continue;
            string = string + this.currentChar;
        }
        return string;
    }

    protected boolean parse() throws IOException {
        this.prop.clear();
        this.currentChar = '\u0000';
        String string = this.readWord();
        while (string != null) {
            Item item = new Item(string);
            string = this.readWord();
            if (!string.equals(":")) {
                System.out.println("CfFileReader.parse: ':' expected instead of " + string);
                return false;
            }
            boolean bl = true;
            while (bl) {
                bl = false;
                string = this.readWord();
                if (string != null) {
                    item.addProp(string);
                }
                if ((string = this.readWord()) == null) continue;
                bl = string.equals(",");
            }
            this.prop.add(item);
        }
        return true;
    }

    public boolean parseText(String string) {
        boolean bl = false;
        try {
            this.cfStr = string;
            bl = this.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean readFile(String string) {
        boolean bl = false;
        try {
            this.file = new FileReader(string);
            bl = this.parse();
            this.file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean readFile(File file) {
        boolean bl = false;
        try {
            this.file = new FileReader(file);
            bl = this.parse();
            this.file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean readStream(BufferedReader bufferedReader) {
        boolean bl = false;
        try {
            this.stream = bufferedReader;
            bl = this.parse();
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public Vector<String> getNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.prop.size(); ++i) {
            vector.add(this.prop.get(i).toString());
        }
        return vector;
    }

    public Vector<String> getParam(String string) {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.prop.size()) {
            bl = string.equals(this.prop.get(n).toString());
            if (bl) continue;
            ++n;
        }
        if (bl) {
            Item item = this.prop.get(n);
            return item.items;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        CfFileReader cfFileReader = new CfFileReader();
        if (cfFileReader.readFile("test.cfg")) {
            Vector<String> vector = cfFileReader.getNames();
            System.out.println("Read " + vector.size() + " params");
            for (int i = 0; i < vector.size(); ++i) {
                System.out.println(vector.get(i).toString());
                Vector<String> vector2 = cfFileReader.getParam(vector.get(i).toString());
                for (int j = 0; j < vector2.size(); ++j) {
                    System.out.println("   " + vector2.get(j).toString());
                }
            }
        } else {
            System.out.println("Error while reading config file");
        }
    }

    protected class Item {
        public Vector<String> items = new Vector();
        String name;

        public Item(String string) {
            this.name = string;
        }

        public void addProp(String string) {
            this.items.add(string);
        }

        public String toString() {
            return this.name;
        }
    }
}

