/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.properties;

import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DeviceProperty;
import fr.esrf.tangoatk.widget.properties.DevicePropertyListTableCellEditor;
import fr.esrf.tangoatk.widget.properties.DevicePropertyListTableCellRenderer;
import fr.esrf.tangoatk.widget.properties.DevicePropertyListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class DevicePropertyListPanel
extends JFrame
implements Serializable {
    protected DevicePropertyListTableModel tableModel;
    protected DevicePropertyListTableCellRenderer tableCellRenderer;
    protected DevicePropertyListTableCellEditor tableCellEditor;
    protected Device device = null;
    protected String dismissText = "Close";
    protected String applyChangeText = "Modify";
    protected String refreshText = "Refresh";
    protected String titleText = "Properties";
    protected String propertiesNameColumnText = "Name";
    protected String propertiesValueColumnText = "Values";
    protected boolean propertyListEditable = true;
    protected boolean askConfirmation = false;
    protected String titleAskConfirmation = "Confirmation";
    protected String textAskConfirmation = "Do you wish to modify the properties ?";
    protected JScrollPane textView = null;
    protected JTable theTable;
    protected JButton okButton;
    protected JButton applyButton;
    protected JButton refreshButton;
    protected JPanel innerPanel;
    protected String[] colName = new String[]{this.propertiesNameColumnText, this.propertiesValueColumnText};
    protected DeviceProperty[] data = new DeviceProperty[0];
    protected Device m_device = null;

    public DevicePropertyListPanel() throws HeadlessException {
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DevicePropertyListPanel.this.setVisible(false);
                DevicePropertyListPanel.this.dispose();
            }
        });
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new FlowLayout());
        this.okButton = new JButton(this.dismissText);
        this.okButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DevicePropertyListPanel.this.setVisible(false);
                DevicePropertyListPanel.this.dispose();
            }
        });
        this.applyButton = new JButton(this.applyChangeText);
        this.applyButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DevicePropertyListPanel.this.applyChange();
            }
        });
        this.refreshButton = new JButton(this.refreshText);
        this.refreshButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DevicePropertyListPanel.this.refresh();
            }
        });
        this.tableModel = new DevicePropertyListTableModel(this.propertiesNameColumnText, this.propertiesValueColumnText);
        this.theTable = new JTable(this.tableModel);
        this.tableCellRenderer = new DevicePropertyListTableCellRenderer();
        this.theTable.setDefaultRenderer(Object.class, this.tableCellRenderer);
        this.tableCellEditor = new DevicePropertyListTableCellEditor();
        this.theTable.setDefaultEditor(Object.class, this.tableCellEditor);
        this.textView = new JScrollPane(this.theTable);
        this.getContentPane().add((Component)this.textView, "Center");
        this.innerPanel.add(this.applyButton);
        this.innerPanel.add(this.okButton);
        this.innerPanel.add(this.refreshButton);
        this.setBounds(0, 0, 600, 400);
        this.setTitle(this.titleText);
        this.getContentPane().add((Component)this.innerPanel, "South");
    }

    public DevicePropertyListPanel(Device device, String string, String string2) throws HeadlessException {
        this.setPropertiesNameColumnText(string);
        this.setPropertiesValueColumnText(string2);
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DevicePropertyListPanel.this.setVisible(false);
                DevicePropertyListPanel.this.dispose();
            }
        });
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new FlowLayout());
        this.okButton = new JButton(this.dismissText);
        this.okButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DevicePropertyListPanel.this.setVisible(false);
                DevicePropertyListPanel.this.dispose();
            }
        });
        this.applyButton = new JButton(this.applyChangeText);
        this.applyButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DevicePropertyListPanel.this.applyChange();
            }
        });
        this.refreshButton = new JButton(this.refreshText);
        this.refreshButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DevicePropertyListPanel.this.refresh();
            }
        });
        this.tableModel = new DevicePropertyListTableModel(this.propertiesNameColumnText, this.propertiesValueColumnText);
        this.theTable = new JTable(this.tableModel);
        this.tableCellRenderer = new DevicePropertyListTableCellRenderer();
        this.theTable.setDefaultRenderer(Object.class, this.tableCellRenderer);
        this.tableCellEditor = new DevicePropertyListTableCellEditor();
        this.theTable.setDefaultEditor(Object.class, this.tableCellEditor);
        this.textView = new JScrollPane(this.theTable);
        this.getContentPane().add((Component)this.textView, "Center");
        this.innerPanel.add(this.applyButton);
        this.innerPanel.add(this.okButton);
        this.innerPanel.add(this.refreshButton);
        this.setBounds(0, 0, 600, 400);
        this.getContentPane().add((Component)this.innerPanel, "South");
        this.setDevice(device);
        try {
            this.initTable();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setTitle(this.titleText);
    }

    protected void clearTable() {
        int[] nArray = new int[this.data.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        this.tableModel.removeRows(nArray);
    }

    protected void initTable() {
        this.tableModel.setRows(this.data);
        this.theTable.setEnabled(this.propertyListEditable);
    }

    protected void refresh() {
        this.theTable.editingCanceled(null);
        this.clearTable();
        this.data = null;
        this.device.refreshPropertyMap();
        Map map = this.device.getPropertyMap();
        Set set = map.keySet();
        if (set != null) {
            this.data = new DeviceProperty[set.size()];
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.data[n] = (DeviceProperty)map.get(iterator.next());
                ++n;
            }
        } else {
            this.data = new DeviceProperty[0];
        }
        if (this.data.length > 0) {
            this.applyButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
        }
        this.initTable();
    }

    public void applyChange() {
        if (this.theTable.isEditing()) {
            this.tableModel.setValueAt(this.tableCellEditor.getCellEditorValue(), this.theTable.getEditingRow(), this.theTable.getEditingColumn());
        }
        if (this.data == null || this.data.length == 0) {
            return;
        }
        int n = 0;
        if (this.askConfirmation) {
            n = JOptionPane.showConfirmDialog(this, this.textAskConfirmation, this.titleAskConfirmation, 0);
        }
        if (n == 0) {
            this.tableModel.apply();
        }
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.clearTable();
        this.data = null;
        this.device = device;
        if (this.device != null) {
            this.refreshButton.setEnabled(true);
            Map map = this.device.getPropertyMap();
            Set set = map.keySet();
            if (set != null) {
                this.data = new DeviceProperty[set.size()];
                Iterator iterator = set.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    this.data[n] = (DeviceProperty)map.get(iterator.next());
                    ++n;
                }
            } else {
                this.data = new DeviceProperty[0];
            }
        } else {
            this.data = new DeviceProperty[0];
            this.refreshButton.setEnabled(false);
        }
        if (this.data.length > 0) {
            this.applyButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
        }
        this.initTable();
    }

    public JTable getTable() {
        return this.theTable;
    }

    public String getApplyChangeText() {
        return this.applyChangeText;
    }

    public void setApplyChangeText(String string) {
        this.applyChangeText = string;
        this.applyButton.setText(string);
    }

    public String getDismissText() {
        return this.dismissText;
    }

    public void setDismissText(String string) {
        this.dismissText = string;
        this.okButton.setText(string);
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String string) {
        this.titleText = string;
        this.setTitle(string);
    }

    public String getPropertiesNameColumnText() {
        return this.propertiesNameColumnText;
    }

    public void setPropertiesNameColumnText(String string) {
        this.propertiesNameColumnText = string;
        this.colName[0] = string;
    }

    public String getPropertiesValueColumnText() {
        return this.propertiesValueColumnText;
    }

    public void setPropertiesValueColumnText(String string) {
        this.propertiesValueColumnText = string;
        this.colName[1] = string;
    }

    public boolean isPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setPropertyListEditable(boolean bl) {
        this.propertyListEditable = bl;
        this.applyButton.setEnabled(bl);
        if (this.theTable != null) {
            this.theTable.setEnabled(bl);
        }
    }

    public String getTitleAskConfirmation() {
        return this.titleAskConfirmation;
    }

    public void setTitleAskConfirmation(String string) {
        if (string.equals("")) {
            return;
        }
        this.titleAskConfirmation = string;
    }

    public boolean isAskConfirmation() {
        return this.askConfirmation;
    }

    public void setAskConfirmation(boolean bl) {
        this.askConfirmation = bl;
    }

    public String getTextAskConfirmation() {
        return this.textAskConfirmation;
    }

    public void setTextAskConfirmation(String string) {
        if (string.equals("")) {
            return;
        }
        this.textAskConfirmation = string;
    }

    public static void main(String[] stringArray) {
        try {
            Device device;
            if (stringArray.length != 0 && stringArray.length != 1) {
                System.out.println("wrong arguments");
                System.exit(2);
            }
            System.out.println("accessing device...");
            if (stringArray.length > 0) {
                device = DeviceFactory.getInstance().getDevice(stringArray[0]);
                System.out.println("device accessed");
            } else {
                device = DeviceFactory.getInstance().getDevice("tango/tangotest/1");
                System.out.println("device accessed");
            }
            System.out.println("loading widget...");
            DevicePropertyListPanel devicePropertyListPanel = new DevicePropertyListPanel();
            devicePropertyListPanel.setPropertyListEditable(true);
            devicePropertyListPanel.setDevice(device);
            devicePropertyListPanel.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

