/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.tools.WideSearchTree;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WideSearchDialog
extends JDialog {
    private JFrame parent;
    private JScrollPane scrollPane;
    private JTextArea warningTxt;
    private JTextField wildcardTxt;

    public WideSearchDialog(JFrame jFrame) {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.initComponents();
        this.initOwnComponents();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initOwnComponents() {
        this.scrollPane = new JScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(350, 400));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.warningTxt.setVisible(false);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        this.wildcardTxt = new JTextField();
        this.warningTxt = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                WideSearchDialog.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WideSearchDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        jPanel2.setLayout(new GridBagLayout());
        jLabel.setFont(new Font("Lucida Sans", 1, 14));
        jLabel.setText("Search item :   ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.wildcardTxt.setColumns(20);
        this.wildcardTxt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WideSearchDialog.this.wildcardTxtActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.wildcardTxt, gridBagConstraints);
        this.warningTxt.setColumns(35);
        this.warningTxt.setFont(new Font("Dialog", 1, 12));
        this.warningTxt.setRows(2);
        this.warningTxt.setText("WARNING:\n   Command missing. TANGO Database server is not up to date !");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(15, 0, 15, 0);
        jPanel2.add((Component)this.warningTxt, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "North");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void wildcardTxtActionPerformed(ActionEvent actionEvent) {
        try {
            String string = this.wildcardTxt.getText();
            if (string.length() == 0 || string.equals("*")) {
                Except.throw_exception((String)"BAD_PARAM", (String)"Filter is empty !", (String)"wildcardTxt.getText()");
            }
            if (!string.startsWith("*")) {
                string = "*" + string;
            }
            if (!string.endsWith("*")) {
                string = string + "*";
            }
            WideSearchTree wideSearchTree = new WideSearchTree(this, string);
            this.scrollPane.setViewportView(wideSearchTree);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    void displayHostPanel(String string) {
        if (this.parent instanceof Astor) {
            ((Astor)this.parent).tree.displayHostInfoDialog(string);
        }
    }

    void setWarning() {
        this.warningTxt.setVisible(true);
        this.pack();
    }

    private void doClose() {
        if (this.parent.getWidth() > 0) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        new WideSearchDialog(new JFrame()).setVisible(true);
    }
}

