/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.PoolThreadsTree;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class PoolThreadsManager
extends JDialog {
    private JDialog parent;
    private TangoHost host;
    private TangoServer server;
    private PoolThreadsTree tree;
    private JScrollPane scrowllPane = null;
    private JPanel bottomPanel;
    private JButton cancelBtn;
    private JPanel centerPanel;
    private JMenu editMenu;
    private JMenuBar jMenuBar;
    private JPanel jPanel1;
    private JMenuItem newThreadItem;
    private JButton okBtn;
    private JMenuItem removeThreadItem;
    private JLabel titleLabel;
    private JTextArea warningTextArea;

    public PoolThreadsManager(JDialog jDialog, TangoHost tangoHost, TangoServer tangoServer) throws DevFailed {
        super((Dialog)jDialog, true);
        int n;
        this.parent = jDialog;
        this.host = tangoHost;
        this.server = tangoServer;
        this.initComponents();
        try {
            n = tangoServer.get_idl_version();
        }
        catch (DevFailed devFailed) {
            n = 0;
        }
        if (n > 0 && n < 4) {
            Except.throw_non_supported_exception((String)"BAD_IDL_VERSION", (String)("The server is compiled with IDL " + n + "\nThis feature is allowed only with IDL 4 (TANGO 7) and above"), (String)"PoolThreadsManager.PoolThreadsManager()");
        }
        this.warningTextArea.setVisible(n == 0);
        this.initializeTree();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    public PoolThreadsManager(JDialog jDialog, TangoHost tangoHost, String string) throws DevFailed {
        this(jDialog, tangoHost, new TangoServer(string));
    }

    public void initializeTree() throws DevFailed {
        if (this.scrowllPane == null) {
            this.scrowllPane = new JScrollPane();
            this.scrowllPane.setPreferredSize(new Dimension(350, 400));
            this.centerPanel.add((Component)this.scrowllPane, "Center");
        } else if (this.tree != null) {
            this.scrowllPane.remove(this.tree);
        }
        this.tree = new PoolThreadsTree(this, this.server);
        this.scrowllPane.setViewportView(this.tree);
        this.editMenu.setMnemonic('E');
        this.newThreadItem.setMnemonic('N');
        this.removeThreadItem.setMnemonic('R');
        this.newThreadItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.removeThreadItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
    }

    private void initComponents() {
        this.bottomPanel = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.centerPanel = new JPanel();
        this.warningTextArea = new JTextArea();
        this.jPanel1 = new JPanel();
        this.titleLabel = new JLabel();
        this.jMenuBar = new JMenuBar();
        this.editMenu = new JMenu();
        this.newThreadItem = new JMenuItem();
        this.removeThreadItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PoolThreadsManager.this.closeDialog(windowEvent);
            }
        });
        this.okBtn.setText("Apply");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolThreadsManager.this.okBtnActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.okBtn);
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolThreadsManager.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.cancelBtn);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.centerPanel.setLayout(new BorderLayout());
        this.warningTextArea.setColumns(20);
        this.warningTextArea.setEditable(false);
        this.warningTextArea.setFont(new Font("Dialog", 1, 12));
        this.warningTextArea.setRows(3);
        this.warningTextArea.setText("Warning:\nIDL server cannot be checked.\nThis feature is avalable only for TANGO-7 (or above) servers.");
        this.centerPanel.add((Component)this.warningTextArea, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 14));
        this.titleLabel.setText("Polling Threads Mangement");
        this.jPanel1.add(this.titleLabel);
        this.centerPanel.add((Component)this.jPanel1, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.editMenu.setText("Edit");
        this.newThreadItem.setText("New Thread");
        this.newThreadItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolThreadsManager.this.newThreadItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.newThreadItem);
        this.removeThreadItem.setText("Remove Thread");
        this.removeThreadItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolThreadsManager.this.removeThreadItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.removeThreadItem);
        this.jMenuBar.add(this.editMenu);
        this.setJMenuBar(this.jMenuBar);
        this.pack();
    }

    private void removeThreadItemActionPerformed(ActionEvent actionEvent) {
        if (this.tree.selectedObjectIsThread()) {
            this.tree.removeThread();
        }
    }

    private void newThreadItemActionPerformed(ActionEvent actionEvent) {
        this.tree.addThreadNode();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        if (JOptionPane.showConfirmDialog(this.parent, "Apply pool thread configuration to database ?", "Confirm Dialog", 0) == 0) {
            this.tree.putPoolThreadInfo();
            this.server.restart(this.parent, this.host, false);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent.getWidth() > 0) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        try {
            JDialog jDialog = new JDialog(new JFrame());
            new PoolThreadsManager(jDialog, new TangoHost("esrflinux1-2", true), "dserver/PoolThreadTest/pv").setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new Frame(), (String)"", (DevFailed)devFailed);
        }
    }
}

