/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.ManagePollingDialog;
import admin.astor.tools.DevBrowserTree;
import admin.astor.tools.EventsTable;
import admin.astor.tools.SubscribedSignal;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import jive.MultiLineToolTipUI;

public class DevBrowser
extends JFrame {
    private JFrame parent;
    private DevBrowserTree tree;
    private static EventsTable ev_table;
    private JMenuItem astorBtn;
    private JMenuItem eventsDlgBtn;
    private JMenuItem exitBtn;
    private JMenu fileMenu;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JTextArea textArea;
    private JScrollPane textScrollPane;
    private JScrollPane treeScrollPane;
    private JMenu viewMenu;

    public DevBrowser(JFrame jFrame) {
        this.parent = jFrame;
        this.initComponents();
        try {
            this.tree = new DevBrowserTree(this);
            this.treeScrollPane.setViewportView(this.tree);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)jFrame, null, (DevFailed)devFailed);
        }
        this.customizeMenu();
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        MultiLineToolTipUI.initialize();
    }

    private void customizeMenu() {
        this.fileMenu.setMnemonic('F');
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.viewMenu.setMnemonic('V');
        this.eventsDlgBtn.setMnemonic('E');
        this.eventsDlgBtn.setAccelerator(KeyStroke.getKeyStroke(69, 2));
    }

    void displayEventProperties(String string) {
        this.tree.displayEventProperties(string);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.treeScrollPane = new JScrollPane();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitBtn = new JMenuItem();
        this.viewMenu = new JMenu();
        this.eventsDlgBtn = new JMenuItem();
        this.astorBtn = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DevBrowser.this.exitForm(windowEvent);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.textScrollPane.setPreferredSize(new Dimension(400, 400));
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("monospaced", 1, 12));
        this.textScrollPane.setViewportView(this.textArea);
        this.jPanel1.add((Component)this.textScrollPane, "Center");
        this.treeScrollPane.setPreferredSize(new Dimension(300, 400));
        this.jPanel1.add((Component)this.treeScrollPane, "West");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.fileMenu.setText("File");
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DevBrowser.this.exitBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitBtn);
        this.jMenuBar1.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.eventsDlgBtn.setText("Events Panel");
        this.eventsDlgBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DevBrowser.this.eventsDlgBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.eventsDlgBtn);
        this.astorBtn.setText("Astor Panel");
        this.astorBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DevBrowser.this.astorBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.astorBtn);
        this.jMenuBar1.add(this.viewMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void astorBtnActionPerformed(ActionEvent actionEvent) {
        Astor astor;
        if (this.parent instanceof Astor && (astor = (Astor)this.parent) != null) {
            astor.setVisible(true);
        }
    }

    private void eventsDlgBtnActionPerformed(ActionEvent actionEvent) {
        try {
            if (ev_table == null) {
                ev_table = new EventsTable(this);
            }
            ev_table.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void exitBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        if (this.parent instanceof Astor) {
            if (((Astor)this.parent).isVisible()) {
                this.dispose();
            } else {
                ((Astor)this.parent).doExit();
            }
        } else {
            this.dispose();
        }
    }

    void setText(String string) {
        this.textArea.setText(string);
        this.textArea.setCaretPosition(0);
    }

    void add(String string, int n) {
        if (ev_table == null) {
            try {
                ev_table = new EventsTable(this);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
                return;
            }
        }
        ev_table.add(string, n);
    }

    void displayHostPanel(String string) {
        if (this.parent instanceof Astor) {
            Astor astor = (Astor)this.parent;
            astor.tree.displayHostInfo(string);
        }
    }

    void managePolling(SubscribedSignal subscribedSignal) {
        try {
            new ManagePollingDialog(this, subscribedSignal.devname, subscribedSignal.attname).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    void managePolling(String string) {
        try {
            new ManagePollingDialog(this, string, "").setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    void managePolling(DeviceProxy deviceProxy, String string) {
        try {
            new ManagePollingDialog(this, deviceProxy.name(), string).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Astor astor = new Astor();
            DevBrowser devBrowser = new DevBrowser(astor);
            devBrowser.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
        }
    }
}

