/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;

public class MkStarter {
    private final int polling_period = 1000;
    private final String[] polled_obj_names = new String[]{"HostState", "RunningServers", "StoppedServers"};
    private final String[] logging_properties = new String[]{"logging_level", "logging_target", "logging_rft"};
    private String hostname;
    private String[] ds_path;
    private boolean use_events = false;
    private String classname = "Starter";
    private String servname;
    private String devname;
    private String admindev;
    private DeviceProxy dev;

    public MkStarter() throws DevFailed {
        this.getEnvironment();
        this.servname = this.classname + "/" + this.hostname;
        this.devname = "tango/admin/" + this.hostname;
        this.admindev = "dserver/" + this.classname + "/" + this.hostname;
    }

    public MkStarter(String string, String[] stringArray, boolean bl) throws DevFailed {
        this.hostname = string;
        this.ds_path = stringArray;
        this.use_events = bl;
        this.servname = this.classname + "/" + string;
        this.devname = "tango/admin/" + string;
        this.admindev = "dserver/" + this.classname + "/" + string;
    }

    public void create() throws DevFailed {
        boolean bl = false;
        try {
            new DeviceProxy(this.devname);
            bl = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (bl) {
            Except.throw_exception((String)"DeviceAlreadyExists", (String)(this.servname + " is already exits in database."), (String)"MkStarter.MkStarter()");
        }
        System.out.println("Create server " + this.servname);
        DbDevInfo[] dbDevInfoArray = new DbDevInfo[]{new DbDevInfo(this.admindev, this.classname, this.servname), new DbDevInfo(this.devname, this.classname, this.servname)};
        Database database = ApiUtil.get_db_obj();
        database.add_device(this.devname, this.classname, this.servname);
    }

    public void setProperties() throws DevFailed {
        this.dev = new DeviceProxy(this.devname);
        this.dev.put_property(new DbDatum("StartDsPath", this.ds_path));
        String[] stringArray = new String[]{"WARNING", "file::/tmp/ds.log/starter_" + this.hostname + ".log", new Integer(500).toString()};
        DbDatum[] dbDatumArray = new DbDatum[this.logging_properties.length];
        for (int i = 0; i < this.logging_properties.length; ++i) {
            dbDatumArray[i] = new DbDatum(this.logging_properties[i], stringArray[i]);
        }
        this.dev.put_property(dbDatumArray);
        this.setPollProperty();
        if (this.use_events) {
            DbDatum dbDatum = new DbDatum("UseEvents", 1);
            this.dev.put_property(dbDatum);
            DbAttribute dbAttribute = new DbAttribute("HostState");
            dbAttribute.add("abs_change", 1);
            this.dev.put_attribute_property(dbAttribute);
            System.out.println("Starter will use events");
        } else {
            DbDatum dbDatum = new DbDatum("UseEvents", 0);
            this.dev.put_property(dbDatum);
        }
    }

    private void setPollProperty() throws DevFailed {
        String string = "1000";
        String[] stringArray = new String[2 * this.polled_obj_names.length];
        for (int i = 0; i < this.polled_obj_names.length; ++i) {
            stringArray[2 * i] = this.polled_obj_names[i].toLowerCase();
            stringArray[2 * i + 1] = string;
        }
        DbDatum dbDatum = new DbDatum("polled_attr");
        dbDatum.insert(stringArray);
        this.dev.put_property(dbDatum);
    }

    public void setAdditionalProperties(String string, String string2) throws DevFailed {
        if (string.length() > 0) {
            this.dev.put_property(new DbDatum("HostUsage", string));
        }
        if (string2.length() > 0) {
            this.dev.put_property(new DbDatum("HostCollection", string2));
        }
    }

    private void getEnvironment() throws DevFailed {
        String string;
        this.hostname = System.getProperty("HOST_NAME");
        if (this.hostname == null) {
            Except.throw_exception((String)"EnvironmentException", (String)"HOST_NAME is not defined.", (String)"MkStarter.getEnvironment()");
        }
        if ((string = System.getProperty("DS_PATH")) == null) {
            Except.throw_exception((String)"EnvironmentException", (String)"DS_PATH is not defined.", (String)"MkStarter.getEnvironment()");
        }
        this.ds_path = new String[1];
        this.ds_path[0] = string;
        String string2 = System.getProperty("USE_EVENTS");
        if (string2 != null && string2.toLowerCase().equals("true")) {
            this.use_events = true;
        }
    }

    public static void main(String[] stringArray) {
        try {
            MkStarter mkStarter = new MkStarter();
            mkStarter.create();
            mkStarter.setProperties();
        }
        catch (DevFailed devFailed) {
            System.out.println();
            Except.print_exception((Exception)((Object)devFailed));
            System.exit(-1);
        }
        System.exit(0);
    }
}

