/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import app_util.PopupError;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.logviewer.DetailPanel;
import fr.esrf.logviewer.MyTableModel;
import fr.esrf.logviewer.XMLFileHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Level;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class LoggingDialog
extends JDialog {
    private TangoHost host;
    private XMLFileHandler mHandler;
    private XMLReader mParser;
    private MyTableModel model;
    private JPanel jPanel1;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel titleLabel;

    public LoggingDialog(JFrame jFrame, TangoHost tangoHost) throws DevFailed {
        super((Frame)jFrame, true);
        this.host = tangoHost;
        this.initComponents();
        this.initMyComponents();
        this.titleLabel.setText("Starter logging for  " + tangoHost.getName());
        this.pack();
        AstorUtil.centerDialog((JDialog)this, jFrame);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoggingDialog.this.closeDialog(windowEvent);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoggingDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void initMyComponents() throws DevFailed {
        try {
            this.model = new MyTableModel();
            this.mHandler = new XMLFileHandler(this.model);
            this.mParser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            this.mParser.setContentHandler((ContentHandler)this.mHandler);
            JTable jTable = new JTable((TableModel)this.model);
            jTable.setRowSelectionAllowed(true);
            jTable.setColumnSelectionAllowed(true);
            jTable.setDragEnabled(true);
            jTable.setSelectionMode(0);
            Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
            LogTableRowRenderer logTableRowRenderer = new LogTableRowRenderer();
            int n = 0;
            int[] nArray = new int[]{0, 155, 50, 155, 300};
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                tableColumn.setCellRenderer(logTableRowRenderer);
                tableColumn.setPreferredWidth(nArray[n++]);
            }
            JScrollPane jScrollPane = new JScrollPane(jTable);
            jScrollPane.setBorder(BorderFactory.createTitledBorder("Logs"));
            jScrollPane.setMinimumSize(new Dimension(150, 150));
            jScrollPane.setPreferredSize(new Dimension(600, 350));
            DetailPanel detailPanel = new DetailPanel(jTable, this.model);
            detailPanel.setMinimumSize(new Dimension(0, 0));
            detailPanel.setPreferredSize(new Dimension(600, 0));
            this.getContentPane().add((Component)jScrollPane, "Center");
            new LoadFile(this).start();
        }
        catch (Exception exception) {
            Except.throw_exception((String)"INIT_ERROR", (String)exception.toString(), (String)"LoggingDialog.initMyComponents()");
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public class LogTableRowRenderer
    extends DefaultTableCellRenderer {
        private final Color _scolor = new Color(204, 204, 255);
        private final Color _color = new Color(230, 230, 230);
        private final JCheckBox _true = new JCheckBox("", true);
        private final JCheckBox _false = new JCheckBox("", false);

        LogTableRowRenderer() {
            this.setHorizontalAlignment(0);
            this._true.setHorizontalAlignment(0);
            this._false.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            String string = (String)jTable.getColumnModel().getColumn(n2).getHeaderValue();
            if (bl) {
                this.setBackground(this._scolor);
            } else if (string.equals("Level")) {
                object2 = (Level)object;
                if (object2 == Level.FATAL) {
                    this.setBackground(Color.black);
                    this.setForeground(Color.white);
                } else if (object2 == Level.ERROR) {
                    this.setBackground(Color.red);
                    this.setForeground(Color.black);
                } else if (object2 == Level.WARN) {
                    this.setBackground(Color.orange);
                    this.setForeground(Color.black);
                } else if (object2 == Level.INFO) {
                    this.setBackground(Color.green);
                    this.setForeground(Color.black);
                } else if (object2 == Level.DEBUG) {
                    this.setBackground(Color.cyan);
                    this.setForeground(Color.black);
                }
            } else {
                if (n % 2 == 0) {
                    this.setBackground(this._color);
                } else {
                    this.setBackground(Color.white);
                }
                this.setForeground(Color.black);
            }
            if (string.equals("Trace")) {
                object2 = (Boolean)object == Boolean.TRUE ? this._true : this._false;
                return object2;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class LoadFile
    extends Thread {
        private JDialog parent;

        LoadFile(JDialog jDialog) {
            this.parent = jDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            String string = "";
            try {
                object = "/tmp";
                if (!AstorUtil.osIsUnix()) {
                    object = "c:/temp";
                }
                File file = new File((String)object);
                System.out.println("Check " + (String)object);
                if (!file.exists()) {
                    file.mkdir();
                }
                int n = new Random().nextInt(30000);
                string = (String)object + "/astor." + n;
                String string2 = LoggingDialog.this.host.readLogFile("starter/" + LoggingDialog.this.host.getName());
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                fileOutputStream.write(string2.getBytes());
                fileOutputStream.close();
                XMLReader xMLReader = LoggingDialog.this.mParser;
                synchronized (xMLReader) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
                    stringBuffer.append("<!DOCTYPE log4j:eventSet ");
                    stringBuffer.append("[<!ENTITY data SYSTEM \"file:///");
                    stringBuffer.append(string);
                    stringBuffer.append("\">]>\n");
                    stringBuffer.append("<log4j:eventSet xmlns:log4j=\"Claira\">\n");
                    stringBuffer.append("&data;\n");
                    stringBuffer.append("</log4j:eventSet>\n");
                    StringReader stringReader = new StringReader(stringBuffer.toString());
                    InputSource inputSource = new InputSource(stringReader);
                    LoggingDialog.this.mParser.parse(inputSource);
                    String string3 = new Integer(LoggingDialog.this.mHandler.getNumEvents()).toString() + " events found !";
                    PopupMessage.show((Component)this.parent, string3);
                }
            }
            catch (DevFailed devFailed) {
                PopupError.show((Component)this.parent, devFailed);
            }
            catch (Exception exception) {
                PopupError.show((Component)this.parent, exception);
                exception.printStackTrace();
            }
            try {
                object = new File(string);
                if (((File)object).exists()) {
                    ((File)object).delete();
                }
            }
            catch (Exception exception) {
                PopupError.show((Component)this.parent, exception);
            }
        }
    }
}

