/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.DeviceTree;
import admin.astor.Monitor;
import app_util.PopupError;
import app_util.PopupTable;
import fr.esrf.Tango.DevFailed;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DeviceTreeDialog
extends JDialog {
    private DeviceTree tree;
    private Astor parent;
    private DeviceTreeDialog dialog;
    private PopupTable tableDialog = null;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton ctrlServersButton;
    private JScrollPane jScrollPane1;
    private JTextArea csInfoLabel;
    private JTextArea infoLabel;

    public DeviceTreeDialog(Astor astor) {
        super((Frame)astor, false);
        this.parent = astor;
        this.dialog = this;
        this.initComponents();
        new DisplayMonitor().start();
        this.pack();
        AstorUtil.rightShiftDialog((JDialog)this, astor);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.ctrlServersButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.csInfoLabel = new JTextArea();
        this.infoLabel = new JTextArea("   ");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DeviceTreeDialog.this.closeDialog(windowEvent);
            }
        });
        this.infoLabel.setEditable(false);
        this.infoLabel.setColumns(30);
        this.infoLabel.setRows(10);
        this.csInfoLabel.setEditable(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("TANGO Control System");
        jLabel.setFont(new Font("helvetica", 1, 18));
        jPanel.add((Component)jLabel, "North");
        this.csInfoLabel.setFont(new Font("helvetica", 1, 14));
        jPanel.add((Component)this.csInfoLabel, "Center");
        jPanel.add((Component)this.infoLabel, "South");
        this.getContentPane().add((Component)jPanel, "East");
        this.buttonPanel.setLayout(new FlowLayout(1, 50, 5));
        this.ctrlServersButton.setText("Not Controlled Servers");
        this.ctrlServersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeviceTreeDialog.this.ctrlServersButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.ctrlServersButton);
        this.cancelButton.setText("Dismiss");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeviceTreeDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
    }

    private void ctrlServersButtonActionPerformed(ActionEvent actionEvent) {
        if (this.tableDialog == null) {
            try {
                String[][] stringArray = this.tree.getNotCtrlServers();
                String string = "" + stringArray.length + "  NOT controlled servers";
                String[] stringArray2 = new String[]{"Server Name", "Last exported date"};
                this.tableDialog = new PopupTable(this, string, stringArray2, stringArray);
            }
            catch (DevFailed devFailed) {
                PopupError.show((Component)this, devFailed);
            }
        }
        this.tableDialog.setVisible(true);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    class DisplayMonitor
    extends Thread {
        private Monitor monitor;

        DisplayMonitor() {
            this.monitor = new Monitor(DeviceTreeDialog.this.parent, "Browsing TANGO database for Servers and Devices....", "");
        }

        public void run() {
            DeviceTreeDialog.this.tree = new DeviceTree(DeviceTreeDialog.this.parent, this.monitor, DeviceTreeDialog.this.infoLabel, "TANGO " + AstorUtil.getTangoHost());
            if (((DeviceTreeDialog)DeviceTreeDialog.this).tree.canceled) {
                DeviceTreeDialog.this.doClose();
            } else {
                DeviceTreeDialog.this.jScrollPane1.setPreferredSize(new Dimension(280, 400));
                DeviceTreeDialog.this.jScrollPane1.setViewportView(DeviceTreeDialog.this.tree);
                DeviceTreeDialog.this.setTitle("Tree Dialog");
                DeviceTreeDialog.this.pack();
                AstorUtil.centerDialog((JDialog)DeviceTreeDialog.this.dialog, DeviceTreeDialog.this.parent);
                this.monitor.setProgressValue(1.1, "Done");
                DeviceTreeDialog.this.csInfoLabel.setText(DeviceTreeDialog.this.tree.csInfo());
                DeviceTreeDialog.this.setVisible(true);
            }
        }
    }
}

