/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.io.IOException;
import java.util.Vector;

public class AstorCmdLine {
    private int action = -1;
    private TangoHost[] hosts = null;
    private AstorUtil util;
    private static final int NOT_INITIALIZED = -1;
    private static final int START_SERVERS = 0;
    private static final int STOP_SERVERS = 1;
    private static final String[] known_actions = new String[]{"start", "stop"};
    static final int REMOVE_POLLING = 0;
    static final int REMOVE_POLLING_FORCED = 1;
    private static final String PollAttProp = "polled_attr";
    private int doWhat;

    public AstorCmdLine(String[] stringArray) throws DevFailed, Exception {
        this.util = AstorUtil.getInstance();
        this.manageArgs(stringArray);
        this.doAction();
    }

    private void doAction() {
        int n = AstorUtil.getStarterNbStartupLevels();
        switch (this.action) {
            case 0: {
                for (int i = 1; i <= n; ++i) {
                    this.doAction(i);
                }
                break;
            }
            case 1: {
                for (int i = n; i >= 1; --i) {
                    this.doAction(i);
                }
                break;
            }
        }
    }

    private void doAction(int n) {
        if (!this.getConfirm(n)) {
            System.out.println("Skip level " + n);
            return;
        }
        for (int i = 0; i < this.hosts.length; ++i) {
            try {
                switch (this.action) {
                    case 1: {
                        if (this.hosts[i].getName().startsWith("crate")) break;
                        this.hosts[i].stopServers(n);
                        break;
                    }
                    case 0: {
                        if (this.hosts[i].getName().startsWith("crate")) break;
                        this.hosts[i].startServers(n);
                    }
                }
                System.out.println("\tdone on " + this.hosts[i].getName());
                continue;
            }
            catch (DevFailed devFailed) {
                System.out.println("\tfailed on " + this.hosts[i].getName());
                System.out.println(devFailed.errors[0].desc);
            }
        }
    }

    private boolean getConfirm(int n) {
        String string;
        System.out.println("\n");
        do {
            System.out.print(known_actions[this.action] + " all TANGO ds for level " + n + " ?  (y/n) ");
            byte[] byArray = new byte[80];
            try {
                System.in.read(byArray);
                string = new String(byArray).toLowerCase().trim();
            }
            catch (IOException iOException) {
                string = "no";
            }
        } while (!string.startsWith("n") && !string.startsWith("y"));
        return string.startsWith("y");
    }

    private void manageArgs(String[] stringArray) throws DevFailed, Exception {
        if (stringArray.length < 3) {
            this.displaySyntax();
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-h")) {
                String string;
                if ((string = stringArray[++i]).toLowerCase().equals("all")) {
                    this.hosts = this.util.getTangoHostList();
                    continue;
                }
                this.hosts = new TangoHost[1];
                this.hosts[0] = new TangoHost(string, true);
                continue;
            }
            for (int j = 0; j < known_actions.length; ++j) {
                if (!stringArray[i].equals(known_actions[j])) continue;
                this.action = j;
            }
        }
        if (this.action == -1 || this.hosts == null) {
            this.displaySyntax();
            throw new Exception("Astor Exception");
        }
    }

    private void displaySyntax() {
        System.out.println("Syntax:");
        System.out.println("astor <action> <-h hostname>");
        System.out.println();
        System.out.println("Actions:");
        System.out.println("\tstart: will start all servers");
        System.out.println("\tstop : will stop  all servers");
        System.out.println();
        System.out.println("hostname: host to do it \n");
        System.out.println("i.e.: astor start -h alpha    (starts all servers on host alpha)");
        System.out.println("or    astor start -h all      (starts all servers on all controled hosts)");
    }

    public AstorCmdLine(int n, String string) {
        boolean bl = true;
        try {
            switch (n) {
                case 0: {
                    bl = false;
                }
                case 1: {
                    DeviceProxy[] deviceProxyArray = this.getDeviceList(string);
                    if (deviceProxyArray.length == 0) {
                        Except.throw_exception((String)"NO_DEVICES", (String)("No device found for " + string), (String)("DbPollPanel.CmdLineSolution(" + string + ")"));
                    }
                    System.out.println("Polled Attributes For " + string);
                    this.displayAndConfirm(deviceProxyArray, bl);
                }
            }
        }
        catch (Exception exception) {
            Except.print_exception((Exception)exception);
        }
    }

    private void displayAndConfirm(DeviceProxy[] deviceProxyArray, boolean bl) throws DevFailed, IOException {
        byte[] byArray = new byte[80];
        for (int i = 0; i < deviceProxyArray.length; ++i) {
            System.out.println(deviceProxyArray[i].get_name());
            PolledAttr[] polledAttrArray = this.getPolledAttributes(deviceProxyArray[i]);
            boolean[] blArray = new boolean[polledAttrArray.length];
            for (int j = 0; j < polledAttrArray.length; ++j) {
                blArray[j] = bl;
                if (bl) continue;
                System.out.print("   - " + polledAttrArray[j]);
                System.out.print("  -  Remove polling (y/n) ? ");
                System.in.read(byArray);
                blArray[j] = byArray[0] == 121 || byArray[0] == 89;
            }
            this.removePolling(deviceProxyArray[i], polledAttrArray, blArray);
        }
    }

    private void removePolling(DeviceProxy deviceProxy, PolledAttr[] polledAttrArray, boolean[] blArray) throws DevFailed {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < polledAttrArray.length; ++i) {
            if (blArray[i]) continue;
            vector.add(polledAttrArray[i].name);
            vector.add(polledAttrArray[i].period);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        DbDatum dbDatum = new DbDatum(PollAttProp);
        dbDatum.insert(stringArray);
        deviceProxy.put_property(new DbDatum[]{dbDatum});
        for (int i = 0; i < polledAttrArray.length; ++i) {
            if (!blArray[i]) continue;
            System.out.println(polledAttrArray[i].name + " ..... Polling Removed");
        }
    }

    private DeviceProxy[] getDeviceList(String string) throws DevFailed {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        DbServer dbServer = new DbServer(string);
        for (String string2 : stringArray = dbServer.get_class_list()) {
            String[] stringArray2;
            for (String string3 : stringArray2 = dbServer.get_device_name(string2)) {
                vector.add(string3);
            }
        }
        String[] stringArray3 = new DeviceProxy[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray3[i] = new DeviceProxy((String)vector.get(i));
        }
        return stringArray3;
    }

    public PolledAttr[] getPolledAttributes(DeviceProxy deviceProxy) throws DevFailed {
        DbDatum dbDatum = deviceProxy.get_property(PollAttProp);
        String[] stringArray = dbDatum.extractStringArray();
        if (stringArray == null) {
            return new PolledAttr[0];
        }
        Vector<PolledAttr> vector = new Vector<PolledAttr>();
        for (int i = 0; i < stringArray.length; i += 2) {
            vector.add(new PolledAttr(stringArray[i], stringArray[i + 1]));
        }
        PolledAttr[] polledAttrArray = new PolledAttr[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            polledAttrArray[i] = (PolledAttr)vector.get(i);
        }
        return polledAttrArray;
    }

    class PolledAttr {
        String name;
        String period;

        public PolledAttr(String string, String string2) {
            this.name = string;
            this.period = string2;
        }

        public String toString() {
            return this.name + "   (" + this.period + " ms)";
        }
    }
}

