/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Line
extends Roi {
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    public double x1d;
    public double y1d;
    public double x2d;
    public double y2d;
    private double x1R;
    private double y1R;
    private double x2R;
    private double y2R;
    private static int lineWidth = 1;
    private double xHandleOffset;
    private double yHandleOffset;
    private double startxd;
    private double startyd;

    public Line(int ox1, int oy1, int ox2, int oy2) {
        super(ox1, oy1, null);
        this.type = 5;
        this.startxd = this.startX;
        this.startyd = this.startY;
        this.grow(ox2, oy2);
        this.x1d = (double)this.x + this.x1R;
        this.y1d = (double)this.y + this.y1R;
        this.x2d = (double)this.x + this.x2R;
        this.y2d = (double)this.y + this.y2R;
        this.x1 = (int)this.x1d;
        this.y1 = (int)this.y1d;
        this.x2 = (int)this.x2d;
        this.y2 = (int)this.y2d;
        this.state = 3;
    }

    public Line(int sx, int sy, ImagePlus imp) {
        super(sx, sy, imp);
        this.startxd = this.ic.offScreenXD(sx);
        this.startyd = this.ic.offScreenYD(sy);
        this.x1R = this.x2R = this.startxd - (double)this.startX;
        this.y1R = this.y2R = this.startyd - (double)this.startY;
        this.type = 5;
    }

    public Line(int ox1, int oy1, int ox2, int oy2, ImagePlus imp) {
        this(ox1, oy1, ox2, oy2);
        this.setImage(imp);
    }

    protected void grow(int sx, int sy) {
        double yend;
        double xend = this.ic != null ? this.ic.offScreenXD(sx) : (double)sx;
        double d = yend = this.ic != null ? this.ic.offScreenYD(sy) : (double)sy;
        if (xend < 0.0) {
            xend = 0.0;
        }
        if (yend < 0.0) {
            yend = 0.0;
        }
        if (xend > (double)this.xMax) {
            xend = this.xMax;
        }
        if (yend > (double)this.yMax) {
            yend = this.yMax;
        }
        double xstart = (double)this.x + this.x1R;
        double ystart = (double)this.y + this.y1R;
        if (this.constrain) {
            double dy;
            double dx = Math.abs(xend - xstart);
            if (dx >= (dy = Math.abs(yend - ystart))) {
                yend = ystart;
            } else {
                xend = xstart;
            }
        }
        this.x = (int)Math.min((double)this.x + this.x1R, xend);
        this.y = (int)Math.min((double)this.y + this.y1R, yend);
        this.x1R = xstart - (double)this.x;
        this.y1R = ystart - (double)this.y;
        this.x2R = xend - (double)this.x;
        this.y2R = yend - (double)this.y;
        this.width = (int)Math.abs(this.x2R - this.x1R);
        this.height = (int)Math.abs(this.y2R - this.y1R);
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        this.updateClipRect();
        if (this.imp != null) {
            if (lineWidth == 1) {
                this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            } else {
                this.imp.draw();
            }
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    void move(int sx, int sy) {
        int xNew = this.ic.offScreenX(sx);
        int yNew = this.ic.offScreenY(sy);
        this.x = (int)((double)this.x + ((double)xNew - this.startxd));
        this.y = (int)((double)this.y + ((double)yNew - this.startyd));
        this.clipboard = null;
        this.startxd = xNew;
        this.startyd = yNew;
        if (lineWidth == 1) {
            this.updateClipRect();
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        } else {
            this.imp.draw();
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void moveHandle(int sx, int sy) {
        double dy;
        double dx;
        double ox = this.ic.offScreenXD(sx);
        double oy = this.ic.offScreenYD(sy);
        this.x1d = (double)this.x + this.x1R;
        this.y1d = (double)this.y + this.y1R;
        this.x2d = (double)this.x + this.x2R;
        this.y2d = (double)this.y + this.y2R;
        switch (this.activeHandle) {
            case 0: {
                this.x1d = ox;
                this.y1d = oy;
                break;
            }
            case 1: {
                this.x2d = ox;
                this.y2d = oy;
                break;
            }
            case 2: {
                dx = ox - (this.x1d + (this.x2d - this.x1d) / 2.0);
                dy = oy - (this.y1d + (this.y2d - this.y1d) / 2.0);
                this.x1d += dx;
                this.y1d += dy;
                this.x2d += dx;
                this.y2d += dy;
                if (lineWidth <= 1) break;
                this.x1d += this.xHandleOffset;
                this.y1d += this.yHandleOffset;
                this.x2d += this.xHandleOffset;
                this.y2d += this.yHandleOffset;
            }
        }
        if (this.constrain) {
            dx = Math.abs(this.x1d - this.x2d);
            dy = Math.abs(this.y1d - this.y2d);
            if (this.activeHandle == 0) {
                if (dx >= dy) {
                    this.y1d = this.y2d;
                } else {
                    this.x1d = this.x2d;
                }
            } else if (this.activeHandle == 1) {
                if (dx >= dy) {
                    this.y2d = this.y1d;
                } else {
                    this.x2d = this.x1d;
                }
            }
        }
        this.x = (int)Math.min(this.x1d, this.x2d);
        this.y = (int)Math.min(this.y1d, this.y2d);
        this.x1R = this.x1d - (double)this.x;
        this.y1R = this.y1d - (double)this.y;
        this.x2R = this.x2d - (double)this.x;
        this.y2R = this.y2d - (double)this.y;
        this.width = (int)Math.abs(this.x2R - this.x1R);
        this.height = (int)Math.abs(this.y2R - this.y1R);
        this.updateClipRect();
        if (lineWidth == 1) {
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        } else {
            this.imp.draw();
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void mouseDownInHandle(int handle, int sx, int sy) {
        this.state = 4;
        this.activeHandle = handle;
        if (lineWidth <= 3) {
            this.ic.setCursor(new Cursor(1));
        }
    }

    public void draw(Graphics g) {
        g.setColor(this.instanceColor != null ? this.instanceColor : ROIColor);
        this.x1d = (double)this.x + this.x1R;
        this.y1d = (double)this.y + this.y1R;
        this.x2d = (double)this.x + this.x2R;
        this.y2d = (double)this.y + this.y2R;
        this.x1 = (int)this.x1d;
        this.y1 = (int)this.y1d;
        this.x2 = (int)this.x2d;
        this.y2 = (int)this.y2d;
        int sx1 = this.ic.screenXD(this.x1d);
        int sy1 = this.ic.screenYD(this.y1d);
        int sx2 = this.ic.screenXD(this.x2d);
        int sy2 = this.ic.screenYD(this.y2d);
        int sx3 = sx1 + (sx2 - sx1) / 2;
        int sy3 = sy1 + (sy2 - sy1) / 2;
        if (lineWidth == 1) {
            g.drawLine(sx1, sy1, sx2, sy2);
        } else {
            Polygon p = this.getPolygon();
            g.drawLine(this.ic.screenX(p.xpoints[0]), this.ic.screenY(p.ypoints[0]), this.ic.screenX(p.xpoints[1]), this.ic.screenY(p.ypoints[1]));
            g.drawLine(this.ic.screenX(p.xpoints[1]), this.ic.screenY(p.ypoints[1]), this.ic.screenX(p.xpoints[2]), this.ic.screenY(p.ypoints[2]));
            g.drawLine(this.ic.screenX(p.xpoints[2]), this.ic.screenY(p.ypoints[2]), this.ic.screenX(p.xpoints[3]), this.ic.screenY(p.ypoints[3]));
            g.drawLine(this.ic.screenX(p.xpoints[3]), this.ic.screenY(p.ypoints[3]), this.ic.screenX(p.xpoints[0]), this.ic.screenY(p.ypoints[0]));
        }
        if (this.state != 0) {
            int size2 = 2;
            this.handleColor = this.instanceColor != null ? this.instanceColor : ROIColor;
            this.drawHandle(g, sx1 - size2, sy1 - size2);
            this.handleColor = Color.white;
            this.drawHandle(g, sx2 - size2, sy2 - size2);
            this.drawHandle(g, sx3 - size2, sy3 - size2);
        }
        if (this.state != 3) {
            IJ.showStatus(this.imp.getLocationAsString(this.x2, this.y2) + ", angle=" + IJ.d2s(this.getAngle(this.x1, this.y1, this.x2, this.y2)) + ", length=" + IJ.d2s(this.getLength()));
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public double getLength() {
        if (this.imp == null || IJ.altKeyDown()) {
            return this.getRawLength();
        }
        Calibration cal = this.imp.getCalibration();
        return Math.sqrt((this.x2d - this.x1d) * cal.pixelWidth * (this.x2d - this.x1d) * cal.pixelWidth + (this.y2d - this.y1d) * cal.pixelHeight * (this.y2d - this.y1d) * cal.pixelHeight);
    }

    public double getRawLength() {
        return Math.sqrt((this.x2d - this.x1d) * (this.x2d - this.x1d) + (this.y2d - this.y1d) * (this.y2d - this.y1d));
    }

    public double[] getPixels() {
        double[] profile;
        ImageProcessor ip = this.imp.getProcessor();
        if (lineWidth == 1) {
            profile = ip.getLine(this.x1d, this.y1d, this.x2d, this.y2d);
        } else {
            ImageProcessor ip2 = this.rotateWideLine(ip);
            int width = ip2.getWidth();
            int height = ip2.getHeight();
            profile = new double[width];
            ip2.setInterpolate(false);
            for (int y = 0; y < height; ++y) {
                double[] aLine = ip2.getLine(0.0, y, width - 1, y);
                for (int i = 0; i < width; ++i) {
                    int n = i;
                    profile[n] = profile[n] + aLine[i];
                }
            }
            int i = 0;
            while (i < width) {
                int n = i++;
                profile[n] = profile[n] / (double)height;
            }
        }
        return profile;
    }

    ImageProcessor rotateWideLine(ImageProcessor ip) {
        int width = (int)Math.round(this.getRawLength());
        int height = lineWidth;
        FloatProcessor ip2 = new FloatProcessor(width, height);
        double angle = Math.atan2(this.y1d - this.y2d, this.x2d - this.x1d);
        double srcWidth = ip.getWidth();
        double srcHeight = ip.getHeight();
        Polygon p = this.getPolygon();
        int sxbase = p.xpoints[1];
        int sybase = p.ypoints[1];
        for (int dy = 0; dy < height; ++dy) {
            for (int dx = 0; dx < width; ++dx) {
                double r = Math.sqrt(dx * dx + dy * dy);
                double theta = Math.atan2(dy, dx);
                double sx = (double)sxbase + r * Math.cos(theta += angle);
                double sy = (double)sybase - r * Math.sin(theta);
                if (sx > srcWidth || sy > srcHeight || sy < 0.0 || sx < 0.0) {
                    ((ImageProcessor)ip2).putPixelValue(dx, dy, 0.0);
                    continue;
                }
                ((ImageProcessor)ip2).putPixelValue(dx, dy, ip.getInterpolatedValue(sx, sy));
            }
        }
        if (IJ.altKeyDown()) {
            ((ImageProcessor)ip2).resetMinAndMax();
            new ImagePlus("Rotated Line", ip2).show();
        }
        return ip2;
    }

    public Polygon getPolygon() {
        Polygon p = new Polygon();
        if (lineWidth == 1) {
            p.addPoint(this.x1, this.y1);
            p.addPoint(this.x2, this.y2);
        } else {
            double angle = Math.atan2(this.y1 - this.y2, this.x2 - this.x1);
            double width2 = (double)lineWidth / 2.0;
            double p1x = (double)this.x1 + Math.cos(angle + 1.5707963267948966) * width2;
            double p1y = (double)this.y1 - Math.sin(angle + 1.5707963267948966) * width2;
            double p2x = (double)this.x1 + Math.cos(angle - 1.5707963267948966) * width2;
            double p2y = (double)this.y1 - Math.sin(angle - 1.5707963267948966) * width2;
            double p3x = (double)this.x2 + Math.cos(angle - 1.5707963267948966) * width2;
            double p3y = (double)this.y2 - Math.sin(angle - 1.5707963267948966) * width2;
            double p4x = (double)this.x2 + Math.cos(angle + 1.5707963267948966) * width2;
            double p4y = (double)this.y2 - Math.sin(angle + 1.5707963267948966) * width2;
            p.addPoint((int)Math.round(p1x), (int)Math.round(p1y));
            p.addPoint((int)Math.round(p2x), (int)Math.round(p2y));
            p.addPoint((int)Math.round(p3x), (int)Math.round(p3y));
            p.addPoint((int)Math.round(p4x), (int)Math.round(p4y));
        }
        return p;
    }

    public void drawPixels(ImageProcessor ip) {
        ip.setLineWidth(1);
        if (lineWidth == 1) {
            ip.moveTo(this.x1, this.y1);
            ip.lineTo(this.x2, this.y2);
        } else {
            ip.drawPolygon(this.getPolygon());
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int x, int y) {
        if (lineWidth > 1) {
            return this.getPolygon().contains(x, y);
        }
        return false;
    }

    public int isHandle(int sx, int sy) {
        int size = 10;
        if (lineWidth > 1) {
            size += (int)Math.log(lineWidth);
        }
        int halfSize = size / 2;
        int sx1 = this.ic.screenXD((double)this.x + this.x1R) - halfSize;
        int sy1 = this.ic.screenYD((double)this.y + this.y1R) - halfSize;
        int sx2 = this.ic.screenXD((double)this.x + this.x2R) - halfSize;
        int sy2 = this.ic.screenYD((double)this.y + this.y2R) - halfSize;
        int sx3 = sx1 + (sx2 - sx1) / 2 - 1;
        int sy3 = sy1 + (sy2 - sy1) / 2 - 1;
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy1 && sy <= sy1 + size) {
            return 0;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy2 && sy <= sy2 + size) {
            return 1;
        }
        if (sx >= sx3 && sx <= sx3 + size + 2 && sy >= sy3 && sy <= sy3 + size + 2) {
            return 2;
        }
        return -1;
    }

    public static int getWidth() {
        return lineWidth;
    }

    public static void setWidth(int w) {
        if (w < 1) {
            w = 1;
        }
        if (w > 200) {
            w = 200;
        }
        lineWidth = w;
    }

    public Rectangle getBounds() {
        int xmin = (int)Math.round(Math.min(this.x1d, this.x2d));
        int ymin = (int)Math.round(Math.min(this.y1d, this.y2d));
        int w = (int)Math.round(Math.abs(this.x2d - this.x1d));
        int h = (int)Math.round(Math.abs(this.y2d - this.y1d));
        return new Rectangle(xmin, ymin, w, h);
    }

    public void nudgeCorner(int key) {
        if (this.ic == null) {
            return;
        }
        double inc = 1.0 / this.ic.getMagnification();
        switch (key) {
            case 38: {
                this.y2R -= inc;
                break;
            }
            case 40: {
                this.y2R += inc;
                break;
            }
            case 37: {
                this.x2R -= inc;
                break;
            }
            case 39: {
                this.x2R += inc;
            }
        }
        this.grow(this.ic.screenXD((double)this.x + this.x2R), this.ic.screenYD((double)this.y + this.y2R));
    }
}

