/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

public class StringSpectrumHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;

    public StringSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireValueChanged(String[] stringArray, long l) {
        this.propChanges.fireStringSpectrumEvent((IStringSpectrum)this.attribute, stringArray, l);
    }

    void insert(String[] stringArray) {
        this.attribute.getAttribute().insert(stringArray);
    }

    String[] getStringSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        String[] stringArray = deviceAttribute.extractStringArray();
        int n = deviceAttribute.getNbRead();
        if (n == stringArray.length) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    String[] getStringSpectrumSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int n;
        String[] stringArray = deviceAttribute.extractStringArray();
        int n2 = stringArray.length - (n = deviceAttribute.getNbRead());
        if (n2 <= 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        for (int i = n; i < stringArray.length; ++i) {
            stringArray2[n3] = stringArray[i];
            ++n3;
        }
        return stringArray2;
    }

    void addStringSpectrumListener(IStringSpectrumListener iStringSpectrumListener) {
        this.propChanges.addStringSpectrumListener(iStringSpectrumListener);
    }

    void removeStringSpectrumListener(IStringSpectrumListener iStringSpectrumListener) {
        this.propChanges.removeStringSpectrumListener(iStringSpectrumListener);
    }

    public String getVersion() {
        return "$Id: StringSpectrumHelper.java,v 1.8 2009/06/29 16:18:22 poncet Exp $";
    }
}

