/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;

public class DoubleSpectrumHelper
extends ANumberSpectrumHelper {
    public DoubleSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
    }

    void insert(double[] dArray) {
        double d = 1.0;
        d = this.attribute.getDisplayUnitFactor();
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        if (d == 1.0) {
            deviceAttribute.insert(dArray);
        } else {
            double[] dArray2 = new double[dArray.length];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = dArray[i] / d;
            }
            deviceAttribute.insert(dArray2);
        }
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Double(d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Double(d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Double(d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Double(d), bl);
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Double(d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Double(d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Double(d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Double(d), bl);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Double(d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Double(d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Double(d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Double(d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Double(d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Double(d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Double(d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Double(d));
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] dArray = deviceAttribute.extractDoubleArray();
        int n = deviceAttribute.getNbRead();
        if (n == dArray.length) {
            return deviceAttribute.extractDoubleArray();
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    double[] getNumberSpectrumSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int n;
        double[] dArray = deviceAttribute.extractDoubleArray();
        int n2 = dArray.length - (n = deviceAttribute.getNbRead());
        if (n2 <= 0) {
            return this.getNumberSpectrumValue(deviceAttribute);
        }
        double[] dArray2 = new double[n2];
        int n3 = 0;
        for (int i = n; i < dArray.length; ++i) {
            dArray2[n3] = dArray[i];
            ++n3;
        }
        return dArray2;
    }

    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int n = deviceAttribute.getNbRead();
        double d = this.attribute.getDisplayUnitFactor();
        double[] dArray = deviceAttribute.extractDoubleArray();
        if (dArray.length == n && d == 1.0) {
            return deviceAttribute.extractDoubleArray();
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] * d;
        }
        return dArray2;
    }

    double[] getNumberSpectrumDisplaySetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] dArray = deviceAttribute.extractDoubleArray();
        int n = deviceAttribute.getNbRead();
        int n2 = dArray.length - n;
        double d = this.attribute.getDisplayUnitFactor();
        if (n2 <= 0) {
            return this.getNumberSpectrumDisplayValue(deviceAttribute);
        }
        double[] dArray2 = new double[n2];
        int n3 = 0;
        for (int i = n; i < dArray.length; ++i) {
            dArray2[n3] = dArray[i] * d;
            ++n3;
        }
        return dArray2;
    }

    public String getVersion() {
        return "$Id: DoubleSpectrumHelper.java,v 1.14 2009/06/25 18:06:50 poncet Exp $";
    }
}

