/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;
import fr.esrf.tangoatk.core.attribute.NumberAttributeHelper;

class DoubleImageHelper
extends ANumberImageHelper {
    public DoubleImageHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    protected void insert(double[][] dArray) {
        double d = 1.0;
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        d = this.attribute.getDisplayUnitFactor();
        double[] dArray2 = NumberAttributeHelper.flatten(dArray);
        if (d == 1.0) {
            deviceAttribute.insert(dArray2, dArray[0].length, dArray.length);
            return;
        }
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray2[i] / d;
        }
        deviceAttribute.insert(dArray3, dArray[0].length, dArray.length);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Double(d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Double(d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Double(d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Double(d), bl);
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Double(d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Double(d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Double(d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Double(d), bl);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Double(d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Double(d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Double(d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Double(d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Double(d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Double(d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Double(d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Double(d));
    }

    double[][] getNumberImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] dArray = deviceAttribute.extractDoubleArray();
        int n = deviceAttribute.getDimY();
        int n2 = deviceAttribute.getDimX();
        if (n != this.retval.length || this.retval.length == 0 || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = dArray[n3++];
            }
        }
        return this.retval;
    }

    double[][] getNumberImageDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] dArray = deviceAttribute.extractDoubleArray();
        double d = this.attribute.getDisplayUnitFactor();
        int n = deviceAttribute.getDimY();
        int n2 = deviceAttribute.getDimX();
        if (n != this.retval.length || this.retval.length == 0 || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = dArray[n3++] * d;
            }
        }
        return this.retval;
    }

    String[][] getImageValueAsString(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] dArray = deviceAttribute.extractDoubleArray();
        int n = deviceAttribute.getDimY();
        int n2 = deviceAttribute.getDimX();
        String[][] stringArray = new String[n][n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j] = Double.toString(dArray[n3++]);
            }
        }
        return stringArray;
    }

    public String getVersion() {
        return "$Id: DoubleImageHelper.java,v 1.16 2009/06/25 18:06:50 poncet Exp $";
    }
}

