/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class DevStateSpectrumHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;

    public DevStateSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireDevStateSpectrumValueChanged(String[] stringArray, long l) {
        this.propChanges.fireDevStateSpectrumEvent((IDevStateSpectrum)this.attribute, stringArray, l);
    }

    void insert(String[] stringArray) {
        DevState[] devStateArray = new DevState[stringArray.length];
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        for (int i = 0; i < stringArray.length; ++i) {
            devStateArray[i] = Device.getStateFromString(stringArray[i]);
        }
        deviceAttribute.insert(devStateArray);
    }

    String[] getStateSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        String[] stringArray = null;
        DevState[] devStateArray = null;
        devStateArray = deviceAttribute.extractDevStateArray();
        int n = deviceAttribute.getNbRead();
        stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Device.toString(devStateArray[i]);
        }
        return stringArray;
    }

    String[] getStateSpectrumSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int n;
        DevState[] devStateArray = null;
        String[] stringArray = null;
        devStateArray = deviceAttribute.extractDevStateArray();
        int n2 = devStateArray.length - (n = deviceAttribute.getNbRead());
        if (n2 <= 0) {
            return this.getStateSpectrumValue(deviceAttribute);
        }
        stringArray = new String[n2];
        int n3 = 0;
        for (int i = n; i < devStateArray.length; ++i) {
            stringArray[n3] = Device.toString(devStateArray[i]);
            ++n3;
        }
        return stringArray;
    }

    void addDevStateSpectrumListener(IDevStateSpectrumListener iDevStateSpectrumListener) {
        this.propChanges.addDevStateSpectrumListener(iDevStateSpectrumListener);
    }

    void removeDevStateSpectrumListener(IDevStateSpectrumListener iDevStateSpectrumListener) {
        this.propChanges.removeDevStateSpectrumListener(iDevStateSpectrumListener);
    }

    public String getVersion() {
        return "$Id: DevStateSpectrumHelper.java,v 1.4 2009/06/29 16:18:22 poncet Exp $";
    }
}

