/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;

public class ATKException
extends Exception {
    private DevError[] errors = new DevError[0];
    private Object source = null;
    public static String[] severity = new String[]{"WARNING", "ERROR", "PANIC"};
    public static final int WARNING = 0;
    public static final int ERROR = 1;
    public static final int PANIC = 2;

    public ATKException() {
        this.source = this;
    }

    public ATKException(String string) {
        super(string);
        this.source = this;
    }

    public ATKException(DevFailed devFailed) {
        this.setStackTrace(devFailed.getStackTrace());
        this.source = devFailed;
        if (devFailed.errors != null) {
            this.errors = devFailed.errors;
        } else {
            System.out.println("ATKException.ATKException() : Cannot handle DevFailed with null stack.");
        }
    }

    public ATKException(Exception exception) {
        super(exception.getMessage());
        this.source = exception;
        this.setStackTrace(exception.getStackTrace());
    }

    public void setError(DevFailed devFailed) {
        this.setStackTrace(devFailed.getStackTrace());
        this.source = devFailed;
        if (devFailed.errors != null) {
            this.errors = devFailed.errors;
        } else {
            System.out.println("ATKException.setError() : Cannot handle DevFailed with null stack.");
        }
    }

    public DevError[] getErrors() {
        return this.errors;
    }

    public String getMessage() {
        String string = this.toString();
        if (string == null) {
            return this.getSourceName();
        }
        return string;
    }

    public int getSeverity() {
        return this.getSeverity(0);
    }

    public int getSeverity(int n) {
        try {
            return this.errors[n].severity.value();
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public String getDescription() {
        if (this.errors.length == 0) {
            return this.getMessage();
        }
        return this.getDescription(0);
    }

    public String getDescription(int n) {
        try {
            return this.errors[n].desc.trim();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getOrigin() {
        return this.getOrigin(0);
    }

    public String getOrigin(int n) {
        try {
            return this.errors[n].origin.trim();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getReason() {
        return this.getReason(0);
    }

    public String getReason(int n) {
        try {
            return this.errors[n].reason.trim();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getStackLength() {
        return this.errors.length;
    }

    public String getSourceName() {
        String string = this.source.getClass().toString();
        return string.substring(6);
    }

    public String toString() {
        if (this.errors.length == 0) {
            return super.getMessage();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.errors.length; ++i) {
            DevError devError = this.errors[i];
            stringBuffer.append("Severity: ");
            stringBuffer.append(severity[devError.severity.value()]);
            stringBuffer.append("\nOrigin: ");
            stringBuffer.append(devError.origin.trim());
            stringBuffer.append("\nDescription: ");
            stringBuffer.append(devError.desc.trim());
            stringBuffer.append("\nReason: ");
            stringBuffer.append(devError.reason.trim());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getVersion() {
        return "$Id: ATKException.java,v 1.9 2009/01/26 17:54:41 poncet Exp $";
    }
}

