//=============================================================================
//
// file :        AccessControl.h
//
// description : Include for the AccessControl class.
//
// project :	cess Control abstract class
//
// $Author: taurel $
//
// $Revision: 1.2 $
//
// $Log: AccessControl.h,v $
// Revision 1.2  2009/04/06 13:38:17  taurel
// - Ported to Tango 7
//
// Revision 1.1.1.1  2006/09/15 11:52:57  pascal_verdier
// Initial Revision
//
//
// copyleft :    European Synchrotron Radiation Facility
//               BP 220, Grenoble 38043
//               FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================
#ifndef _ACCESSCONTROL_H
#define _ACCESSCONTROL_H

#include <tango.h>
//using namespace Tango;

/**
 * @author	$Author: taurel $
 * @version	$Revision: 1.2 $
 */

 //	Add your own constants definitions here.
 //-----------------------------------------------


namespace AccessControl_ns
{

/**
 * Class Description:
 * This class defines how to manage the TANGO access control.
 *	It interfaces commands for tool to defines access for users, devices and IP addresses.
 *	It interfaces also commands used by client API to check access for specified user, device and address.
 *	And it insterfaces to register and unregister it as TANGO service.
 */

/*
 *	Device States Description:
 *  Tango::ON :     The MySql database handle is OK.
 *  Tango::FAULT :  The MySql database handle is not OK.
 */


class AccessControl: public Tango::Device_4Impl
{
public :
	//	Add your own data members here
	//-----------------------------------------


	//	Here is the Start of the automatic code generation part
	//-------------------------------------------------------------	
/**
 *	@name attributes
 *	Attributs member data.
 */
//@{
//@}

/**
 *	@name Device properties
 *	Device properties member data.
 */
//@{
//@}

/**@name Constructors
 * Miscellaneous constructors */
//@{
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	AccessControl(Tango::DeviceClass *cl,string &s):Device_4Impl(cl,s) {};
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	AccessControl(Tango::DeviceClass *cl,const char *s):Device_4Impl(cl,s) {};
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device name
 *	@param d	Device description.
 */
	AccessControl(Tango::DeviceClass *cl,const char *s,const char *d):Device_4Impl(cl,s,d) {};
//@}

/**
 * @name AccessControl methods prototypes
 */

//@{
/**
 *	Execution allowed for AddAddressForUser command.
 */
	virtual bool is_AddAddressForUser_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for AddDeviceForUser command.
 */
	virtual bool is_AddDeviceForUser_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for CloneUser command.
 */
	virtual bool is_CloneUser_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for GetAccess command.
 */
	virtual bool is_GetAccess_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for GetAddressByUser command.
 */
	virtual bool is_GetAddressByUser_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for GetAllowedCommands command.
 */
	virtual bool is_GetAllowedCommands_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for GetDeviceByUser command.
 */
	virtual bool is_GetDeviceByUser_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for GetDeviceClass command.
 */
	virtual bool is_GetDeviceClass_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for GetUsers command.
 */
	virtual bool is_GetUsers_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for RemoveAddressForUser command.
 */
	virtual bool is_RemoveAddressForUser_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for RemoveDeviceForUser command.
 */
	virtual bool is_RemoveDeviceForUser_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for RemoveUser command.
 */
	virtual bool is_RemoveUser_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for RegisterService command.
 */
	virtual bool is_RegisterService_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for UnregisterService command.
 */
	virtual bool is_UnregisterService_allowed(const CORBA::Any &any){ return true; };
/**
 * Add an address for the specified user..
 *	@param	argin	user name, address
 *	@exception DevFailed
 */
	virtual void	add_address_for_user(const Tango::DevVarStringArray *) = 0;
/**
 * Add a device and rights for the specified user..
 *	@param	argin	user name, device adn value
 *	@exception DevFailed
 */
	virtual void	add_device_for_user(const Tango::DevVarStringArray *) = 0;
/**
 * Copy addresses and devices from source user to target user.
 *	@param	argin	[0] - source user name.\n[1] - target user name.
 *	@exception DevFailed
 */
	virtual void	clone_user(const Tango::DevVarStringArray *) = 0;
/**
 * Check access for specified user, device, address and returns access (read or write).
 *	@param	argin	[0] - User name\n[1] - Device\n[2] - IP Address
 *	@return	cess for specified inputs.
 *	@exception DevFailed
 */
	virtual Tango::DevString	get_access(const Tango::DevVarStringArray *) = 0;
/**
 * Returns address list  found for the specified user.
 *	@param	argin	user name.
 *	@return	Addresses found for the specified user.
 *	@exception DevFailed
 */
	virtual Tango::DevVarStringArray	*get_address_by_user(Tango::DevString) = 0;
/**
 * Returns allowed command list found in database for specified device
 *	It search the class of the specified device and then uses the class property <b>AllowedAccessCmd</b>
 *	@param	argin	Device name
 *	@return	Allowed commands found in database for specified device
 *	@exception DevFailed
 */
	virtual Tango::DevVarStringArray	*get_allowed_commands(Tango::DevString) = 0;
/**
 * Returns devices and rights found for the specified user.
 *	@param	argin	user name.
 *	@return	devices and rights found for the specified user.
 *	@exception DevFailed
 */
	virtual Tango::DevVarStringArray	*get_device_by_user(Tango::DevString) = 0;
/**
 * Returns class for specified device.
 *	@param	argin	Device name
 *	@return	Class found in database for specified device
 *	@exception DevFailed
 */
	virtual Tango::DevString	get_device_class(Tango::DevString) = 0;
/**
 * Returns user list found in table access_address.
 *	@return	Users find in table access_address.
 *	@exception DevFailed
 */
	virtual Tango::DevVarStringArray	*get_users() = 0;
/**
 * Remove an address for the specified user..
 *	@param	argin	user name, address
 *	@exception DevFailed
 */
	virtual void	remove_address_for_user(const Tango::DevVarStringArray *) = 0;
/**
 * Remove a device and its rights for the specified user..
 *	@param	argin	user name, device and value
 *	@exception DevFailed
 */
	virtual void	remove_device_for_user(const Tango::DevVarStringArray *) = 0;
/**
 * Remove all records for specified user.
 *	@param	argin	user name
 *	@exception DevFailed
 */
	virtual void	remove_user(Tango::DevString) = 0;
/**
 * Register device as a TANGO service.
 *	@exception DevFailed
 */
	virtual void	register_service() = 0;
/**
 * Unregister device as a TANGO service.
 *	@exception DevFailed
 */
	virtual void	unregister_service() = 0;

//@}

	//	Here is the end of the automatic code generation part
	//-------------------------------------------------------------	



protected :	
	//	Add your own data members here
	//-----------------------------------------
};

}	// namespace_ns

#endif	// _ACCESSCONTROL_H
