/*
 * Decompiled with CFR 0.152.
 */
package app_util;

import fr.esrf.Tango.DevFailed;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorWindow
extends JDialog {
    private final int ErrorTxtMaxSize = 65536;
    private JPanel jPanel1;
    private JButton dismissBtn;
    private JLabel jLabel1;
    private JButton clearBtn;
    private JScrollPane jScrollPane1;
    private JTextArea errorText;

    public ErrorWindow(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.dismissBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.clearBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.errorText = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ErrorWindow.this.closeDialog(evt);
            }
        });
        this.dismissBtn.setText("Dismiss");
        this.dismissBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ErrorWindow.this.dismissBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.dismissBtn);
        this.jLabel1.setText("                    ");
        this.jPanel1.add(this.jLabel1);
        this.clearBtn.setText("Clear Messages");
        this.clearBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ErrorWindow.this.clearBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.clearBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jScrollPane1.setPreferredSize(new Dimension(700, 400));
        this.errorText.setEditable(false);
        this.jScrollPane1.setViewportView(this.errorText);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void clearBtnActionPerformed(ActionEvent evt) {
        this.errorText.setText("");
    }

    private void dismissBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ErrorWindow((Frame)new JFrame(), true).setVisible(true);
    }

    public void append(String message) {
        String old_text = this.errorText.getText();
        if (old_text.length() > 65536) {
            int end = old_text.indexOf("\n", 32768);
            old_text = old_text.substring(0, end);
            this.errorText.setText(old_text);
        }
        String new_text = "=============== " + new Date().toString() + " ================\n" + message + "\n\n";
        this.errorText.insert(new_text, 0);
    }

    public void append(Exception e) {
        this.append(e.toString());
    }

    public void append(DevFailed e) {
        StringBuffer sb = new StringBuffer(e.toString() + ":\n");
        for (int i = 0; i < e.errors.length; ++i) {
            sb.append(e.errors[i].reason + " from " + e.errors[i].origin + "\n");
            sb.append(e.errors[i].desc);
            if (i >= e.errors.length - 1) continue;
            sb.append("\n-------------------------------------------------------------\n");
        }
        this.append(sb.toString());
    }

    private String getStackTrace(Exception e) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(stream);
        e.printStackTrace(ps);
        return stream.toString();
    }

    public void appendStackTrace(Exception e) {
        this.append(this.getStackTrace(e));
    }
}

