/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.DevBrowserTree;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class TreePopupMenu
extends JPopupMenu {
    private DevBrowserTree parent;
    private static final int CHANGE = 0;
    private static final int PERIODIC = 1;
    private static final int ARCHIVE = 2;
    public static final int MODE_DEVICE = 0;
    public static final int MODE_ATTR = 1;
    public static final int MODE_SERVER = 2;
    private static String[] attLabels = new String[]{"Manage Polling", null, "Subscribe on Change  Event", "Subscribe on Periodic Event", "Subscribe on Archive  Event", null, null, "Edit Change  Event Properties", "Edit Periodic Event Properties", "Edit Archive  Event Properties"};
    private static String[] devLabels = new String[]{"Test Device", "MonitorDevice", "Host Panel", "Manage Polling", "Polling Profiler", "Go To Server Node"};
    private static String[] servLabels = new String[]{"Test Admin Device", "Host Panel", "Server Architecture", "Polling Profiler"};
    private static final int OFFSET = 2;
    private static final int ATT_POLLING = 0;
    private static final int ATT_ADD_CHANGE = 2;
    private static final int ATT_ADD_PERIODIC = 3;
    private static final int ATT_ADD_ARCHIVE = 4;
    private static final int ATT_ED_CHANGE = 7;
    private static final int ATT_ED_PERIODIC = 8;
    private static final int ATT_ED_ARCHIVE = 9;
    private static final int DEV_TEST = 0;
    private static final int DEV_MONITOR = 1;
    private static final int DEV_HOST_PANEL = 2;
    private static final int DEV_POLLING = 3;
    private static final int DEV_PROFILER = 4;
    private static final int DEV_GOTO_SERVER = 5;
    private static final int SERV_TEST = 0;
    private static final int SERV_HOST_PANEL = 1;
    private static final int SERV_ARCHI = 2;
    private static final int SERV_PROFILER = 3;
    private int mode;
    private JLabel title;

    public TreePopupMenu(DevBrowserTree devBrowserTree, int n) {
        this.parent = devBrowserTree;
        this.mode = n;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        this.title = new JLabel("Attribute :");
        this.title.setFont(new Font("Dialog", 1, 16));
        this.add(this.title);
        this.add(new JPopupMenu.Separator());
        String[] stringArray = this.mode == 1 ? attLabels : (this.mode == 0 ? devLabels : servLabels);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                this.add(new JPopupMenu.Separator());
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TreePopupMenu.this.hostActionPerformed(actionEvent);
                }
            });
            this.add(jMenuItem);
        }
    }

    public void showMenu(MouseEvent mouseEvent) {
        this.showMenu(mouseEvent, false, true);
    }

    public void showMenu(MouseEvent mouseEvent, boolean bl, boolean bl2) {
        TreePath treePath = this.parent.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        this.parent.setSelectionPath(treePath);
        if (this.mode == 1) {
            this.title.setText("Attribute: " + this.parent.getSelectedName());
        } else if (this.mode == 0) {
            this.title.setText("Device: " + this.parent.getSelectedName());
            String string = this.parent.getCollection();
            this.getComponent(6).setEnabled(bl);
            this.getComponent(7).setVisible(string.equals("Devices") || string.equals("Aliases"));
            if (!bl2) {
                this.getComponent(2).setEnabled(false);
                this.getComponent(3).setEnabled(false);
                this.getComponent(5).setEnabled(false);
                this.getComponent(6).setEnabled(false);
            }
        } else if (this.mode == 2) {
            this.title.setText("Server: " + this.parent.getSelectedName());
            this.getComponent(5).setEnabled(bl);
            if (!bl2) {
                this.getComponent(5).setEnabled(false);
                this.getComponent(4).setEnabled(false);
                this.getComponent(2).setEnabled(false);
            }
        }
        this.show(this.parent, mouseEvent.getX(), mouseEvent.getY());
    }

    private void hostActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.mode == 1) {
            if (string.equals(attLabels[0])) {
                this.parent.managePolling();
            } else if (string.equals(attLabels[2])) {
                this.parent.add(0);
            } else if (string.equals(attLabels[3])) {
                this.parent.add(1);
            } else if (string.equals(attLabels[4])) {
                this.parent.add(2);
            } else if (string.equals(attLabels[7])) {
                this.parent.editProperties(0);
            } else if (string.equals(attLabels[8])) {
                this.parent.editProperties(1);
            } else if (string.equals(attLabels[9])) {
                this.parent.editProperties(2);
            }
        } else if (this.mode == 0) {
            if (string.equals(devLabels[0])) {
                this.parent.deviceTest();
            } else if (string.equals(devLabels[1])) {
                this.parent.deviceMonitor();
            } else if (string.equals(devLabels[2])) {
                this.parent.displayHostPanel();
            } else if (string.equals(devLabels[3])) {
                this.parent.managePolling();
            } else if (string.startsWith(devLabels[4])) {
                this.parent.showProfiler();
            } else if (string.startsWith(devLabels[5])) {
                this.parent.gotoServer();
            }
        } else if (this.mode == 2) {
            if (string.equals(servLabels[0])) {
                this.parent.deviceTest();
            } else if (string.equals(servLabels[1])) {
                this.parent.displayHostPanel();
            } else if (string.equals(servLabels[2])) {
                this.parent.serverArchitecture();
            } else if (string.equals(servLabels[3])) {
                this.parent.showProfiler();
            }
        }
    }
}

