/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.SubscribedSignal;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HistoryDialog
extends JDialog
implements IJLChartListener {
    private JLChart chart = new JLChart();
    private SubscribedSignal signal;
    private JButton cancelBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel titleLabel;

    public HistoryDialog(JDialog jDialog, SubscribedSignal subscribedSignal) {
        super((Dialog)jDialog, false);
        this.signal = subscribedSignal;
        this.initComponents();
        this.initOwnComponents();
        this.titleLabel.setText("Events History for " + subscribedSignal.name);
        this.pack();
    }

    private void initOwnComponents() {
        Object object;
        this.chart.setBackground(Color.white);
        this.chart.setChartBackground(Color.lightGray);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.setHeader("History");
        this.chart.setLabelFont(new Font("Dialog", 1, 12));
        this.chart.getY1Axis().setName("Read Value");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getXAxis().setName("Time");
        this.chart.getXAxis().setGridVisible(true);
        this.chart.setPreferredSize(new Dimension(800, 600));
        this.chart.setJLChartListener((IJLChartListener)this);
        this.getContentPane().add((Component)this.chart, "Center");
        int n = 0;
        for (int i = 0; n == 0 && i < this.signal.histo.size(); ++i) {
            object = (SubscribedSignal.EventHisto)this.signal.histo.get(i);
            if (object.values == null) continue;
            n = object.values.length;
        }
        AstorUtil astorUtil = AstorUtil.getInstance();
        astorUtil.initColors(n);
        object = new JLDataView[n];
        for (int i = 0; i < n; ++i) {
            object[i] = new JLDataView();
            object[i].setColor(astorUtil.getNewColor());
            object[i].setName("Values[" + i + "]");
            object[i].setLabelVisible(false);
            object[i].setMarker(8);
            JLAxis jLAxis = this.chart.getY1Axis();
            jLAxis.addDataView(object[i]);
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.signal.histo.size(); ++i) {
            SubscribedSignal.EventHisto eventHisto = (SubscribedSignal.EventHisto)this.signal.histo.get(i);
            if (eventHisto.values == null) continue;
            double d4 = 0.0;
            for (int j = 0; j < eventHisto.values.length; ++j) {
                d = eventHisto.time;
                d2 = eventHisto.values[j];
                if (d2 > d4) {
                    d4 = d2;
                }
                this.chart.addData(object[j], d, d2);
            }
        }
    }

    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        JLDataView jLDataView = jLChartEvent.getDataView();
        int n = jLChartEvent.getDataViewIndex();
        DataList dataList = jLDataView.getData();
        for (int i = 0; i < n; ++i) {
            dataList = dataList.next;
        }
        String[] stringArray = new String[4];
        stringArray[0] = new Date((long)dataList.x).toString();
        stringArray[1] = "Value = " + SubscribedSignal.formatValue(dataList.y);
        SubscribedSignal.EventHisto eventHisto = (SubscribedSignal.EventHisto)this.signal.histo.get(n);
        stringArray[2] = "Delta Value = " + eventHisto.d_value;
        stringArray[3] = "Delta time  = " + eventHisto.d_time;
        return stringArray;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HistoryDialog.this.closeDialog(windowEvent);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HistoryDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
    }
}

