/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.MkStarter;
import admin.astor.PropListDialog;
import admin.astor.TangoHost;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class NewStarterDialog
extends JDialog
implements AstorDefs {
    private Astor parent;
    private TangoHost[] hosts;
    private TangoHost h;
    private String[] collec;
    private int retVal = 2;
    private boolean creating;
    private JPanel jPanel1;
    private JButton createBtn;
    private JLabel jLabel1;
    private JButton cancelBtn;
    private JPanel jPanel3;
    private JLabel jLabel3;
    private JPanel jPanel4;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField hostText;
    private JLabel jLabel2;
    private JTextField familyText;
    private JButton pathBtn;
    private JButton familyBtn;
    private JScrollPane jScrollPane1;
    private JTextArea pathText;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JTextField usageText;
    private JRadioButton useEventsBtn;

    private boolean getUseEvents() {
        boolean bl = false;
        try {
            DbDatum dbDatum = this.h.get_property("UseEvents");
            if (!dbDatum.is_empty()) {
                bl = dbDatum.extractBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public NewStarterDialog(Astor astor, TangoHost tangoHost, String[] stringArray, TangoHost[] tangoHostArray, boolean bl) {
        super((Frame)astor, true);
        this.parent = astor;
        this.hosts = tangoHostArray;
        this.creating = bl;
        this.collec = new String[stringArray.length - 1];
        for (int i = 1; i < stringArray.length; ++i) {
            this.collec[i - 1] = stringArray[i];
        }
        this.initComponents();
        this.h = tangoHost;
        if (tangoHost != null) {
            String[] stringArray2;
            String string = tangoHost.getName();
            for (String string2 : stringArray2 = tangoHost.getPath()) {
                this.pathText.append(string2 + "\n");
            }
            this.usageText.setText(tangoHost.usage);
            this.familyText.setText(tangoHost.getFamily());
            this.hostText.setText(string);
            this.useEventsBtn.setSelected(this.getUseEvents());
            if (bl) {
                this.familyText.setText(tangoHost.getFamily());
                this.hostText.setText(string);
                this.hostText.select(0, string.length());
            } else {
                this.jLabel3.setText("Change property for " + string + " starter in database");
                this.jLabel2.setText("  ");
                this.hostText.setVisible(false);
                this.jLabel4.setVisible(false);
                this.familyText.setVisible(false);
                this.familyBtn.setVisible(false);
                this.createBtn.setText("Apply");
            }
        }
        this.pack();
        AstorUtil.centerDialog((JDialog)this, astor);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.createBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.cancelBtn = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.hostText = new JTextField();
        this.jLabel2 = new JLabel();
        this.familyText = new JTextField();
        this.pathBtn = new JButton();
        this.familyBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.pathText = new JTextArea();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.usageText = new JTextField();
        this.useEventsBtn = new JRadioButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NewStarterDialog.this.closeDialog(windowEvent);
            }
        });
        this.createBtn.setText("Create");
        this.createBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewStarterDialog.this.createBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.createBtn);
        this.jLabel1.setText("          ");
        this.jPanel1.add(this.jLabel1);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewStarterDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jLabel3.setFont(new Font("Dialog", 1, 14));
        this.jLabel3.setText("Create a Starter in Database For a New Host");
        this.jPanel3.add(this.jLabel3);
        this.getContentPane().add((Component)this.jPanel3, "North");
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel4.setText("Host name :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Device Servers PATH :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.jLabel5, gridBagConstraints);
        this.hostText.setColumns(20);
        this.hostText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewStarterDialog.this.hostTextActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.hostText, gridBagConstraints);
        this.jLabel2.setText("Host Family:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this.familyText.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.familyText, gridBagConstraints);
        this.pathBtn.setText("...");
        this.pathBtn.setMargin(new Insets(2, 5, 2, 5));
        this.pathBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewStarterDialog.this.pathBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        this.jPanel4.add((Component)this.pathBtn, gridBagConstraints);
        this.familyBtn.setText("...");
        this.familyBtn.setMargin(new Insets(2, 5, 2, 5));
        this.familyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewStarterDialog.this.familyBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        this.jPanel4.add((Component)this.familyBtn, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 180));
        this.jScrollPane1.setViewportView(this.pathText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel6.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.jPanel4.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("   ");
        this.jLabel7.setPreferredSize(new Dimension(220, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        this.jPanel4.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText("Host Usage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.jLabel8, gridBagConstraints);
        this.usageText.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.usageText, gridBagConstraints);
        this.useEventsBtn.setText("Use Events");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.useEventsBtn, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel4, "Center");
        this.pack();
    }

    private void hostTextActionPerformed(ActionEvent actionEvent) {
    }

    private void familyBtnActionPerformed(ActionEvent actionEvent) {
        PropListDialog propListDialog = new PropListDialog(this.parent, this.collec);
        propListDialog.showDialog();
        String string = propListDialog.getSelectedItem();
        if (string != null) {
            this.familyText.setText(string);
        }
    }

    private void pathBtnActionPerformed(ActionEvent actionEvent) {
        new PropListDialog(this.parent, this.pathText, this.hosts).showDialog();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void createBtnActionPerformed(ActionEvent actionEvent) {
        String string = this.hostText.getText();
        String string2 = this.usageText.getText();
        String string3 = this.familyText.getText();
        String string4 = this.pathText.getText().trim();
        if (string.length() == 0 || string4.length() == 0) {
            JOptionPane.showMessageDialog(this.parent, "Fill the fields before creation !", "Warning", 2);
            return;
        }
        try {
            Object object;
            string4 = NewStarterDialog.manageBackSlash(string4);
            String[] stringArray = AstorUtil.string2StringArray(string4);
            boolean bl = this.useEventsBtn.getSelectedObjects() != null;
            MkStarter mkStarter = new MkStarter(string, stringArray, bl);
            if (this.creating) {
                mkStarter.create();
            }
            mkStarter.setProperties();
            mkStarter.setAdditionalProperties(string2, string3);
            if (this.h != null && !this.creating && !string2.equals(this.h.usage)) {
                this.h.usage = string2;
                object = this.parent;
                ((Astor)object).tree.changeHostNode(this.h);
            }
            if (this.creating) {
                object = "A Starter server has been created in TANGO database.\n\nYou can now start it on " + string + " machine.";
            } else {
                object = "The property has been modified in database";
                try {
                    String string5 = "tango/admin/" + string;
                    new DeviceProxy(string5).command_inout("Init");
                    object = (String)object + "\nand the device has been re-initialized.";
                }
                catch (DevFailed devFailed) {
                    // empty catch block
                }
            }
            JOptionPane.showMessageDialog(this.parent, object, "Command Done", 1);
        }
        catch (DevFailed devFailed) {
            PopupError.show((Component)this.parent, devFailed);
            return;
        }
        this.retVal = 0;
        this.doClose();
    }

    private void manageUseEvents(DeviceProxy deviceProxy) throws DevFailed {
        if (this.useEventsBtn.getSelectedObjects() != null) {
            DbDatum dbDatum = new DbDatum("UseEvents", 1);
            deviceProxy.put_property(dbDatum);
            DbAttribute dbAttribute = new DbAttribute("HostState");
            dbAttribute.add("abs_change", 1);
            deviceProxy.put_attribute_property(dbAttribute);
        } else {
            DbDatum dbDatum = new DbDatum("UseEvents", 0);
            deviceProxy.put_property(dbDatum);
        }
    }

    static String manageBackSlash(String string) {
        String string2 = "";
        int n = 0;
        while ((n = string.indexOf("\\", n)) >= 0) {
            string2 = string2 + string.substring(0, ++n);
            string2 = string2 + "\\";
            string = string.substring(n);
            n = 0;
        }
        string2 = string2 + string;
        return string2;
    }

    int getValue() {
        return this.retVal;
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

