/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.ServerPopupMenu;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import fr.esrf.Tango.DevState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class LevelTree
extends JTree
implements AstorDefs {
    private HostInfoDialog parent;
    private DefaultTreeModel treeModel;
    private ServerPopupMenu server_menu;
    private ServerPopupMenu level_menu;
    private TangoHost host;
    private Color bg;
    private Level level;
    private DefaultMutableTreeNode root;

    public LevelTree(JFrame jFrame, HostInfoDialog hostInfoDialog, TangoHost tangoHost, int n) {
        this.parent = hostInfoDialog;
        this.host = tangoHost;
        this.bg = hostInfoDialog.getBackgroundColor();
        this.setBackground(this.bg);
        this.server_menu = new ServerPopupMenu(jFrame, hostInfoDialog, tangoHost, 0);
        this.level_menu = new ServerPopupMenu(jFrame, hostInfoDialog, tangoHost, 1);
        this.level = new Level(n);
        this.initComponent();
        this.manageVisiblity();
    }

    public boolean hasRunningServer() {
        return this.level.hasRunningServer();
    }

    public DevState getState() {
        return this.level.getState();
    }

    public int getNbServers() {
        return this.level.size();
    }

    public void manageVisiblity() {
        this.setVisible(this.level.size() > 0);
    }

    public TangoServer getServer(String string) {
        return this.level.getServer(string);
    }

    public int getLevelRow() {
        return this.level.row;
    }

    private void initComponent() {
        this.root = new DefaultMutableTreeNode(this.level);
        for (int i = 0; i < this.level.size(); ++i) {
            this.root.add(new DefaultMutableTreeNode(this.level.getServer(i)));
        }
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LevelTree.this.treeMouseClicked(mouseEvent);
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                LevelTree.this.parent.packTheDialog();
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                LevelTree.this.parent.packTheDialog();
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                LevelTree.this.selectionChanged(treeSelectionEvent);
            }
        });
        if (this.level.row == 0) {
            this.collapseTree();
        }
    }

    public void selectionChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    public void checkUpdate() {
        int n;
        int n2;
        Object object;
        this.level.updateServerList();
        this.manageVisiblity();
        for (int i = 0; i < this.level.size(); ++i) {
            TangoServer tangoServer = this.level.getServer(i);
            object = this.root;
            n2 = this.root.getChildCount();
            n = 0;
            for (int j = 0; n == 0 && j < n2; ++j) {
                TangoServer tangoServer2 = (TangoServer)((DefaultMutableTreeNode)(object = ((DefaultMutableTreeNode)object).getNextNode())).getUserObject();
                n = tangoServer2 == tangoServer ? 1 : 0;
            }
            if (n != 0) continue;
            object = new DefaultMutableTreeNode(tangoServer);
            this.treeModel.insertNodeInto((MutableTreeNode)object, this.root, i);
            this.setSelectionPath(new TreePath(((DefaultMutableTreeNode)object).getPath()));
            this.expandRow(i);
        }
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            object = (TangoServer)defaultMutableTreeNode.getUserObject();
            n2 = 0;
            for (n = 0; n2 == 0 && n < this.level.size(); ++n) {
                n2 = object == this.level.getServer(n) ? 1 : 0;
            }
            if (n2 != 0) continue;
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            --i;
        }
    }

    public void resetSelection() {
        this.manageVisiblity();
        this.setSelectionPath(new TreePath(this.root.getPath()));
    }

    public void setSelection(TangoServer tangoServer) {
        this.manageVisiblity();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            TangoServer tangoServer2 = (TangoServer)defaultMutableTreeNode.getUserObject();
            if (tangoServer2 != tangoServer) continue;
            this.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    void expandTree() {
        this.expandRow(0);
    }

    void collapseTree() {
        this.collapseRow(0);
    }

    void toggleExpandCollapse() {
        if (this.isExpanded(0)) {
            this.collapseTree();
        } else {
            this.expandTree();
        }
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) < 0) {
            return;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        Object object = defaultMutableTreeNode.getUserObject();
        int n = mouseEvent.getModifiers();
        this.parent.fireNewTreeSelection(this);
        if (mouseEvent.getClickCount() == 2) {
            if ((n & 0x10) != 0) {
                // empty if block
            }
        } else if ((n & 4) != 0) {
            if (object instanceof TangoServer) {
                this.server_menu.showMenu(mouseEvent, (JTree)this, (TangoServer)object);
            } else {
                this.level_menu.showMenu(mouseEvent, this, this.isExpanded(0));
            }
        }
    }

    public String toString() {
        return this.level.toString();
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts = new Font[3];

        public TangoRenderer() {
            this.fonts[0] = new Font("Dialog", 1, 16);
            this.fonts[1] = new Font("Dialog", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(LevelTree.this.bg);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            this.setFont(this.fonts[defaultMutableTreeNode.getLevel()]);
            if (n == 0) {
                this.setIcon(this.getStateIcon(LevelTree.this.level.getState()));
                this.setBackgroundSelectionColor(LevelTree.this.bg);
            } else if (object2 instanceof TangoServer) {
                TangoServer tangoServer = (TangoServer)object2;
                this.setIcon(this.getStateIcon(tangoServer.getState()));
                this.setBackgroundSelectionColor(Color.lightGray);
            }
            return this;
        }

        private ImageIcon getStateIcon(DevState devState) {
            int n = devState == DevState.MOVING ? 4 : (devState == DevState.ON ? 3 : (devState == DevState.ALARM ? 2 : 1));
            return AstorUtil.state_icons[n];
        }
    }

    class Level
    extends Vector {
        public int row;

        public Level(int n) {
            this.row = n;
            this.updateServerList();
        }

        private void updateServerList() {
            this.clear();
            for (int i = 0; i < LevelTree.this.host.nbServers(); ++i) {
                TangoServer tangoServer = LevelTree.this.host.getServer(i);
                if (tangoServer.startup_level != this.row) continue;
                this.add(tangoServer);
            }
            AstorUtil.getInstance().sort(this);
        }

        TangoServer getServer(int n) {
            return (TangoServer)this.get(n);
        }

        TangoServer getServer(String string) {
            for (int i = 0; i < this.size(); ++i) {
                TangoServer tangoServer = this.getServer(i);
                if (!tangoServer.getName().equals(string)) continue;
                return tangoServer;
            }
            return null;
        }

        boolean hasRunningServer() {
            for (int i = 0; i < this.size(); ++i) {
                TangoServer tangoServer = this.getServer(i);
                if (tangoServer.getState() != DevState.ON) continue;
                return true;
            }
            return false;
        }

        DevState getState() {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < this.size(); ++i) {
                TangoServer tangoServer = this.getServer(i);
                if (tangoServer.getState() == DevState.UNKNOWN) {
                    return DevState.UNKNOWN;
                }
                if (tangoServer.getState() == DevState.FAULT) {
                    bl = true;
                    continue;
                }
                if (tangoServer.getState() == DevState.ALARM) {
                    bl2 = true;
                    continue;
                }
                if (tangoServer.getState() != DevState.MOVING) continue;
                bl3 = true;
            }
            if (bl) {
                return DevState.FAULT;
            }
            if (bl3) {
                return DevState.MOVING;
            }
            if (bl2) {
                return DevState.ALARM;
            }
            return DevState.ON;
        }

        public String toString() {
            String string = this.row != 0 ? "Level " + this.row : "Not Controlled";
            return string;
        }
    }
}

