/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChange;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;

public class HostStateThread
extends Thread
implements AstorDefs {
    private AstorTree parent;
    private TangoHost host;
    private int readInfoPeriod;
    boolean stop_it = false;
    private String[] attributes = new String[]{"state", "NotifdState"};
    private static final int StateAtt = 0;
    private static final int NotifdAtt = 1;
    private DevState previous_state = DevState.UNKNOWN;
    private static String[] filters = new String[0];
    private StateEventListener state_listener = null;

    public HostStateThread(AstorTree astorTree, TangoHost tangoHost) {
        this.parent = astorTree;
        this.host = tangoHost;
        tangoHost.thread = this;
        this.readInfoPeriod = AstorUtil.getStarterReadPeriod() / 2;
    }

    public synchronized void updateData() {
        this.notify();
    }

    public void run() {
        long l = System.currentTimeMillis();
        while (!this.stop_it) {
            long l2 = System.currentTimeMillis();
            if (!this.host.use_events) {
                if (this.host.do_polling) {
                    this.manageSynchronousAttributes();
                }
            } else if (l2 - l > 60000L) {
                this.manageSynchronousAttributes();
                l = l2;
            }
            this.wait_next_loop(l2);
        }
    }

    public synchronized void wait_next_loop(long l) {
        try {
            long l2 = System.currentTimeMillis();
            long l3 = (long)this.readInfoPeriod - (l2 - l);
            if (l3 <= 0L) {
                l3 = 100L;
            }
            this.wait(l3);
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
        }
    }

    public synchronized void updateHost(DevState devState) {
        if (devState == this.previous_state) {
            return;
        }
        this.previous_state = devState;
        this.host.state = devState == DevState.ON ? 3 : (devState == DevState.MOVING ? 4 : (devState == DevState.ALARM ? 2 : (devState == DevState.FAULT ? 1 : 0)));
        if (this.parent != null) {
            this.parent.updateState();
        }
        if (this.host.info_dialog != null) {
            this.host.info_dialog.updateHostState();
        }
    }

    public synchronized void updateNotifdHost(DevState devState) {
        int n = 0;
        if (devState == DevState.ON) {
            n = 3;
        } else if (devState == DevState.FAULT) {
            n = 1;
        }
        if (this.host.notifyd_state == n) {
            return;
        }
        this.host.notifyd_state = n;
        if (this.parent != null) {
            this.parent.updateState();
        }
        if (this.host.info_dialog != null) {
            this.host.info_dialog.updateHostState();
        }
    }

    public void manageSynchronousAttributes() {
        DevState devState;
        DevState devState2;
        try {
            DeviceAttribute[] deviceAttributeArray = this.host.read_attribute(this.attributes);
            devState2 = deviceAttributeArray[0].hasFailed() ? DevState.FAULT : deviceAttributeArray[0].extractState();
            devState = deviceAttributeArray[1].hasFailed() ? DevState.UNKNOWN : deviceAttributeArray[1].extractState();
        }
        catch (DevFailed devFailed) {
            this.host.except = devFailed;
            devState = DevState.UNKNOWN;
            devState2 = DevState.FAULT;
        }
        this.updateHost(devState2);
        if (this.host.check_notifd) {
            this.updateNotifdHost(devState);
        }
    }

    public void subscribeChangeStateEvent() {
        String string = null;
        try {
            if (this.host.supplier == null) {
                this.host.supplier = new TangoEventsAdapter((DeviceProxy)this.host);
            }
            if (this.state_listener == null) {
                this.state_listener = new StateEventListener();
                this.host.supplier.addTangoChangeListener((ITangoChangeListener)this.state_listener, this.attributes[0], filters);
            }
        }
        catch (DevFailed devFailed) {
            this.state_listener = null;
            this.host.use_events = false;
            if (!devFailed.errors[0].desc.startsWith("Already connected to event")) {
                string = "subscribeChangeStateEvent() for " + this.host.get_name() + " FAILED !\n" + devFailed.errors[0].desc;
            }
            Except.print_exception((Exception)((Object)devFailed));
        }
        catch (Exception exception) {
            this.state_listener = null;
            this.host.use_events = false;
            string = "subscribeChangeStateEvent() for " + this.host.get_name() + " FAILED !" + exception.toString();
            exception.printStackTrace();
        }
        if (string != null) {
            System.out.println(string);
        }
        this.parent.updateMonitor(string);
    }

    class StateEventListener
    implements ITangoChangeListener {
        StateEventListener() {
        }

        public void change(TangoChangeEvent tangoChangeEvent) {
            DevState devState;
            DevState devState2;
            DeviceAttribute deviceAttribute;
            TangoChange tangoChange = (TangoChange)tangoChangeEvent.getSource();
            String string = tangoChange.getEventSupplier().get_name();
            try {
                deviceAttribute = tangoChangeEvent.getValue();
                devState2 = deviceAttribute.hasFailed() ? DevState.UNKNOWN : deviceAttribute.extractState();
            }
            catch (DevFailed devFailed) {
                devState2 = DevState.ALARM;
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    System.out.println("HostStateThread.StateEventListener" + string + " : API_EventTimeout");
                    try {
                        HostStateThread.this.host.ping();
                    }
                    catch (DevFailed devFailed2) {
                        devState2 = DevState.FAULT;
                    }
                } else if (devFailed.errors[0].reason.equals("TangoApi_CANNOT_IMPORT_DEVICE")) {
                    System.out.println("HostStateThread.StateEventListener" + string + " : TangoApi_CANNOT_IMPORT_DEVICE");
                    devState2 = DevState.FAULT;
                }
            }
            catch (Exception exception) {
                System.out.println("AstorEvent." + string);
                System.out.println(exception);
                System.out.println("HostStateThread.StateEventListener : could not extract data!");
                devState2 = DevState.UNKNOWN;
            }
            try {
                deviceAttribute = HostStateThread.this.host.read_attribute(HostStateThread.this.attributes[1]);
                devState = deviceAttribute.hasFailed() ? DevState.UNKNOWN : deviceAttribute.extractState();
            }
            catch (Exception exception) {
                devState = DevState.UNKNOWN;
            }
            HostStateThread.this.updateNotifdHost(devState);
            HostStateThread.this.updateHost(devState2);
        }
    }
}

