/*
 * Decompiled with CFR 0.152.
 */
package app_util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class Misc {
    public static String array2string(String[] array) {
        StringBuffer sb = new StringBuffer(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append("\n" + array[i]);
        }
        return sb.toString();
    }

    public static String getStackTrace(Exception e) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(stream);
        e.printStackTrace(ps);
        return stream.toString();
    }

    public static String callingMethods() {
        Throwable t = new Throwable();
        StackTraceElement[] elements = t.getStackTrace();
        StringBuffer sb = new StringBuffer("Methods:\n");
        for (int i = 1; i < elements.length; ++i) {
            sb.append("\t" + elements[i].getMethodName() + "\n");
        }
        return sb.toString();
    }

    public static String callingMethods(int nb) {
        Throwable t = new Throwable();
        StackTraceElement[] elements = t.getStackTrace();
        StringBuffer sb = new StringBuffer("Methods:\n");
        for (int i = 1; i < elements.length && i <= nb; ++i) {
            sb.append("\t" + elements[i].getMethodName() + "\n");
        }
        return sb.toString();
    }

    public static void centerFrame(JFrame f) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        Dimension appsize = f.getSize();
        Point p = new Point();
        p.x = (scrsize.width - appsize.width) / 2;
        p.y = (scrsize.height - appsize.height) / 2;
        f.setLocation(p);
    }

    public static void centerDialog(JDialog dialog, JFrame parent) {
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - dialog.getWidth()) / 2;
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        dialog.setLocation(p);
    }

    public static void centerDialog(JDialog dialog, JDialog parent) {
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - dialog.getWidth()) / 2;
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        dialog.setLocation(p);
    }

    public static String strPeriod(double period) {
        if (period < 10.0) {
            String str = "" + period;
            int idx = str.indexOf(46);
            if (idx > 0 && str.length() > idx + 3) {
                str = str.substring(0, idx + 3);
            }
            return str + " sec.";
        }
        int iperiod = (int)period;
        if (period < 60.0) {
            return "" + iperiod + " sec.";
        }
        if (iperiod < 3600) {
            int mn = iperiod / 60;
            int sec = iperiod - 60 * mn;
            return "" + mn + " mn " + sec + " sec.";
        }
        if (iperiod < 86400) {
            int h = iperiod / 3600;
            return "" + h + " h " + Misc.strPeriod((double)iperiod - (double)(h * 3600));
        }
        int days = iperiod / 86400;
        return "" + days + " day" + (days > 1 ? "s " : " ") + Misc.strPeriod((double)iperiod - (double)(days * 24 * 3600));
    }
}

