/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.HistoryDialog;
import admin.astor.tools.SubscribedSignal;
import admin.astor.tools.TablePopupMenu;
import app_util.PopupError;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class EventsTable
extends JDialog {
    public static final int SUBSCRIBE_CHANGE = 0;
    public static final int SUBSCRIBE_PERIODIC = 1;
    public static final int SUBSCRIBE_ARCHIVE = 2;
    public static final String[] strMode = new String[]{"CHANGE", "PERIODIC", "ARCHIVE"};
    public JTable table;
    private DataTableModel model;
    private JScrollPane scrollPane;
    private static String[] col_names = new String[]{"Signal names", "Read Value", "Mode", "Last Time", "Delta Time", "Delta Value", "Received"};
    public static final int NAME = 0;
    public static final int VALUE = 1;
    public static final int MODE = 2;
    public static final int TIME = 3;
    public static final int DT = 4;
    public static final int DV = 5;
    public static final int CNT = 6;
    private static int[] col_width = new int[]{140, 100, 45, 85, 60, 70, 50};
    private Vector signals = new Vector();
    private boolean first = true;
    private TablePopupMenu menu = null;
    private JFrame parent = null;
    private static JFileChooser chooser;
    private static final String ColWidthHeader = "Column_width:";
    private static final String FileHeader = "#\n#\tEventTester :\tevent list\n#\n";
    private JButton cancelBtn;
    private JMenu fileMenu;
    private JMenuBar jMenuBar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JMenuItem openFile;
    private JMenuItem saveFile;
    private JLabel titleLabel;

    public EventsTable(JFrame jFrame) throws DevFailed {
        super((Frame)jFrame, false);
        this.initComponents();
        this.initMyComponents();
        this.titleLabel.setText("TANGO  Event Tester");
        if (jFrame != null && jFrame.isVisible()) {
            this.parent = jFrame;
            Point point = jFrame.getLocationOnScreen();
            int n = jFrame.getHeight();
            point.y += n;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            if (point.y > dimension.height - this.getHeight() - 20) {
                point.y -= n + this.getHeight();
            }
            this.setLocation(point);
        }
        this.fileMenu.setMnemonic('F');
        this.openFile.setMnemonic('O');
        this.openFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.saveFile.setMnemonic('S');
        this.saveFile.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openFile = new JMenuItem();
        this.saveFile = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EventsTable.this.closeDialog(windowEvent);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventsTable.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.fileMenu.setText("File");
        this.openFile.setText("Open");
        this.openFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventsTable.this.openFileActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.openFile);
        this.saveFile.setText("Save");
        this.saveFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventsTable.this.saveFileActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.saveFile);
        this.jMenuBar.add(this.fileMenu);
        this.setJMenuBar(this.jMenuBar);
        this.pack();
    }

    private void openFileActionPerformed(ActionEvent actionEvent) {
        Object object;
        if (chooser == null) {
            object = System.getProperty("EVT_DATA_FILES");
            if (object == null) {
                object = new File("").getAbsolutePath();
            }
            chooser = new JFileChooser((String)object);
        }
        chooser.setDialogTitle("Open Configuration File");
        chooser.setApproveButtonText("Open");
        if (chooser.showOpenDialog(this) == 0 && (object = chooser.getSelectedFile()) != null && !((File)object).isDirectory()) {
            this.openEventList(((File)object).getAbsolutePath());
        }
    }

    private void saveFileActionPerformed(ActionEvent actionEvent) {
        Object object;
        if (this.signals.size() == 0) {
            PopupError.show((Component)this, "No subscription to save");
            return;
        }
        if (chooser == null) {
            object = System.getProperty("EVT_DATA_FILES");
            if (object == null) {
                object = new File("").getAbsolutePath();
            }
            chooser = new JFileChooser((String)object);
        }
        chooser.setDialogTitle("Save Configuration");
        chooser.setApproveButtonText("Save");
        if (chooser.showOpenDialog(this) == 0 && (object = chooser.getSelectedFile()) != null && !((File)object).isDirectory()) {
            if (((File)object).exists() && JOptionPane.showConfirmDialog(this, "This File Already Exists !\n\nWould you like to overwrite ?", "information", 0) != 0) {
                return;
            }
            this.saveEventList(((File)object).getAbsolutePath());
        }
    }

    private void saveEventList(String string) {
        String string2 = FileHeader;
        for (int i = 0; i < this.signals.size(); ++i) {
            SubscribedSignal subscribedSignal = (SubscribedSignal)this.signals.get(i);
            string2 = string2 + subscribedSignal.toString() + "\n";
        }
        int[] nArray = this.getColumnWidth();
        string2 = string2 + "#\nColumn_width:\t";
        for (int i = 0; i < nArray.length; ++i) {
            string2 = string2 + " " + nArray[i];
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            PopupError.show((Component)this, exception);
        }
    }

    private void openEventList(String string) {
        Object object;
        Object object2;
        String string2 = "";
        try {
            object2 = new FileInputStream(string);
            int n = ((FileInputStream)object2).available();
            object = new byte[n];
            ((FileInputStream)object2).read((byte[])object);
            string2 = new String((byte[])object);
            ((FileInputStream)object2).close();
        }
        catch (Exception exception) {
            PopupError.show((Component)this, exception);
            return;
        }
        if (!string2.startsWith(FileHeader)) {
            PopupError.show((Component)this, "This is not an EventTester Configuration file");
            return;
        }
        string2 = string2.substring(FileHeader.length());
        object2 = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).startsWith("#")) continue;
            if (!((String)object).startsWith(ColWidthHeader)) {
                this.createSignalFromLine((String)object);
                continue;
            }
            this.readColWidthDefinition((String)object);
        }
        this.setColumnWidth(col_width);
        this.pack();
    }

    private void readColWidthDefinition(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        col_width = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2 = stringTokenizer.nextToken();
                EventsTable.col_width[n] = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Cannot parse width for column " + n);
                EventsTable.col_width[n] = 50;
            }
            ++n;
        }
    }

    private void createSignalFromLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken().substring(1);
        string3 = string3.substring(0, string3.indexOf(93));
        int n = -1;
        for (int i = 0; i < strMode.length; ++i) {
            if (!string3.equals(strMode[i])) continue;
            n = i;
        }
        if (n == -1) {
            PopupError.show((Component)this, "mode " + string3 + " is unknown !");
            return;
        }
        this.add(string2, n);
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent != null) {
            this.getColumnWidth();
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public void add(String string, int n) {
        Object object;
        for (int i = 0; i < this.signals.size(); ++i) {
            object = (SubscribedSignal)this.signals.get(i);
            if (!((SubscribedSignal)object).name.toLowerCase().equals(string.toLowerCase()) || ((SubscribedSignal)object).mode != n) continue;
            this.setVisible(true);
            this.table.changeSelection(i, 0, false, false);
            PopupError.show((Component)this, "Event '" + string + "'  already subscribed");
            return;
        }
        SubscribedSignal subscribedSignal = new SubscribedSignal(string, n);
        subscribedSignal.subscribe(this);
        this.signals.add(subscribedSignal);
        this.setVisible(true);
        this.updateTable();
        object = this.table.getSize();
        ((Dimension)object).height += 40;
        this.scrollPane.setPreferredSize(new Dimension((Dimension)object));
        this.pack();
    }

    private void buildTitle(ActionEvent actionEvent) {
        String string = "Attribute events";
        String string2 = SubscribedSignal.getStrDate();
        this.titleLabel.setText(string + " at " + string2);
    }

    void updateTable() {
        this.model.fireTableDataChanged();
    }

    private void initMyComponents() throws DevFailed {
        try {
            this.model = new DataTableModel();
            this.table = new JTable(this.model){

                public String getToolTipText(MouseEvent mouseEvent) {
                    String string = null;
                    Point point = mouseEvent.getPoint();
                    int n = this.rowAtPoint(point);
                    int n2 = this.columnAtPoint(point);
                    int n3 = this.convertColumnIndexToModel(n2);
                    SubscribedSignal subscribedSignal = (SubscribedSignal)EventsTable.this.signals.get(n);
                    switch (n3) {
                        case 0: {
                            string = subscribedSignal.name;
                            break;
                        }
                        case 1: {
                            if (subscribedSignal.except == null) {
                                string = subscribedSignal.value;
                                break;
                            }
                            string = subscribedSignal.except_str();
                            break;
                        }
                        case 4: {
                            string = subscribedSignal.getTimes();
                        }
                    }
                    return string;
                }
            };
            this.table.setSelectionMode(0);
            this.table.getTableHeader().setFont(new Font("Dialog", 1, 14));
            this.table.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    EventsTable.this.tableActionPerformed(mouseEvent);
                }
            });
            this.scrollPane = new JScrollPane(this.table);
            this.scrollPane.setPreferredSize(new Dimension(700, 50));
            this.getContentPane().add((Component)this.scrollPane, "Center");
            if (this.first) {
                int n = 1000;
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        EventsTable.this.buildTitle(actionEvent);
                    }
                };
                new Timer(n, actionListener).start();
                this.first = false;
            }
            this.setColumnWidth(col_width);
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Except.throw_exception((String)"INIT_ERROR", (String)exception.toString(), (String)"TestEventTable.initMyComponents()");
        }
        this.model.fireTableDataChanged();
    }

    private void tableActionPerformed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            int n = this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            SubscribedSignal subscribedSignal = (SubscribedSignal)this.signals.get(n);
            if (subscribedSignal == null) {
                return;
            }
            if (this.menu == null) {
                this.menu = new TablePopupMenu(this);
            }
            this.menu.showMenu(mouseEvent, subscribedSignal);
        }
    }

    void move(SubscribedSignal subscribedSignal, int n) {
        int n2 = 0;
        for (int i = 0; i < this.signals.size(); ++i) {
            if (!this.signals.get(i).equals(subscribedSignal)) continue;
            n2 = i;
        }
        switch (n) {
            case 0: {
                if (n2 <= 0) break;
                this.signals.remove(subscribedSignal);
                this.signals.add(n2 - 1, subscribedSignal);
                break;
            }
            case 1: {
                if (n2 >= this.signals.size() - 1) break;
                this.signals.remove(subscribedSignal);
                this.signals.add(n2 + 1, subscribedSignal);
            }
        }
        this.updateTable();
    }

    void displayHistory(SubscribedSignal subscribedSignal) {
        new HistoryDialog(this, subscribedSignal).setVisible(true);
    }

    void displayInfo(SubscribedSignal subscribedSignal) {
        if (subscribedSignal.except != null) {
            if (subscribedSignal.except instanceof DevFailed) {
                PopupError.show((Component)this, (DevFailed)((Object)subscribedSignal.except));
            } else {
                PopupError.show((Component)this, subscribedSignal.except);
            }
        } else {
            PopupMessage.show((Component)this, subscribedSignal.status());
        }
    }

    void remove(SubscribedSignal subscribedSignal) {
        subscribedSignal.unsubscribe();
        this.signals.remove(subscribedSignal);
        this.updateTable();
        Dimension dimension = this.table.getSize();
        dimension.height += 40;
        this.scrollPane.setPreferredSize(new Dimension(dimension));
        this.pack();
    }

    public void setColumnWidth(int[] nArray) {
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(nArray[n]);
            ++n;
        }
    }

    public int[] getColumnWidth() {
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        Vector<TableColumn> vector = new Vector<TableColumn>();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            TableColumn tableColumn = (TableColumn)vector.get(i);
            nArray[i] = tableColumn.getPreferredWidth();
        }
        return nArray;
    }

    static void displaySyntax() {
        System.out.println("Syntax:");
        System.out.println("EventsTable -a  <attribute list>");
        System.out.println("EventsTable -f  <file name>");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        int n = 2;
        if (stringArray.length > 0 && stringArray[0].equals("-?")) {
            EventsTable.displaySyntax();
        }
        try {
            EventsTable eventsTable = new EventsTable(new JFrame());
            if (stringArray.length > 1) {
                if (stringArray[0].equals("-a")) {
                    for (int i = 1; i < stringArray.length; ++i) {
                        eventsTable.add(stringArray[i], n);
                    }
                } else if (stringArray[0].equals("-f")) {
                    eventsTable.openEventList(stringArray[1]);
                }
            }
            eventsTable.setVisible(true);
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return col_names.length;
        }

        public int getRowCount() {
            return EventsTable.this.signals.size();
        }

        public String getColumnName(int n) {
            return col_names[n];
        }

        public Object getValueAt(int n, int n2) {
            SubscribedSignal subscribedSignal = (SubscribedSignal)EventsTable.this.signals.get(n);
            switch (n2) {
                case 0: {
                    return subscribedSignal.name;
                }
                case 1: {
                    return subscribedSignal.value;
                }
                case 2: {
                    return strMode[subscribedSignal.mode];
                }
                case 3: {
                    return subscribedSignal.time;
                }
                case 4: {
                    return subscribedSignal.d_time;
                }
                case 5: {
                    return subscribedSignal.d_value;
                }
                case 6: {
                    return "" + subscribedSignal.cnt;
                }
            }
            return "";
        }
    }
}

