/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.ServArchitectureDialog;
import admin.astor.tools.DevBrowser;
import admin.astor.tools.PollingProfiler;
import admin.astor.tools.PropertyDialog;
import admin.astor.tools.TreePopupMenu;
import app_util.PopupError;
import atkpanel.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.ExecDev;

public class DevBrowserTree
extends JTree
implements TangoConst {
    private static final int INSTANCE = 3;
    private static final int CLASS = 4;
    private static final int DEVICE = 5;
    private static final int ATTRIB = 6;
    private static final int DOMAIN = 3;
    private static final int FAMILY = 4;
    private static final int MEMBER = 5;
    private DefaultTreeModel treeModel;
    private DevBrowser browser;
    private TreePopupMenu att_menu = null;
    private TreePopupMenu dev_menu = null;
    private TreePopupMenu serv_menu = null;
    private DefaultMutableTreeNode root;
    private boolean obj_has_polling;

    public DevBrowserTree(DevBrowser devBrowser) throws DevFailed {
        this.browser = devBrowser;
        String string = ApiUtil.get_db_obj().get_tango_host();
        this.initComponent(string);
        this.att_menu = new TreePopupMenu(this, 1);
        this.dev_menu = new TreePopupMenu(this, 0);
        this.serv_menu = new TreePopupMenu(this, 2);
    }

    private void initComponent(String string) throws DevFailed {
        this.root = new DefaultMutableTreeNode(string);
        this.createServerNodes(this.root);
        this.createDeviceNodes(this.root);
        this.createAliasNodes(this.root);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                DevBrowserTree.this.expandedPerfomed(treeExpansionEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DevBrowserTree.this.treeMouseClicked(mouseEvent);
            }
        });
    }

    private boolean createChildNodes(DefaultMutableTreeNode defaultMutableTreeNode, String[] stringArray) {
        boolean bl = false;
        if (defaultMutableTreeNode.getChildCount() != stringArray.length) {
            bl = true;
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (defaultMutableTreeNode.getChildAt(i).toString().equals(stringArray[i])) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void createAliasNodes(DefaultMutableTreeNode defaultMutableTreeNode) throws DevFailed {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Aliases");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        Database database = ApiUtil.get_db_obj();
        String[] stringArray = database.get_device_alias_list("*");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = ApiUtil.get_db_obj().get_alias_device(stringArray[i]);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode((Object)new BrowserDevice(string, stringArray[i]));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode("dummy"));
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                continue;
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
    }

    private void createServerNodes(DefaultMutableTreeNode defaultMutableTreeNode) throws DevFailed {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Servers");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        Database database = ApiUtil.get_db_obj();
        String[] stringArray = database.get_server_name_list();
        for (int i = 0; i < stringArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(stringArray[i]);
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("dummy"));
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        }
    }

    private void createInstanceNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            String string = (String)defaultMutableTreeNode.getUserObject();
            String[] stringArray = ApiUtil.get_db_obj().get_instance_name_list(string);
            if (!this.createChildNodes(defaultMutableTreeNode, stringArray)) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new BrowserServer(string, stringArray[i]));
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, i);
            }
            this.removePreviousNode(defaultMutableTreeNode, stringArray.length);
        }
        catch (DevFailed devFailed) {
            this.displayException((Exception)((Object)devFailed));
        }
    }

    private void createClassNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            BrowserServer browserServer = (BrowserServer)defaultMutableTreeNode.getUserObject();
            String[] stringArray = ApiUtil.get_db_obj().get_server_class_list(browserServer.name);
            if (!this.createChildNodes(defaultMutableTreeNode, stringArray)) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[i]);
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, i);
            }
            this.removePreviousNode(defaultMutableTreeNode, stringArray.length);
        }
        catch (DevFailed devFailed) {
            this.displayException((Exception)((Object)devFailed));
        }
    }

    private void createDeviceNodesFromServer(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            BrowserServer browserServer = (BrowserServer)defaultMutableTreeNode2.getUserObject();
            String string = browserServer.name;
            String string2 = (String)defaultMutableTreeNode.getUserObject();
            String[] stringArray = ApiUtil.get_db_obj().get_device_name(string, string2);
            if (!this.createChildNodes(defaultMutableTreeNode, stringArray)) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode((Object)new BrowserDevice_2(stringArray[i]));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode("dummy"));
                this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, i);
            }
            this.removePreviousNode(defaultMutableTreeNode, stringArray.length);
        }
        catch (DevFailed devFailed) {
            this.displayException((Exception)((Object)devFailed));
        }
    }

    private void createDeviceNodes(DefaultMutableTreeNode defaultMutableTreeNode) throws DevFailed {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Devices");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        Database database = ApiUtil.get_db_obj();
        String[] stringArray = database.get_device_domain("*");
        for (int i = 0; i < stringArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(stringArray[i]);
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("dummy"));
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        }
    }

    private void createFamilyNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            String string = (String)defaultMutableTreeNode.getUserObject();
            String[] stringArray = ApiUtil.get_db_obj().get_device_family(string + "/*");
            if (!this.createChildNodes(defaultMutableTreeNode, stringArray)) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[i]);
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, i);
            }
            this.removePreviousNode(defaultMutableTreeNode, stringArray.length);
        }
        catch (DevFailed devFailed) {
            this.displayException((Exception)((Object)devFailed));
        }
    }

    private void createMemberNodes(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            string = string + (String)defaultMutableTreeNode.getUserObject();
            String[] stringArray = ApiUtil.get_db_obj().get_device_member(string + "/*");
            if (!this.createChildNodes(defaultMutableTreeNode, stringArray)) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode((Object)new BrowserDevice(string + "/" + stringArray[i]));
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, i);
            }
            this.removePreviousNode(defaultMutableTreeNode, stringArray.length);
        }
        catch (DevFailed devFailed) {
            this.displayException((Exception)((Object)devFailed));
        }
    }

    private void createAttributeNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            BrowserDevice browserDevice = (BrowserDevice)((Object)defaultMutableTreeNode.getUserObject());
            String[] stringArray = browserDevice.get_attribute_list();
            if (!this.createChildNodes(defaultMutableTreeNode, stringArray)) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                BrowserAttribute browserAttribute = new BrowserAttribute(stringArray[i], browserDevice);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(browserAttribute);
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, i);
            }
            this.removePreviousNode(defaultMutableTreeNode, stringArray.length);
        }
        catch (DevFailed devFailed) {
            this.removePreviousNode(defaultMutableTreeNode, 0);
            this.displayException((Exception)((Object)devFailed));
        }
    }

    private void removePreviousNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        while (defaultMutableTreeNode.getChildCount() > n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
    }

    private String tangoPath(TreePath treePath, int n) {
        String string = "";
        for (int i = 3; i < 3 + n; ++i) {
            string = string + treePath.getPathComponent(i - 1).toString();
            string = string + "/";
        }
        return string;
    }

    public void expandedPerfomed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        Object[] objectArray = treePath.getPath();
        if (objectArray.length < 2) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(objectArray.length - 1);
        if (objectArray[1].toString().equals("Servers")) {
            switch (objectArray.length) {
                case 3: {
                    this.createInstanceNodes(defaultMutableTreeNode);
                    break;
                }
                case 4: {
                    this.createClassNodes(defaultMutableTreeNode);
                    break;
                }
                case 5: {
                    this.createDeviceNodesFromServer(defaultMutableTreeNode);
                    break;
                }
                case 6: {
                    this.createAttributeNodes(defaultMutableTreeNode);
                }
            }
        } else if (objectArray[1].toString().equals("Devices")) {
            switch (objectArray.length) {
                case 3: {
                    this.createFamilyNodes(defaultMutableTreeNode);
                    break;
                }
                case 4: {
                    String string = this.tangoPath(treePath, 1);
                    this.createMemberNodes(string, defaultMutableTreeNode);
                    break;
                }
                case 5: {
                    this.createAttributeNodes(defaultMutableTreeNode);
                }
            }
        } else if (objectArray[1].toString().equals("Aliases") && objectArray.length == 3) {
            this.createAttributeNodes(defaultMutableTreeNode);
        }
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) < 1) {
            return;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        Object object = defaultMutableTreeNode.getUserObject();
        int n = mouseEvent.getModifiers();
        this.clearDisplay();
        this.obj_has_polling = false;
        if (mouseEvent.getClickCount() == 2 && defaultMutableTreeNode.isLeaf()) {
            if (object instanceof BrowserDevice) {
                this.createAttributeNodes(defaultMutableTreeNode);
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                    this.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                }
            }
        } else if ((n & 4) != 0) {
            if (object instanceof BrowserAttribute) {
                this.att_menu.showMenu(mouseEvent);
                BrowserAttribute browserAttribute = (BrowserAttribute)object;
                if (browserAttribute != null) {
                    this.displayEventProperties(browserAttribute);
                }
            } else if (object instanceof BrowserDevice) {
                boolean bl = this.displayDeviceInfo((BrowserDevice)((Object)object));
                this.dev_menu.showMenu(mouseEvent, this.obj_has_polling, bl);
            } else if (object instanceof BrowserServer) {
                boolean bl = this.displayDeviceInfo(((BrowserServer)object).dev);
                this.serv_menu.showMenu(mouseEvent, this.obj_has_polling, bl);
            }
        } else if ((n & 0x10) != 0) {
            if (object instanceof BrowserServer) {
                this.displayDeviceInfo(((BrowserServer)object).dev);
            } else if (object instanceof BrowserDevice) {
                this.displayDeviceInfo((BrowserDevice)((Object)object));
            } else if (object instanceof BrowserAttribute) {
                this.displayEventProperties((BrowserAttribute)object);
            }
        }
    }

    private void clearDisplay() {
        this.browser.setText("");
    }

    private boolean displayDeviceInfo(BrowserDevice browserDevice) {
        String string;
        try {
            DeviceInfo deviceInfo = browserDevice.get_info();
            string = deviceInfo + "\n\n";
        }
        catch (DevFailed devFailed) {
            this.browser.setText(devFailed.toString());
            return false;
        }
        boolean bl = false;
        try {
            String string2 = "\n=======================================\n";
            string2 = string2 + "           Polling Status:\n\n";
            if (browserDevice.name().startsWith("dserver/")) {
                DeviceData deviceData = browserDevice.command_inout("QueryDevice");
                String[] stringArray = deviceData.extractStringArray();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i].substring(stringArray[i].indexOf("::") + 2);
                    DeviceData deviceData2 = new DeviceData();
                    deviceData2.insert(string3);
                    deviceData = browserDevice.command_inout("DevPollStatus", deviceData2);
                    String[] stringArray2 = deviceData.extractStringArray();
                    string2 = string2 + "----------------- " + string3 + " ------------------\n";
                    for (int j = 0; j < stringArray2.length; ++j) {
                        string2 = string2 + stringArray2[j] + "\n\n";
                    }
                    if (stringArray2.length <= 0) continue;
                    this.obj_has_polling = true;
                }
                bl = true;
            } else {
                String[] stringArray = browserDevice.polling_status();
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + "\n\n";
                }
                bl = true;
                if (stringArray.length > 0) {
                    this.obj_has_polling = true;
                }
            }
            string = string + string2;
        }
        catch (DevFailed devFailed) {
            try {
                browserDevice.ping();
                bl = true;
            }
            catch (DevFailed devFailed2) {
                string = string + "\n=======================================\n";
                string = string + AstorUtil.strException((Exception)((Object)devFailed2));
            }
        }
        this.browser.setText(string);
        return bl;
    }

    void showProfiler() {
        try {
            Object object = this.getSelectedNode().getUserObject();
            if (object instanceof BrowserDevice) {
                new PollingProfiler((JFrame)this.browser, ((BrowserDevice)((Object)object)).name).setVisible(true);
            } else if (object instanceof BrowserServer) {
                DeviceData deviceData = ((BrowserServer)object).dev.command_inout("QueryDevice");
                String[] stringArray = deviceData.extractStringArray();
                String string = "::";
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = stringArray[i].indexOf(string);
                    if (n <= 0) continue;
                    stringArray[i] = stringArray[i].substring(n + string.length());
                }
                new PollingProfiler((JFrame)this.browser, stringArray).setVisible(true);
            }
        }
        catch (DevFailed devFailed) {
            PopupError.show((Component)this.browser, devFailed);
        }
    }

    String getSelectedName() {
        Object object = this.getSelectedNode().getUserObject();
        if (object instanceof BrowserAttribute) {
            return ((BrowserAttribute)object).name;
        }
        if (object instanceof BrowserDevice) {
            return ((BrowserDevice)((Object)object)).name;
        }
        if (object instanceof BrowserServer) {
            return ((BrowserServer)object).name;
        }
        return "??";
    }

    private String getAttPollingInfo() {
        Object object = this.getSelectedNode().getUserObject();
        if (object instanceof BrowserAttribute) {
            try {
                BrowserAttribute browserAttribute = (BrowserAttribute)object;
                String string = "Polled attribute name = ";
                String[] stringArray = browserAttribute.dev.polling_status();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].substring(string.length(), stringArray[i].indexOf(10));
                    if (!string2.toLowerCase().equals(browserAttribute.name.toLowerCase())) continue;
                    return stringArray[i];
                }
            }
            catch (DevFailed devFailed) {
                return devFailed.toString();
            }
        }
        return "";
    }

    private void displayEventProperties(BrowserAttribute browserAttribute) {
        this.displayEventProperties(browserAttribute.attname);
    }

    void displayEventProperties(String string) {
        String string2 = "";
        try {
            AttributeProxy attributeProxy = new AttributeProxy(string);
            int n = attributeProxy.get_idl_version();
            if (n < 3) {
                this.browser.setText("Device_" + n + "Impl not supported.");
                return;
            }
            AttributeInfoEx attributeInfoEx = attributeProxy.get_info_ex();
            if (attributeInfoEx.events != null) {
                string2 = string;
                string2 = string2 + "\n\nChange event properties:\n";
                if (attributeInfoEx.events.ch_event != null) {
                    string2 = string2 + "abs_change :   " + attributeInfoEx.events.ch_event.abs_change + "\n";
                    string2 = string2 + "rel_change :   " + attributeInfoEx.events.ch_event.rel_change + "\n";
                } else {
                    string2 = string2 + "rel_change :   Not specified\n";
                    string2 = string2 + "abs_change :   Not specified\n";
                }
                string2 = string2 + "\n\nPeriodic event properties:\n";
                string2 = attributeInfoEx.events.per_event != null ? string2 + "period     :   " + attributeInfoEx.events.per_event.period : string2 + "period     :   Not specified";
                string2 = string2 + "\n\nArchive event properties:\n";
                if (attributeInfoEx.events.arch_event != null) {
                    string2 = string2 + "abs_change :   " + attributeInfoEx.events.arch_event.abs_change + "\n";
                    string2 = string2 + "rel_change :   " + attributeInfoEx.events.arch_event.rel_change + "\n";
                    string2 = string2 + "period     :   " + attributeInfoEx.events.arch_event.period;
                } else {
                    string2 = string2 + "rel_change :   Not specified\n";
                    string2 = string2 + "abs_change :   Not specified\n";
                    string2 = string2 + "period     :   Not specified";
                }
            }
            string2 = string2 + "\n\n\n" + this.getAttPollingInfo();
            this.browser.setText(string2);
        }
        catch (DevFailed devFailed) {
            this.displayException((Exception)((Object)devFailed));
        }
    }

    void deviceTest() {
        Object object = this.getSelectedNode().getUserObject();
        String string = null;
        if (object instanceof BrowserDevice) {
            string = ((BrowserDevice)((Object)object)).name;
        } else if (object instanceof BrowserServer) {
            string = "dserver/" + ((BrowserServer)object).name;
        }
        if (string != null) {
            try {
                JDialog jDialog = new JDialog((Frame)this.browser, false);
                jDialog.setTitle(string + " Device Panel");
                jDialog.setContentPane((Container)new ExecDev(string));
                ATKGraphicsUtils.centerDialog((Dialog)jDialog);
                jDialog.setVisible(true);
            }
            catch (DevFailed devFailed) {
                PopupError.show((Component)this.browser, devFailed);
            }
        }
    }

    void serverArchitecture() {
        Object object = this.getSelectedNode().getUserObject();
        String string = null;
        try {
            Object object2;
            if (object instanceof BrowserDevice) {
                object2 = (BrowserDevice)((Object)object);
                DeviceInfo deviceInfo = object2.get_info();
                string = deviceInfo.server;
            } else if (object instanceof BrowserServer) {
                string = ((BrowserServer)object).name;
            }
            if (string != null) {
                object2 = new ServArchitectureDialog((JFrame)this.browser, string);
                ATKGraphicsUtils.centerDialog((Dialog)object2);
                ((Dialog)object2).setVisible(true);
            }
        }
        catch (DevFailed devFailed) {
            this.displayException((Exception)((Object)devFailed));
        }
    }

    private void displayException(Exception exception) {
        this.browser.setText(AstorUtil.strException(exception));
    }

    void deviceMonitor() {
        Object object = this.getSelectedNode().getUserObject();
        if (object instanceof BrowserDevice) {
            String string = ((BrowserDevice)((Object)object)).name;
            MainPanel mainPanel = new MainPanel(string, false, true);
            ATKGraphicsUtils.centerFrameOnScreen((Frame)mainPanel);
        }
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    private BrowserAttribute getAttribute(Object object) {
        if (object == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof BrowserAttribute) {
            return (BrowserAttribute)object2;
        }
        return null;
    }

    void add(int n) {
        BrowserAttribute browserAttribute = this.getAttribute(this.getSelectedNode());
        if (browserAttribute != null) {
            this.browser.add(browserAttribute.attname, n);
        }
    }

    void editProperties(int n) {
        BrowserAttribute browserAttribute = this.getAttribute(this.getSelectedNode());
        if (browserAttribute != null) {
            new PropertyDialog(this.browser, browserAttribute.attname, n).showDialog();
            this.displayEventProperties(browserAttribute);
        }
    }

    void managePolling() {
        BrowserAttribute browserAttribute = this.getAttribute(this.getSelectedNode());
        if (browserAttribute != null) {
            this.browser.managePolling(browserAttribute.dev, browserAttribute.name);
        } else {
            Object object = this.getSelectedNode().getUserObject();
            if (object instanceof BrowserDevice) {
                this.browser.managePolling(((BrowserDevice)((Object)object)).name);
            } else if (object instanceof BrowserDevice_2) {
                this.browser.managePolling(((BrowserDevice_2)((Object)object)).name);
            }
        }
    }

    void displayHostPanel() {
        Object object = this.getSelectedNode().getUserObject();
        String string = null;
        if (object instanceof BrowserDevice) {
            string = ((BrowserDevice)((Object)object)).name;
        } else if (object instanceof BrowserServer) {
            string = "dserver/" + ((BrowserServer)object).name;
        }
        if (string != null) {
            this.browser.displayHostPanel(string);
        }
    }

    void gotoServer() {
        Object object = this.getSelectedNode().getUserObject();
        if (object instanceof BrowserDevice) {
            BrowserDevice browserDevice = (BrowserDevice)((Object)object);
            try {
                DefaultMutableTreeNode defaultMutableTreeNode;
                int n;
                DeviceInfo deviceInfo = browserDevice.get_info();
                String string = deviceInfo.server;
                String string2 = string.substring(0, string.indexOf(47));
                String string3 = string.substring(string.indexOf(47) + 1);
                Object[] objectArray = new DefaultMutableTreeNode[4];
                int n2 = 0;
                objectArray[n2] = this.root;
                boolean bl = false;
                for (n = 0; !bl && n < objectArray[n2].getChildCount(); ++n) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[n2].getChildAt(n);
                    bl = defaultMutableTreeNode.toString().equals("Servers");
                    if (!bl) continue;
                    objectArray[++n2] = defaultMutableTreeNode;
                }
                bl = false;
                for (n = 0; !bl && n < objectArray[n2].getChildCount(); ++n) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[n2].getChildAt(n);
                    bl = defaultMutableTreeNode.toString().equals(string2);
                    if (!bl) continue;
                    objectArray[++n2] = defaultMutableTreeNode;
                }
                if (!bl) {
                    this.browser.setText(string2 + " Not Found !");
                    return;
                }
                if (objectArray[n2].getChildCount() == 1 && objectArray[n2].getChildAt(0).toString().equals("dummy")) {
                    this.createInstanceNodes((DefaultMutableTreeNode)objectArray[n2]);
                }
                bl = false;
                for (n = 0; !bl && n < objectArray[n2].getChildCount(); ++n) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)objectArray[n2]).getChildAt(n);
                    Object object2 = defaultMutableTreeNode.getUserObject();
                    if (!(object2 instanceof BrowserServer)) continue;
                    BrowserServer browserServer = (BrowserServer)object2;
                    bl = browserServer.instance.equals(string3);
                    if (!bl) continue;
                    objectArray[++n2] = defaultMutableTreeNode;
                }
                if (!bl) {
                    this.browser.setText(string3 + " Not Found !");
                    return;
                }
                TreePath treePath = new TreePath(objectArray);
                this.setSelectionPath(treePath);
                this.scrollPathToVisible(treePath);
            }
            catch (DevFailed devFailed) {
                this.displayException((Exception)((Object)devFailed));
            }
        }
    }

    String getCollection() {
        Object object = this.getSelectedNode().getUserObject();
        if (object instanceof BrowserDevice_2) {
            return "Servers";
        }
        return "Devices";
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon tangoIcon;
        private ImageIcon serv_icon;
        private ImageIcon dev_icon;
        private ImageIcon attr_icon;
        private ImageIcon class_icon;
        private Font[] fonts;
        private final int TITLE = 0;
        private final int DEVICE = 1;
        private final int ATTR = 2;

        public TangoRenderer() {
            String string = "/app_util/img/";
            this.tangoIcon = new ImageIcon(this.getClass().getResource(string + "network5.gif"));
            this.serv_icon = new ImageIcon(this.getClass().getResource(string + "server.gif"));
            this.dev_icon = new ImageIcon(this.getClass().getResource(string + "device.gif"));
            this.attr_icon = new ImageIcon(this.getClass().getResource(string + "leaf.gif"));
            this.class_icon = new ImageIcon(this.getClass().getResource(string + "class.gif"));
            this.fonts = new Font[3];
            this.fonts[0] = new Font("courrier", 1, 18);
            this.fonts[1] = new Font("Monospaced", 1, 12);
            this.fonts[2] = new Font("Monospaced", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (n == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(this.tangoIcon);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() instanceof String) {
                    this.setFont(this.fonts[0]);
                    if (object.toString().equals("Servers")) {
                        this.setIcon(this.serv_icon);
                    } else if (object.toString().equals("Devices")) {
                        this.setIcon(this.dev_icon);
                    } else if (object.toString().equals("Aliases")) {
                        this.setIcon(this.dev_icon);
                    } else {
                        this.setFont(this.fonts[1]);
                        this.setIcon(this.class_icon);
                    }
                } else if (defaultMutableTreeNode.getUserObject() instanceof BrowserAttribute) {
                    this.setFont(this.fonts[2]);
                    this.setIcon(this.attr_icon);
                } else if (defaultMutableTreeNode.getUserObject() instanceof BrowserDevice) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(this.dev_icon);
                } else if (defaultMutableTreeNode.getUserObject() instanceof BrowserServer) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(this.serv_icon);
                }
            }
            return this;
        }
    }

    private class BrowserAttribute {
        BrowserDevice dev;
        String name;
        String attname;

        BrowserAttribute(String string, BrowserDevice browserDevice) {
            this.name = string;
            this.dev = browserDevice;
            this.attname = browserDevice.name + "/" + string;
        }

        public String toString() {
            return this.name;
        }
    }

    private class BrowserDevice_2
    extends BrowserDevice {
        BrowserDevice_2(String string) throws DevFailed {
            super(string);
        }

        public String toString() {
            return this.name;
        }
    }

    private class BrowserDevice
    extends DeviceProxy {
        String name;
        String member;

        BrowserDevice(String string) throws DevFailed {
            super(string);
            this.name = string;
            int n = string.lastIndexOf(47);
            this.member = n < 0 ? string : string.substring(n + 1);
        }

        BrowserDevice(String string, String string2) throws DevFailed {
            super(string);
            this.name = string;
            this.member = string2;
        }

        public String toString() {
            return this.member;
        }
    }

    private class BrowserServer {
        String name;
        String instance;
        BrowserDevice_2 dev;

        BrowserServer(String string, String string2) {
            this.name = string + "/" + string2;
            this.instance = string2;
            try {
                this.dev = new BrowserDevice_2("dserver/" + this.name);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        public String toString() {
            return this.instance;
        }
    }
}

