/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.TangoHost;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PropListDialog
extends JDialog {
    private JFrame parent;
    private String selectedItem = null;
    private JTextArea pathText = null;
    private String[] props;
    private JPanel jPanel1;
    private JButton addBtn;
    private JButton dismissBtn;
    private JScrollPane jScrollPane1;
    private JList jList;

    private void setList() {
        this.jList.setListData(this.props);
    }

    public PropListDialog(JFrame jFrame, String[] stringArray) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.props = stringArray;
        this.initComponents();
        this.buildlist();
    }

    public PropListDialog(JFrame jFrame, JTextArea jTextArea, TangoHost[] tangoHostArray) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.pathText = jTextArea;
        this.initComponents();
        this.hosts2path(tangoHostArray);
        this.buildlist();
    }

    private boolean alreadyIn(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.elementAt(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    private void hosts2path(TangoHost[] tangoHostArray) {
        try {
            int n;
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < tangoHostArray.length; ++n) {
                String string = "tango/admin/" + tangoHostArray[n].getName();
                DeviceProxy deviceProxy = new DeviceProxy(string);
                DbDatum dbDatum = deviceProxy.get_property("StartDsPath");
                if (dbDatum.is_empty()) continue;
                String[] stringArray = dbDatum.extractStringArray();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.alreadyIn(vector, stringArray[i])) continue;
                    vector.add(stringArray[i]);
                }
            }
            this.props = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                this.props[n] = (String)vector.elementAt(n);
            }
        }
        catch (DevFailed devFailed) {
            PopupError.show((Component)this.parent, devFailed);
        }
    }

    private void buildlist() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PropListDialog.this.listSelectionPerformed(mouseEvent);
            }
        };
        this.jList.addMouseListener(mouseAdapter);
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.addBtn = new JButton();
        this.dismissBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList = new JList();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropListDialog.this.closeDialog(windowEvent);
            }
        });
        this.addBtn.setText("Add");
        this.addBtn.setHorizontalAlignment(4);
        this.addBtn.setFont(new Font("Dialog", 0, 12));
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropListDialog.this.addBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.addBtn);
        this.dismissBtn.setHorizontalTextPosition(4);
        if (this.pathText == null) {
            this.dismissBtn.setText("Cancel");
        } else {
            this.dismissBtn.setText("Dismiss");
        }
        this.dismissBtn.setHorizontalAlignment(4);
        this.dismissBtn.setFont(new Font("Dialog", 0, 12));
        this.dismissBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropListDialog.this.dismissBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.dismissBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jList.setFont(new Font("Courier", 1, 12));
        this.jScrollPane1.setPreferredSize(new Dimension(450, 300));
        this.jScrollPane1.setMinimumSize(new Dimension(450, 300));
        this.jScrollPane1.setViewportView(this.jList);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
    }

    private void dismissBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void addBtnActionPerformed(ActionEvent actionEvent) {
        this.retreiveSelectedItem();
    }

    private void listSelectionPerformed(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.retreiveSelectedItem();
        }
    }

    private void retreiveSelectedItem() {
        this.selectedItem = (String)this.jList.getSelectedValue();
        if (this.pathText != null) {
            this.pathText.append(this.selectedItem + "\n");
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void showDialog() {
        this.setList();
        Point point = this.parent.getLocationOnScreen();
        point.x += (this.parent.getWidth() - this.getWidth()) / 2 + 50;
        point.y += (this.parent.getHeight() - this.getHeight()) / 2 + 50;
        this.setLocation(point);
        this.setVisible(true);
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }
}

