/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.GetTextDialog;
import app_util.PopupError;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class PreferenceDialog
extends JDialog {
    private JFrame parent;
    private String[] last_collection = new String[0];
    private String[] known_tango_hosts = new String[0];
    private String[] tools = new String[0];
    private String[] pages = new String[]{"Device Servers", "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/index.html"};
    private boolean jiveReadOnly = false;
    private JButton cancelBtn;
    private JButton helpPagesBtn;
    private JLabel hostDlgHeightLbl;
    private JTextField hostDlgHeighttTxt;
    private JLabel hostDlgWidthLbl;
    private JTextField hostDlgWidthtTxt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator5;
    private JSeparator jSeparator7;
    private JRadioButton jiveRObtn;
    private JButton lastCollectionBtn;
    private JButton okBtn;
    private JPanel prefPanel;
    private JTextField rshCmdTxt;
    private JTextField rshUserTxt;
    private JButton tangoHostsBtn;
    private JLabel titleLabel;
    private JButton toolsBtn;
    private JLabel treeHeightLbl;
    private JTextField treeHeighttTxt;
    private JLabel treeWidthLbl;
    private JTextField treeWidthtTxt;

    public PreferenceDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.initComponents();
        this.initialize();
        this.titleLabel.setText(AstorUtil.getTangoHost() + "  preferences");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void storePreferences() {
        String string = this.rshUserTxt.getText();
        String string2 = this.rshCmdTxt.getText();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.tools == null) {
            this.tools = new String[0];
        }
        if (this.last_collection == null) {
            this.last_collection = new String[0];
        }
        if (this.known_tango_hosts == null) {
            this.known_tango_hosts = new String[0];
        }
        if (this.pages == null) {
            this.pages = new String[0];
        }
        AstorUtil astorUtil = AstorUtil.getInstance();
        astorUtil.setJiveReadOnly(this.jiveReadOnly);
        AstorUtil.setRloginUser(string);
        AstorUtil.setRloginCmd(string2);
        astorUtil.setLastCollectionList(this.last_collection);
        AstorUtil.setKnownTangoHosts(this.known_tango_hosts);
        AstorUtil.setTools(this.tools);
        AstorUtil.setHtmlHelps(this.pages);
        if (this.parent instanceof Astor) {
            try {
                int n = Integer.parseInt(this.treeWidthtTxt.getText());
                int n2 = Integer.parseInt(this.treeHeighttTxt.getText());
                Dimension dimension = new Dimension(n, n2);
                ((Astor)this.parent).setTreeSize(dimension);
                AstorUtil.setPreferredSize(dimension);
                n = Integer.parseInt(this.hostDlgWidthtTxt.getText());
                n2 = Integer.parseInt(this.hostDlgHeighttTxt.getText());
                dimension = new Dimension(n, n2);
                AstorUtil.setHostDialogPreferredSize(dimension);
                ((Astor)this.parent).tree.hostDialogs.setDialogPreferredSize(dimension);
            }
            catch (NumberFormatException numberFormatException) {
                PopupError.show((Component)this, numberFormatException);
            }
        }
        try {
            AstorUtil.putAstorProperties();
            PopupMessage.show((Component)this, "The preferences have been saved for " + AstorUtil.getTangoHost());
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot put Astor properties", (DevFailed)devFailed);
        }
    }

    private void initialize() {
        String string;
        AstorUtil astorUtil = AstorUtil.getInstance();
        this.last_collection = astorUtil.getLastCollectionList();
        this.known_tango_hosts = AstorUtil.getKnownTangoHosts();
        this.tools = AstorUtil.getTools();
        this.pages = AstorUtil.getHtmlHelps();
        this.jiveReadOnly = astorUtil.jiveIsReadOnly();
        this.setJiveBtn(this.jiveReadOnly);
        String string2 = AstorUtil.getRloginUser();
        if (string2 != null) {
            this.rshUserTxt.setText(string2);
        }
        if ((string = AstorUtil.getRloginCmd()) != null) {
            this.rshCmdTxt.setText(string);
        }
        if (this.parent instanceof Astor) {
            Dimension dimension = ((Astor)this.parent).getTreeSize();
            this.treeWidthtTxt.setText(Integer.toString(dimension.width));
            this.treeHeighttTxt.setText(Integer.toString(dimension.height));
            dimension = AstorUtil.getHostDialogPreferredSize();
            this.hostDlgWidthtTxt.setText(Integer.toString(dimension.width));
            this.hostDlgHeighttTxt.setText(Integer.toString(dimension.height));
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.prefPanel = new JPanel();
        this.treeWidthLbl = new JLabel();
        this.treeWidthtTxt = new JTextField();
        this.treeHeightLbl = new JLabel();
        this.treeHeighttTxt = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.rshUserTxt = new JTextField();
        this.jLabel2 = new JLabel();
        this.rshCmdTxt = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jLabel5 = new JLabel();
        this.jiveRObtn = new JRadioButton();
        this.jSeparator5 = new JSeparator();
        this.jSeparator7 = new JSeparator();
        this.lastCollectionBtn = new JButton();
        this.tangoHostsBtn = new JButton();
        this.toolsBtn = new JButton();
        this.helpPagesBtn = new JButton();
        this.hostDlgWidthLbl = new JLabel();
        this.hostDlgHeightLbl = new JLabel();
        this.hostDlgWidthtTxt = new JTextField();
        this.hostDlgHeighttTxt = new JTextField();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PreferenceDialog.this.closeDialog(windowEvent);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.prefPanel.setLayout(new GridBagLayout());
        this.treeWidthLbl.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.treeWidthLbl.setHorizontalAlignment(4);
        this.treeWidthLbl.setText("Hosts Tree Width:  ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.treeWidthLbl, gridBagConstraints);
        this.treeWidthtTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.treeWidthtTxt, gridBagConstraints);
        this.treeHeightLbl.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.treeHeightLbl.setHorizontalAlignment(4);
        this.treeHeightLbl.setText("Hosts Tree Heght:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.treeHeightLbl, gridBagConstraints);
        this.treeHeighttTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.treeHeighttTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.prefPanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel1.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Remote login user :  ");
        this.jLabel1.setToolTipText("Default user name used for remote login on a host.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.rshUserTxt.setColumns(12);
        this.rshUserTxt.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.rshUserTxt.setToolTipText("Default user name used for remote login on a host.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.rshUserTxt, gridBagConstraints);
        this.jLabel2.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Remote login command :  ");
        this.jLabel2.setToolTipText("Command used for remote login on a host (rlogin, ssh, ...).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.rshCmdTxt.setColumns(12);
        this.rshCmdTxt.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.rshCmdTxt.setText("rlogin");
        this.rshCmdTxt.setToolTipText("Command used for remote login on a host (rlogin, ssh, ...).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.rshCmdTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.prefPanel.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.prefPanel.add((Component)this.jSeparator3, gridBagConstraints);
        this.jLabel5.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.jLabel5.setText("Start Jive in READ_ONLY mode :");
        this.jLabel5.setToolTipText("Mode to start jive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.jiveRObtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.jiveRObtn.setText("false");
        this.jiveRObtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jiveRObtn.setMargin(new Insets(0, 0, 0, 0));
        this.jiveRObtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.jiveRObtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        this.prefPanel.add((Component)this.jiveRObtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.prefPanel.add((Component)this.jSeparator5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.prefPanel.add((Component)this.jSeparator7, gridBagConstraints);
        this.lastCollectionBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.lastCollectionBtn.setText("Last Collections :");
        this.lastCollectionBtn.setToolTipText("List of collections (families) displayed at the end of the control system tree.");
        this.lastCollectionBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.lastCollectionBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.lastCollectionBtn, gridBagConstraints);
        this.tangoHostsBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.tangoHostsBtn.setText("Known Tango Hosts");
        this.tangoHostsBtn.setToolTipText("List of   TANGO_HOST known (used to change during execution).");
        this.tangoHostsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.tangoHostsBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.tangoHostsBtn, gridBagConstraints);
        this.toolsBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.toolsBtn.setText("Additional tools :");
        this.toolsBtn.setToolTipText("List of  additiannal tools (see  Astor pages).");
        this.toolsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.toolsBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.toolsBtn, gridBagConstraints);
        this.helpPagesBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.helpPagesBtn.setText("Help pages");
        this.helpPagesBtn.setToolTipText("List of   help  pages (as tools see Astor pages).");
        this.helpPagesBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.helpPagesBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.helpPagesBtn, gridBagConstraints);
        this.hostDlgWidthLbl.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.hostDlgWidthLbl.setHorizontalAlignment(4);
        this.hostDlgWidthLbl.setText("Host Panel Width:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.hostDlgWidthLbl, gridBagConstraints);
        this.hostDlgHeightLbl.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.hostDlgHeightLbl.setHorizontalAlignment(4);
        this.hostDlgHeightLbl.setText("Host Panel Heght:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.hostDlgHeightLbl, gridBagConstraints);
        this.hostDlgWidthtTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.hostDlgWidthtTxt, gridBagConstraints);
        this.hostDlgHeighttTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.hostDlgHeighttTxt, gridBagConstraints);
        this.getContentPane().add((Component)this.prefPanel, "Center");
        this.pack();
    }

    private void helpPagesBtnActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        GetTextDialog getTextDialog = new GetTextDialog(this, jButton.getText(), jButton.getToolTipText(), this.pages);
        if (getTextDialog.showDialog() == 0) {
            this.pages = getTextDialog.getTextLines();
        }
    }

    private void toolsBtnActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        GetTextDialog getTextDialog = new GetTextDialog(this, jButton.getText(), jButton.getToolTipText(), this.tools);
        if (getTextDialog.showDialog() == 0) {
            this.tools = getTextDialog.getTextLines();
        }
    }

    private void tangoHostsBtnActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        GetTextDialog getTextDialog = new GetTextDialog(this, jButton.getText(), jButton.getToolTipText(), this.known_tango_hosts);
        if (getTextDialog.showDialog() == 0) {
            this.known_tango_hosts = getTextDialog.getTextLines();
        }
    }

    private void lastCollectionBtnActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        GetTextDialog getTextDialog = new GetTextDialog(this, jButton.getText(), jButton.getToolTipText(), this.last_collection);
        if (getTextDialog.showDialog() == 0) {
            this.last_collection = getTextDialog.getTextLines();
        }
    }

    private void setJiveBtn(boolean bl) {
        this.jiveRObtn.setSelected(bl);
        this.jiveRObtn.setText("" + bl);
    }

    private void jiveRObtnActionPerformed(ActionEvent actionEvent) {
        this.jiveReadOnly = this.jiveRObtn.getSelectedObjects() != null;
        this.setJiveBtn(this.jiveReadOnly);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.storePreferences();
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        if (this.parent instanceof Astor) {
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        new PreferenceDialog(new JFrame()).setVisible(true);
    }
}

