/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.DbaseObject;
import admin.astor.HostInfoDialog;
import admin.astor.HostInfoDialogVector;
import admin.astor.HostStateThread;
import admin.astor.RemoteLoginThread;
import admin.astor.RenameDialog;
import admin.astor.TangoHost;
import admin.astor.TreePopupMenu;
import app_util.PopupError;
import app_util.PopupMessage;
import app_util.PopupText;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive3.MainPanel;

public class AstorTree
extends JTree
implements AstorDefs {
    private JFrame parent;
    public TangoHost[] hosts;
    private TangoHost selected_host = null;
    private DbaseObject selected_db = null;
    private DbaseObject[] dbase;
    private DefaultTreeModel treeModel;
    private Timer watchDogTimer;
    private MainPanel jive3 = null;
    private TreePopupMenu pMenu;
    private DbPopupMenu dbMenu;
    HostInfoDialogVector hostDialogs = null;
    private static String[] collec_names;
    private static DefaultMutableTreeNode root;
    private static int host_subscribed;
    private static Vector<TangoHost> hosts_using_evt;
    public static final Color background;
    String start_host_err = "";
    private Splash splash;
    private boolean jive_is_read_only = false;

    public AstorTree(JFrame jFrame, boolean bl, Splash splash) throws DevFailed {
        this.parent = jFrame;
        this.splash = splash;
        splash.setMessage("Initializing from Database....");
        int n = 0;
        splash.progress(n);
        this.initComponent();
        this.setBackground(background);
        host_subscribed = 0;
        hosts_using_evt = new Vector();
        splash.setMaxProgress(this.hosts.length);
        for (TangoHost tangoHost : this.hosts) {
            splash.progress(++n);
            splash.setMessage("Creating  " + (Object)((Object)tangoHost) + "  object");
            tangoHost.do_polling = false;
            if (bl) {
                tangoHost.setPolling(null);
            }
            if (tangoHost.use_events) {
                hosts_using_evt.add(tangoHost);
            }
            tangoHost.thread = new HostStateThread(this, tangoHost);
            tangoHost.thread.start();
        }
        this.hostDialogs = new HostInfoDialogVector();
        if (host_subscribed == 0) {
            splash.setMaxProgress(hosts_using_evt.size());
        }
        new subscribeThread().start();
        this.updateMonitor(null);
        this.pMenu = jFrame instanceof Astor ? new TreePopupMenu((Astor)jFrame, this) : new TreePopupMenu(this);
        this.dbMenu = new DbPopupMenu(this);
        this.expandRow(1);
        int n2 = 10000;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.watchDogTimer = new Timer(n2, actionListener);
        this.watchDogTimer.start();
    }

    void updateMonitor(String string) {
        if (string != null) {
            this.start_host_err = this.start_host_err + string + "\n\n";
        }
        if (host_subscribed < hosts_using_evt.size()) {
            TangoHost tangoHost = hosts_using_evt.get(host_subscribed);
            String string2 = "Subscribing for  " + tangoHost.getName() + "  (" + (host_subscribed + 1) + "/" + hosts_using_evt.size() + ")";
            if (Astor.displayed) {
                this.splash.setVisible(true);
            }
            this.splash.progress(++host_subscribed);
            this.splash.setMessage(string2);
        } else {
            this.splash.setVisible(false);
            if (this.start_host_err.length() > 0) {
                PopupMessage.show((Component)this, this.start_host_err);
            }
        }
    }

    void stopThreads() {
        this.watchDogTimer.stop();
        for (TangoHost tangoHost : this.hosts) {
            tangoHost.stopThread();
        }
    }

    void expand(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.hosts.length + collec_names.length + 1; ++i) {
                this.expandRow(i);
            }
        } else {
            for (int i = 1; i <= collec_names.length; ++i) {
                this.collapseRow(i);
            }
        }
    }

    private void initComponent() throws DevFailed {
        root = new DefaultMutableTreeNode("TANGO Control System");
        this.initTangoObjects();
        this.createNodes(root);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                AstorTree.this.hostSelectionPerformed(treeSelectionEvent);
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                AstorTree.this.collapsedPerfomed(treeExpansionEvent);
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AstorTree.this.treeMouseClicked(mouseEvent);
            }
        });
        this.setExpandsSelectedPaths(true);
    }

    private void initTangoObjects() throws DevFailed {
        String string = AstorUtil.getTangoHost();
        StringTokenizer stringTokenizer = string.indexOf(",") > 0 ? new StringTokenizer(string, ",") : new StringTokenizer(string);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        this.dbase = new DbaseObject[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.dbase[i] = new DbaseObject(this, (String)vector.elementAt(i));
        }
        AstorUtil astorUtil = AstorUtil.getInstance();
        long l = System.currentTimeMillis();
        this.hosts = astorUtil.getTangoHostList();
        long l2 = System.currentTimeMillis();
        System.out.println("getTangoHostList() :" + (l2 - l) + " ms");
        collec_names = astorUtil.getCollectionList(this.hosts);
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        int n = 0;
        this.splash.progress(n);
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        for (String string : collec_names) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            vector.add(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        for (DbaseObject dbaseObject : this.dbase) {
            ((DefaultMutableTreeNode)vector.get(0)).add(new DefaultMutableTreeNode(dbaseObject));
        }
        this.splash.setMaxProgress(this.hosts.length);
        for (TangoHost tangoHost : this.hosts) {
            this.splash.progress(++n);
            this.splash.setMessage("Creating  " + (Object)((Object)tangoHost) + "  node");
            defaultMutableTreeNode2 = new DefaultMutableTreeNode((Object)tangoHost);
            tangoHost.state = 0;
            int n2 = this.getHostCollection(tangoHost);
            ((DefaultMutableTreeNode)vector.get(n2)).add(defaultMutableTreeNode2);
        }
    }

    String[] getCollectionList() {
        return collec_names;
    }

    int getHostCollection(TangoHost tangoHost) {
        for (int i = 0; i < collec_names.length; ++i) {
            if (tangoHost.collection == null) {
                return collec_names.length - 1;
            }
            if (!tangoHost.collection.equals(collec_names[i])) continue;
            return i;
        }
        return collec_names.length - 1;
    }

    public void collapsedPerfomed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath.getPathCount() > 2) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        boolean bl = ((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0)).getUserObject() instanceof DbaseObject;
        if (treePath.getPathCount() == 1 || bl) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
            Object[] objectArray = defaultMutableTreeNode2.getPath();
            this.setExpandedState(new TreePath(objectArray), true);
            if (treePath.getPathCount() == 1) {
                String string = "TANGO Control System\n\n";
                string = string + this.hosts.length + " hosts controled.\n";
                int n = 0;
                for (TangoHost tangoHost : this.hosts) {
                    if (!tangoHost.use_events) continue;
                    ++n;
                }
                if (n == this.hosts.length) {
                    string = string + "All are controled on events.";
                } else if (n > 0) {
                    string = string + n + " are controled on events.";
                }
                PopupMessage.showImage((Component)this.parent, string, "/app_util/img/tango_icon.jpg");
            }
        }
    }

    private Rectangle computeBounds(TreePath treePath) {
        this.scrollPathToVisible(treePath);
        Rectangle rectangle = this.getPathBounds(treePath);
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, this);
        rectangle.setLocation(point);
        rectangle.width += 20;
        rectangle.height += 2;
        return rectangle;
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        return defaultMutableTreeNode.getUserObject();
    }

    void changeNodeName() {
        Rectangle rectangle = this.computeBounds(this.getSelectionPath());
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        RenameDialog renameDialog = new RenameDialog((Frame)this.parent, defaultMutableTreeNode.toString(), rectangle);
        if (renameDialog.showDlg()) {
            String string = renameDialog.getNewName();
            try {
                DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
                int n = defaultMutableTreeNode2.getChildCount();
                for (int i = 0; i < n; ++i) {
                    defaultMutableTreeNode2 = defaultMutableTreeNode2.getNextNode();
                    TangoHost tangoHost = (TangoHost)((Object)defaultMutableTreeNode2.getUserObject());
                    tangoHost.setCollection(string);
                }
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                return;
            }
            defaultMutableTreeNode.setUserObject(string);
        }
    }

    void addBranch(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
    }

    void moveNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        try {
            object = (TangoHost)((Object)defaultMutableTreeNode.getUserObject());
            ((TangoHost)((Object)object)).setCollection((String)defaultMutableTreeNode3.getUserObject());
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
            return;
        }
        object = (DefaultTreeModel)this.getModel();
        ((DefaultTreeModel)object).removeNodeFromParent(defaultMutableTreeNode);
        ((DefaultTreeModel)object).insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode3, 0);
        if (defaultMutableTreeNode2.getChildCount() == 0) {
            ((DefaultTreeModel)object).removeNodeFromParent(defaultMutableTreeNode2);
        }
        this.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
    }

    public void hostSelectionPerformed(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf()) {
            if (object instanceof TangoHost) {
                this.selected_host = (TangoHost)((Object)object);
                this.selected_db = null;
            } else if (object instanceof DbaseObject) {
                this.selected_host = null;
                this.selected_db = (DbaseObject)object;
            } else {
                this.selected_host = null;
                this.selected_db = null;
            }
        } else {
            this.selected_host = null;
            this.selected_db = null;
        }
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) < 1) {
            return;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        this.setSelectionPath(treePath);
        int n = mouseEvent.getModifiers();
        if (mouseEvent.getClickCount() == 2) {
            if ((n & 0x10) != 0) {
                if (this.selected_host != null) {
                    this.displayHostInfo();
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (this.selected_db != null || object.toString().equals(collec_names[0])) {
                        this.displayJiveAppli();
                    }
                }
            }
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if ((n & 4) != 0) {
                if (object instanceof DbaseObject) {
                    this.dbMenu.showMenu(mouseEvent);
                } else {
                    this.pMenu.showMenu(mouseEvent);
                }
            }
        }
    }

    public void setSelectionPath(String string) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)root.getChildAt(i);
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof TangoHost)) continue;
                String string2 = defaultMutableTreeNode2.toString();
                int n = string2.indexOf(40);
                if (n > 0) {
                    string2 = string2.substring(0, n).trim();
                }
                if (!string2.equals(string)) continue;
                this.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
            }
        }
    }

    void displayJiveAppli() {
        if (this.selected_db != null && this.selected_db.state == 1) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)this.selected_db.except);
        } else {
            boolean bl = false;
            boolean bl2 = AstorUtil.getInstance().jiveIsReadOnly();
            if (this.jive_is_read_only != bl2 || this.jive3 == null) {
                this.jive3 = new MainPanel(bl, bl2);
            }
            this.jive3.setVisible(true);
            this.jive3.toFront();
            this.jive_is_read_only = bl2;
        }
    }

    void changeHostNode(TangoHost tangoHost) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        int n = 0;
        for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
            if (!defaultMutableTreeNode2.getChildAt(i).equals(defaultMutableTreeNode)) continue;
            n = i;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode((Object)tangoHost);
        this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, n);
        this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        Object[] objectArray = defaultMutableTreeNode3.getPath();
        this.setSelectionPath(new TreePath(objectArray));
    }

    public void displayHostInfoDialog(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        string = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string, ".");
        string = stringTokenizer.nextToken();
        this.parent.setVisible(true);
        this.setSelectionPath(new TreePath(root.getPath()));
        this.setSelectionPath(string);
        this.displayHostInfo();
    }

    public void displayHostInfo(String string) {
        try {
            String string2 = new IORdump(string).get_host();
            if (string2 == null) {
                Except.throw_exception((String)"UNKNOWN_HOST", (String)"May be this device has never been exported !", (String)"");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            string2 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string2, ".");
            string2 = stringTokenizer.nextToken();
            this.parent.setVisible(true);
            this.setSelectionPath(new TreePath(root.getPath()));
            this.setSelectionPath(string2);
            this.displayHostInfo();
            String string3 = new DeviceProxy(string).adm_name();
            string3 = string3.substring(string3.indexOf(47) + 1);
            HostInfoDialog hostInfoDialog = this.hostDialogs.getByHostName(this.selected_host);
            if (hostInfoDialog != null) {
                hostInfoDialog.setSelection(string3);
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    public void displayHostInfo() {
        if (this.selected_host == null) {
            PopupError.show((Component)this, "this Host is not controlled by Astor !");
            return;
        }
        if (!this.selected_host.do_polling) {
            this.selected_host.do_polling = true;
            this.selected_host.updateData();
            this.sleep(1000);
        }
        if (this.selected_host.state == 1 && this.selected_host.except != null) {
            String string = this.selected_host.except.errors[0].reason;
            String string2 = this.selected_host.except.errors[0].desc;
            if (string.equals("TangoApi_DEVICE_NOT_EXPORTED") || string2.indexOf("CORBA.TRANSIENT: Retries exceeded,") > 0) {
                if (AstorUtil.osIsUnix()) {
                    if (JOptionPane.showConfirmDialog(this.parent, "Starter is not running on " + (Object)((Object)this.selected_host) + "\n\n\n" + "Do you want a remote login to start it ?", "Dialog", 0) == 0) {
                        new RemoteLoginThread(this.selected_host.getName(), this.parent).start();
                    }
                } else {
                    PopupError.show((Component)this.parent, "Starter is not running on " + (Object)((Object)this.selected_host) + " !!!");
                }
            } else {
                PopupError.show((Component)this.parent, "Starter on " + (Object)((Object)this.selected_host), this.selected_host.except);
            }
        } else if (this.selected_host.state == 0) {
            PopupMessage.show((Component)this.parent, "Connection with Starter device server is blocked !");
        } else if (this.parent instanceof Astor) {
            this.hostDialogs.add((Astor)this.parent, this.selected_host);
        }
    }

    void displayBranchInfo() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        String string = defaultMutableTreeNode + ":\n\n";
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = defaultMutableTreeNode.getNextNode();
            TangoHost tangoHost = (TangoHost)((Object)defaultMutableTreeNode.getUserObject());
            string = string + tangoHost.hostStatus();
        }
        PopupMessage.show((Component)this.parent, string);
    }

    public void updateState() {
        this.repaint();
        if (this.hostDialogs != null) {
            for (TangoHost tangoHost : this.hosts) {
                if (tangoHost.state != 1) continue;
                this.hostDialogs.close(tangoHost);
            }
        }
    }

    private synchronized void sleep(int n) {
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        host_subscribed = 0;
        background = new Color(240, 240, 240);
    }

    class DbPopupMenu
    extends JPopupMenu {
        private JTree tree;
        private final String[] menuLabels = new String[]{"Server Info", "Database Info", "Database Black Box", "Browse Database (Jive)"};
        private final int OFFSET = 2;
        private final int SERVER_INFO = 0;
        private final int DATABASE_INFO = 1;
        private final int DATABASE_BLACKBOX = 2;
        private final int BROWSE_DATABASE = 3;

        DbPopupMenu(JTree jTree) {
            this.tree = jTree;
            JLabel jLabel = new JLabel("Datbase Server :");
            jLabel.setFont(new Font("Dialog", 1, 16));
            this.add(jLabel);
            this.add(new JPopupMenu.Separator());
            for (String string : this.menuLabels) {
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DbPopupMenu.this.treeActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        public void showMenu(MouseEvent mouseEvent) {
            Object object = AstorTree.this.getSelectedObject();
            JLabel jLabel = (JLabel)this.getComponent(0);
            jLabel.setText(object.toString() + "  :");
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        private void treeActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < this.menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            try {
                switch (n) {
                    case 3: {
                        AstorTree.this.displayJiveAppli();
                        break;
                    }
                    default: {
                        this.manageOneDbaseOption(n);
                        break;
                    }
                }
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }

        private void manageOneDbaseOption(int n) throws DevFailed {
            DbaseObject dbaseObject = (DbaseObject)AstorTree.this.getSelectedObject();
            PopupText popupText = new PopupText((Frame)AstorTree.this.parent, true);
            switch (n) {
                case 0: {
                    popupText.show(dbaseObject.getServerInfo());
                    break;
                }
                case 1: {
                    popupText.show(dbaseObject.getInfo());
                    break;
                }
                case 2: {
                    dbaseObject.blackbox(AstorTree.this.parent);
                }
            }
        }
    }

    class subscribeThread
    extends Thread {
        subscribeThread() {
        }

        public void run() {
            long l = System.currentTimeMillis();
            int n = 0;
            for (TangoHost tangoHost : AstorTree.this.hosts) {
                if (!tangoHost.use_events) continue;
                tangoHost.thread.subscribeChangeStateEvent();
                ++n;
            }
            long l2 = System.currentTimeMillis();
            System.out.println("Total time to subscribe on " + n + " hosts : " + (l2 - l) + " ms");
            System.out.println("Total time to start Astor " + (l2 - Astor.t0) + " ms");
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon tangoIcon;
        private ImageIcon dbIcon = new ImageIcon(this.getClass().getResource("/app_util/img/MySql.gif"));
        private Font[] fonts;

        public TangoRenderer() {
            this.tangoIcon = new ImageIcon(this.getClass().getResource("/app_util/img/TangoSmall.gif"));
            this.fonts = new Font[2];
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            if (n == 0) {
                this.setBackgroundSelectionColor(background);
                this.setIcon(this.tangoIcon);
                this.setFont(this.fonts[0]);
            } else if (this.isDatabase(object)) {
                if (bl3) {
                    this.setBackgroundSelectionColor(Color.lightGray);
                    DbaseObject dbaseObject = this.getDbase(object);
                    this.setIcon(AstorUtil.state_icons[dbaseObject.state]);
                    this.setFont(this.fonts[1]);
                } else {
                    this.setBackgroundSelectionColor(background);
                    int n2 = 3;
                    for (DbaseObject dbaseObject : AstorTree.this.dbase) {
                        if (dbaseObject.state != 1) continue;
                        n2 = 1;
                    }
                    if (n2 == 1) {
                        this.setForeground(Color.red);
                    }
                    this.setIcon(this.dbIcon);
                    this.setFont(this.fonts[0]);
                }
            } else if (this.isHost(object)) {
                this.setBackgroundSelectionColor(Color.lightGray);
                this.setFont(this.fonts[1]);
                this.setBackgroundNonSelectionColor(background);
                TangoHost tangoHost = this.getHost(object);
                int n3 = tangoHost.state;
                if (n3 == 0 && tangoHost.do_polling) {
                    n3 = 5;
                }
                this.setIcon(AstorUtil.state_icons[n3]);
            } else {
                this.setBackgroundSelectionColor(Color.lightGray);
                this.setFont(this.fonts[0]);
                int n4 = this.branchState(object);
                this.setIcon(AstorUtil.state_icons[n4]);
            }
            return this;
        }

        protected int branchState(Object object) {
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            int n2 = defaultMutableTreeNode.getChildCount();
            TangoHost[] tangoHostArray = new TangoHost[n2];
            for (n = 0; n < n2; ++n) {
                defaultMutableTreeNode = defaultMutableTreeNode.getNextNode();
                tangoHostArray[n] = (TangoHost)((Object)defaultMutableTreeNode.getUserObject());
            }
            n = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < n2; ++i) {
                if (tangoHostArray[i].do_polling) {
                    if (tangoHostArray[i].state == 0) {
                        return 0;
                    }
                    if (tangoHostArray[i].state == 1) {
                        n = 1;
                        continue;
                    }
                    if (tangoHostArray[i].state == 2) {
                        bl = true;
                        continue;
                    }
                    if (tangoHostArray[i].state != 4) continue;
                    bl3 = true;
                    continue;
                }
                bl2 = true;
            }
            int n3 = bl2 ? 0 : (n != 0 ? 1 : (bl3 ? 4 : (bl ? 2 : 3)));
            return n3;
        }

        protected boolean isHost(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            return object2 instanceof TangoHost;
        }

        protected TangoHost getHost(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof TangoHost) {
                return (TangoHost)((Object)object2);
            }
            return null;
        }

        protected DbaseObject getDbase(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof DbaseObject) {
                return (DbaseObject)object2;
            }
            return null;
        }

        protected boolean isDatabase(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof DbaseObject) {
                return true;
            }
            if (object2 instanceof String) {
                String string = (String)object2;
                return string.equals(collec_names[0]);
            }
            return false;
        }
    }
}

