/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class Rotator
implements ExtendedPlugInFilter,
DialogListener {
    private int flags = 32863;
    private static double angle = 15.0;
    private static boolean interpolate = true;
    private static boolean fillWithBackground;
    private static boolean enlarge;
    private static int gridLines;
    private ImagePlus imp;
    private int bitDepth;
    boolean canEnlarge;
    boolean isEnlarged;
    GenericDialog gd;
    PlugInFilterRunner pfr;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (imp != null) {
            this.bitDepth = imp.getBitDepth();
            Roi roi = imp.getRoi();
            Rectangle r = roi != null ? roi.getBounds() : null;
            this.canEnlarge = r == null || r.x == 0 && r.y == 0 && r.width == imp.getWidth() && r.height == imp.getHeight();
        }
        return this.flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ImageProcessor ip) {
        if (enlarge && this.gd.wasOKed()) {
            Rotator rotator = this;
            synchronized (rotator) {
                if (!this.isEnlarged) {
                    this.enlargeCanvas();
                    this.isEnlarged = true;
                }
            }
        }
        if (this.isEnlarged) {
            int slice = this.pfr.getSliceNumber();
            ip = this.imp.getStackSize() == 1 ? this.imp.getProcessor() : this.imp.getStack().getProcessor(slice);
        }
        ip.setInterpolate(interpolate);
        if (fillWithBackground) {
            Color bgc = Toolbar.getBackgroundColor();
            if (this.bitDepth == 8) {
                ip.setBackgroundValue(ip.getBestIndex(bgc));
            } else if (this.bitDepth == 24) {
                ip.setBackgroundValue(bgc.getRGB());
            }
        } else {
            ip.setBackgroundValue(0.0);
        }
        ip.rotate(angle);
        if (!this.gd.wasOKed()) {
            this.drawGridLines(gridLines);
        }
        if (this.isEnlarged && this.imp.getStackSize() == 1) {
            this.imp.changes = true;
            this.imp.updateAndDraw();
            Undo.setup(5, this.imp);
        }
    }

    void enlargeCanvas() {
        this.imp.unlock();
        if (this.imp.getStackSize() == 1) {
            Undo.setup(4, this.imp);
        }
        IJ.run("Select All");
        IJ.run("Rotate...", "angle=" + angle);
        Roi roi = this.imp.getRoi();
        Rectangle r = roi.getBounds();
        IJ.showStatus("Rotate: Enlarging...");
        IJ.run("Canvas Size...", "width=" + r.width + " height=" + r.height + " position=Center " + (fillWithBackground ? "" : "zero"));
        IJ.showStatus("Rotating...");
    }

    void drawGridLines(int lines) {
        ImageCanvas ic = this.imp.getCanvas();
        if (ic == null) {
            return;
        }
        if (lines == 0) {
            ic.setDisplayList(null);
            return;
        }
        GeneralPath path = new GeneralPath();
        float width = this.imp.getWidth();
        float height = this.imp.getHeight();
        float xinc = width / (float)lines;
        float yinc = height / (float)lines;
        float xstart = xinc / 2.0f;
        float ystart = yinc / 2.0f;
        for (int i = 0; i < lines; ++i) {
            path.moveTo(xstart + xinc * (float)i, 0.0f);
            path.lineTo(xstart + xinc * (float)i, height);
            path.moveTo(0.0f, ystart + yinc * (float)i);
            path.lineTo(width, ystart + yinc * (float)i);
        }
        ic.setDisplayList(path, null, null);
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        this.pfr = pfr;
        this.gd = new GenericDialog("Rotate", IJ.getInstance());
        this.gd.addNumericField("Angle (degrees): ", angle, (double)((int)angle) == angle ? 1 : 2);
        this.gd.addNumericField("Grid Lines: ", gridLines, 0);
        this.gd.addCheckbox("Interpolate", interpolate);
        if (this.bitDepth == 8 || this.bitDepth == 24) {
            this.gd.addCheckbox("Fill with Background Color", fillWithBackground);
        }
        if (this.canEnlarge) {
            this.gd.addCheckbox("Enlarge Image to Fit Result", enlarge);
        } else {
            enlarge = false;
        }
        this.gd.addPreviewCheckbox(pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
        this.drawGridLines(0);
        if (this.gd.wasCanceled()) {
            return 4096;
        }
        if (!enlarge) {
            this.flags |= 0x1000000;
        } else if (imp.getStackSize() == 1) {
            this.flags |= 0x80;
        }
        return IJ.setupDialog(imp, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        angle = gd.getNextNumber();
        if (gd.invalidNumber()) {
            if (gd.wasOKed()) {
                IJ.error("Angle is invalid.");
            }
            return false;
        }
        gridLines = (int)gd.getNextNumber();
        interpolate = gd.getNextBoolean();
        if (this.bitDepth == 8 || this.bitDepth == 24) {
            fillWithBackground = gd.getNextBoolean();
        }
        if (this.canEnlarge) {
            enlarge = gd.getNextBoolean();
        }
        return true;
    }

    public void setNPasses(int nPasses) {
    }

    static {
        gridLines = 1;
    }
}

