/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanSpectrum;
import fr.esrf.tangoatk.core.IBooleanSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

public class BooleanSpectrumHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;

    public BooleanSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireSpectrumValueChanged(boolean[] blArray, long l) {
        this.propChanges.fireBooleanSpectrumEvent((IBooleanSpectrum)this.attribute, blArray, l);
    }

    void insert(boolean[] blArray) {
        this.attribute.getAttribute().insert(blArray, this.attribute.getXDimension(), this.attribute.getYDimension());
    }

    boolean[] extract() throws DevFailed {
        return this.attribute.getAttribute().extractBooleanArray();
    }

    void addBooleanSpectrumListener(IBooleanSpectrumListener iBooleanSpectrumListener) {
        this.propChanges.addBooleanSpectrumListener(iBooleanSpectrumListener);
    }

    void removeBooleanSpectrumListener(IBooleanSpectrumListener iBooleanSpectrumListener) {
        this.propChanges.removeBooleanSpectrumListener(iBooleanSpectrumListener);
    }

    public String getVersion() {
        return "$Id: BooleanSpectrumHelper.java,v 1.2 2009/01/26 17:54:51 poncet Exp $";
    }
}

