/*
 * Decompiled with CFR 0.152.
 */
package atkpanel;

import atkpanel.DevStateSpectrumPanel;
import atkpanel.ImagePanel;
import atkpanel.RawImagePanel;
import atkpanel.SpectrumPanel;
import atkpanel.StringImagePanel;
import atkpanel.StringSpectrumPanel;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IRawImage;
import fr.esrf.tangoatk.core.IStringImage;
import fr.esrf.tangoatk.core.IStringSpectrum;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class RefresherUtil {
    public static void activateRefresh(Component comp) {
        JPanel specComp;
        JPanel imgComp;
        if (comp instanceof ImagePanel) {
            imgComp = (ImagePanel)comp;
            ((ImagePanel)imgComp).getModel().setSkippingRefresh(false);
        }
        if (comp instanceof SpectrumPanel) {
            specComp = (SpectrumPanel)comp;
            ((SpectrumPanel)specComp).getModel().setSkippingRefresh(false);
        }
        if (comp instanceof StringSpectrumPanel) {
            specComp = (StringSpectrumPanel)comp;
            ((StringSpectrumPanel)specComp).getModel().setSkippingRefresh(false);
        }
        if (comp instanceof StringImagePanel) {
            imgComp = (StringImagePanel)comp;
            ((StringImagePanel)imgComp).getModel().setSkippingRefresh(false);
        }
        if (comp instanceof DevStateSpectrumPanel) {
            DevStateSpectrumPanel dssComp = (DevStateSpectrumPanel)comp;
            dssComp.getModel().setSkippingRefresh(false);
        }
        if (comp instanceof RawImagePanel) {
            RawImagePanel rawImgComp = (RawImagePanel)comp;
            rawImgComp.getModel().setSkippingRefresh(false);
        }
    }

    public static void refresh(Component comp) {
        if (comp instanceof ImagePanel) {
            ImagePanel imgComp = (ImagePanel)comp;
            INumberImage ini = imgComp.getModel();
            RefresherUtil.refreshIfNeeded((IAttribute)ini);
        }
        if (comp instanceof SpectrumPanel) {
            SpectrumPanel spectComp = (SpectrumPanel)comp;
            INumberSpectrum ins = spectComp.getModel();
            RefresherUtil.refreshIfNeeded((IAttribute)ins);
        }
        if (comp instanceof StringSpectrumPanel) {
            StringSpectrumPanel strSpectComp = (StringSpectrumPanel)comp;
            IStringSpectrum iss = strSpectComp.getModel();
            RefresherUtil.refreshIfNeeded((IAttribute)iss);
        }
        if (comp instanceof StringImagePanel) {
            StringImagePanel strImageComp = (StringImagePanel)comp;
            IStringImage isi = strImageComp.getModel();
            RefresherUtil.refreshIfNeeded((IAttribute)isi);
        }
        if (comp instanceof DevStateSpectrumPanel) {
            DevStateSpectrumPanel dssComp = (DevStateSpectrumPanel)comp;
            IDevStateSpectrum idss = dssComp.getModel();
            RefresherUtil.refreshIfNeeded((IAttribute)idss);
        }
        if (comp instanceof RawImagePanel) {
            RawImagePanel rawImgComp = (RawImagePanel)comp;
            IRawImage iri = rawImgComp.getModel();
            RefresherUtil.refreshIfNeeded((IAttribute)iri);
        }
    }

    public static void skippingRefresh(Component comp) {
        JPanel specComp;
        JPanel imgComp;
        if (comp instanceof ImagePanel) {
            imgComp = (ImagePanel)comp;
            ((ImagePanel)imgComp).getModel().setSkippingRefresh(true);
        }
        if (comp instanceof SpectrumPanel) {
            specComp = (SpectrumPanel)comp;
            ((SpectrumPanel)specComp).getModel().setSkippingRefresh(true);
        }
        if (comp instanceof StringSpectrumPanel) {
            specComp = (StringSpectrumPanel)comp;
            ((StringSpectrumPanel)specComp).getModel().setSkippingRefresh(true);
        }
        if (comp instanceof StringImagePanel) {
            imgComp = (StringImagePanel)comp;
            ((StringImagePanel)imgComp).getModel().setSkippingRefresh(true);
        }
        if (comp instanceof DevStateSpectrumPanel) {
            DevStateSpectrumPanel dssComp = (DevStateSpectrumPanel)comp;
            dssComp.getModel().setSkippingRefresh(true);
        }
        if (comp instanceof RawImagePanel) {
            RawImagePanel rawImgComp = (RawImagePanel)comp;
            rawImgComp.getModel().setSkippingRefresh(true);
        }
    }

    public static void activateRefreshForAllComponent(JTabbedPane jtabbedPane) {
        Component[] components = jtabbedPane.getComponents();
        for (int i = 0; i < components.length; ++i) {
            RefresherUtil.activateRefresh(components[i]);
        }
    }

    public static void skippingRefreshForAllComponent(JTabbedPane jtabbedPane) {
        Component[] components = jtabbedPane.getComponents();
        for (int i = 0; i < components.length; ++i) {
            RefresherUtil.skippingRefresh(components[i]);
        }
    }

    public static void refreshIfNeeded(IAttribute iatt) {
        if (!iatt.hasEvents()) {
            iatt.refresh();
        }
    }

    public static void skippingRefreshForAllAttributes(AttributeList attl) {
        IAttribute iatt = null;
        int nb_atts = attl.getSize();
        for (int idx = 0; idx < nb_atts; ++idx) {
            iatt = (IAttribute)attl.getElementAt(idx);
            iatt.setSkippingRefresh(true);
        }
    }

    public static void skippingRefreshForExpertAttributes(AttributeList attl) {
        IAttribute iatt = null;
        int nb_atts = attl.getSize();
        for (int idx = 0; idx < nb_atts; ++idx) {
            iatt = (IAttribute)attl.getElementAt(idx);
            if (!iatt.isExpert()) continue;
            iatt.setSkippingRefresh(true);
        }
    }

    public static void activateRefreshForExpertAttributes(AttributeList attl) {
        IAttribute iatt = null;
        int nb_atts = attl.getSize();
        for (int idx = 0; idx < nb_atts; ++idx) {
            iatt = (IAttribute)attl.getElementAt(idx);
            if (!iatt.isExpert()) continue;
            iatt.setSkippingRefresh(false);
        }
    }
}

