/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import pogo.gene.CppServer;
import pogo.gene.CppServerClass;
import pogo.gene.CppStateMachine;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class PogoGeneCpp
extends PogoGene
implements PogoDefs {
    private static final String vc_proj_dir = "vcproj";

    public PogoGeneCpp(PogoClass pogo) {
        super(pogo);
    }

    private void insertAbstractClassPathVc8(String filename) throws FileNotFoundException, SecurityException, IOException {
        String abs_path;
        String templ = "TemplateAbstractPath";
        if (this.pogo.inherited_from.equals("Device_4Impl")) {
            templ = "&quot;" + templ + "&quot;";
            abs_path = "";
        } else {
            abs_path = this.pogo.inheritedClassPath();
        }
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        while (code.indexOf(templ) > 0) {
            code.replace(templ, abs_path);
        }
        PogoUtil.writeFile(filename, code.str);
    }

    private void buildVc8ProjectFiles(String templ_dir, int item) {
        String[] proj_filenames = new String[]{"/Class_dll.vcproj", "/Class_lib.vcproj", "/Server_shared.vcproj", "/Server_static.vcproj"};
        String path = this.pogo.projectFiles.getPath() + "/" + vc_proj_dir;
        File f = new File(path);
        if (!f.exists()) {
            f.mkdir();
        }
        try {
            for (int i = 0; i < proj_filenames.length; ++i) {
                if (!PogoGeneCpp.mustGenerate(path + proj_filenames[i]) && item != 3) continue;
                this.replacePatternFile(templ_dir + proj_filenames[i], path + proj_filenames[i], "TemplateDevServ", this.pogo.class_name);
                this.strTrace = this.strTrace + path + proj_filenames[i] + "     Generated\n";
                this.insertAbstractClassPathVc8(path + proj_filenames[i]);
            }
            String sln_file = path + "/" + this.pogo.class_name + ".sln";
            if (PogoGeneCpp.mustGenerate(sln_file) || item == 3) {
                PogoGeneCpp.copyFile(templ_dir + "DevServ" + ".sln", sln_file, false);
                this.strTrace = this.strTrace + path + "/" + this.pogo.class_name + ".sln     Generated\n";
            }
        }
        catch (Exception e) {
            this.strTrace = this.strTrace + "!!!    VC8 Project Files  CANNOT be Created !!!\n       " + e + "\n";
        }
    }

    private void insertAbstractClassPath(String filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        if (code.str.indexOf("SUPER_HOME") < 0) {
            if (PogoUtil.osIsUnix()) {
                int pos = code.str.indexOf("INCLUDE_DIRS");
                if (pos < 0) {
                    throw new PogoException(filename + " Syntax error");
                }
                code.insert(pos, "SUPER_HOME   =  " + this.pogo.inheritedClassPath() + "\n");
                pos = code.str.indexOf("\\", pos);
                code.insert(pos, " -I$(SUPER_HOME) ");
            } else {
                String target = "/I \".\" ";
                int pos = code.str.indexOf(target);
                if (pos < 0) {
                    throw new PogoException(filename + " Syntax error");
                }
                code.insert(pos, "/I \"" + this.pogo.inheritedClassPath() + ".h\" ");
                pos = code.str.indexOf("SOURCE=" + this.pogo.class_name + ".h");
                if (pos < 0) {
                    throw new PogoException(filename + " Syntax error");
                }
                String new_code = "SOURCE=" + this.pogo.inheritedClassName() + ".h\n" + "# End Source File\n" + "# Begin Source File\n\n";
                code.insert(pos, new_code);
            }
            PogoUtil.writeFile(filename, code.str);
        }
    }

    private void patchCvsTagToMakefile(String filename) throws FileNotFoundException, SecurityException, IOException {
        if (this.pogo.is_abstractclass) {
            return;
        }
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        String new_obj = "show_tag:";
        if (code.str.indexOf(new_obj) > 0) {
            return;
        }
        String template = PogoUtil.readFile(this.pogo.templates_dir + "/cpp/Makefile");
        int start = template.indexOf("RELEASE");
        if (start < 0) {
            return;
        }
        String release = template.substring(start, template.indexOf("\n", start) + 1);
        start = template.indexOf("tag:");
        for (int i = 0; i < 4; ++i) {
            start = template.lastIndexOf(10, start - 1);
        }
        String tagCmd = template.substring(start);
        start = code.str.indexOf("CLASS");
        String classdef = null;
        try {
            classdef = code.str.substring(start, code.str.indexOf("\n", start + 1));
        }
        catch (Exception e) {
            // empty catch block
        }
        start = 0;
        while ((start = code.str.indexOf(10, start)) > 0 && code.str.charAt(start + 1) == '#') {
            ++start;
        }
        int position = start + 2;
        code.insert(position, release + "\n");
        if (classdef != null) {
            code.remove(classdef);
            code.insert(position, classdef + "\n");
        }
        code.str = code.str + tagCmd;
        PogoUtil.writeFile(filename, code.str);
    }

    private void addObjectToMakefile(String filename) throws FileNotFoundException, SecurityException, IOException {
        if (this.pogo.is_abstractclass) {
            return;
        }
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        String new_obj = "$(CLASS)StateMachine.o";
        if (code.str.indexOf(new_obj) > 0) {
            return;
        }
        int position = code.str.indexOf("$(CLASS).o");
        int start = code.str.lastIndexOf("\n", position);
        new_obj = new_obj + " \\" + code.str.substring(start, position);
        code.insert(position, new_obj);
        PogoUtil.writeFile(filename, code.str);
    }

    private void updateNamespaceInClFac(String filename) throws FileNotFoundException, SecurityException, IOException {
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        String old_ns = this.pogo.class_name + "::" + this.pogo.class_name + "Class::init";
        String new_ns = this.pogo.namespace() + "::" + this.pogo.class_name + "Class::init";
        if (code.str.indexOf(old_ns) > 0) {
            code.replace(old_ns, new_ns);
            PogoUtil.writeFile(filename, code.str);
        }
    }

    private void BuildWinDspFile(String template, String filename) {
        try {
            int idx;
            String code = PogoUtil.readFile(template);
            while ((idx = code.indexOf("TemplateDevServ")) > 0) {
                code = code.substring(0, idx) + this.pogo.class_name + code.substring(idx + "TemplateDevServ".length());
            }
            if (this.pogo.inherited_from != null) {
                String s = "/I \".\"";
                idx = code.indexOf(s);
                code = code.substring(0, idx) + " /I \"" + this.pogo.inheritedClassPath() + "\" " + code.substring(idx);
            }
            if (PogoUtil.osIsUnix()) {
                code = PogoUtil.setWindowsFileFormat(code);
            }
            PogoUtil.writeFile(filename, code);
            this.strTrace = this.strTrace + filename + "     Generated\n";
        }
        catch (Exception e) {
            this.strTrace = this.strTrace + "!!!    " + filename + "  CANNOT be Created !!!\n       " + e + "\n";
        }
    }

    private void updateNamespace(String filename) throws FileNotFoundException, SecurityException, IOException {
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        String old_ns = "namespace " + this.pogo.class_name + "\n{\n";
        String new_ns = "namespace " + this.pogo.namespace() + "\n{\n";
        boolean modified = false;
        if (code.str.indexOf(old_ns) > 0) {
            code.replace(old_ns, new_ns);
            modified = true;
        }
        old_ns = "namespace " + this.pogo.class_name + " {\n";
        new_ns = "namespace " + this.pogo.namespace() + " {\n";
        if (code.str.indexOf(old_ns) > 0) {
            code.replace(old_ns, new_ns);
            modified = true;
        }
        if (modified) {
            PogoUtil.writeFile(filename, code.str);
        }
    }

    public void generate(int item) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String makefile = this.pogo.projectFiles.getPath() + "/Makefile";
        String WinDsp = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".dsp";
        String main = this.pogo.projectFiles.getPath() + "/main.cpp";
        String cfactory = this.pogo.projectFiles.getPath() + "/ClassFactory.cpp";
        String server = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".cpp";
        String server_h = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".h";
        String serverclass = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "Class.cpp";
        String serverclass_h = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "Class.h";
        String allowedfile = this.pogo.projectFiles.getAllowed();
        String vc8_templ_dir = this.pogo.templates_dir + "/cpp/vc8_project/";
        this.strTrace = "C++ source code generation:\n\n";
        if (!this.pogo.is_abstractclass) {
            if (!(PogoUtil.osIsUnix() && item != 3 || !PogoGeneCpp.mustGenerate(WinDsp) && item != 3)) {
                if (PogoGeneCpp.already_exists(vc8_templ_dir)) {
                    this.buildVc8ProjectFiles(vc8_templ_dir, item);
                } else if (PogoGeneCpp.mustGenerate(WinDsp) || item == 3) {
                    this.BuildWinDspFile(this.pogo.templates_dir + "/cpp/DevServ.dsp", WinDsp);
                }
            }
            if (PogoUtil.osIsUnix() || item == 2) {
                if (item == 2 || PogoGeneCpp.mustGenerate(makefile)) {
                    System.out.println("Generating " + makefile + " for C++....");
                    this.replacePatternFile(this.pogo.templates_dir + "/cpp/Makefile", makefile, "TemplateDevServ", this.pogo.class_name);
                    this.strTrace = this.strTrace + makefile + " for C++     generated\n";
                } else {
                    this.addObjectToMakefile(makefile);
                    this.patchCvsTagToMakefile(makefile);
                }
            }
            if (this.pogo.inherited_from != null && !this.pogo.inherited_from.equals("Device_4Impl")) {
                if (!PogoUtil.osIsUnix()) {
                    if (!PogoGeneCpp.already_exists(vc8_templ_dir)) {
                        this.insertAbstractClassPath(WinDsp);
                    }
                } else {
                    this.insertAbstractClassPath(makefile);
                }
            }
        }
        if (item == 2 || item == 3) {
            return;
        }
        if (!this.pogo.is_abstractclass && PogoGeneCpp.mustGenerate(main)) {
            System.out.println("Generating " + main + "....");
            PogoGeneCpp.copyFile(this.pogo.templates_dir + "/cpp/main.cpp", main);
            this.strTrace = this.strTrace + main + "     Created\n";
        }
        if (!this.pogo.is_abstractclass && PogoGeneCpp.mustGenerate(cfactory)) {
            System.out.println("Generating " + cfactory + "....");
            this.replacePatternFile(this.pogo.templates_dir + "/cpp/ClassFactory.cpp", cfactory, "TemplateDevServ", this.pogo.class_name);
            this.strTrace = this.strTrace + cfactory + "      Created\n";
        }
        CppServerClass sc = new CppServerClass(this.pogo);
        sc.generateHeader(serverclass_h);
        this.strTrace = this.strTrace + serverclass_h + "      Generated\n";
        sc.generateSource(serverclass);
        this.strTrace = this.strTrace + serverclass + "      Generated\n";
        CppServer serv = new CppServer(this.pogo);
        serv.generateHeader(server_h);
        this.strTrace = this.strTrace + server_h + "      Generated\n";
        if (!this.pogo.is_abstractclass) {
            serv.generateSource(server);
            this.strTrace = this.strTrace + server + "       Generated\n";
        }
        CppStateMachine allowed = new CppStateMachine(this.pogo);
        allowed.generateSource(this.pogo.templates_dir + "/cpp/MachineState.cpp", allowedfile);
        this.strTrace = this.strTrace + allowedfile + "       Generated\n";
        this.updateNamespace(serverclass_h);
        this.updateNamespace(serverclass);
        this.updateNamespace(server_h);
        if (!this.pogo.is_abstractclass) {
            this.updateNamespace(server);
            this.updateNamespace(allowedfile);
            this.updateNamespaceInClFac(cfactory);
        }
    }

    private void changeClassName(String old_file, String new_file, String old_name, String new_name) throws FileNotFoundException, SecurityException, IOException {
        this.replacePatternFile(old_file, new_file, old_name, new_name);
        if (!new_file.equals(old_file)) {
            new File(old_file).delete();
        }
    }

    public void changeClassName() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String old_classname = this.pogo.projectFiles.getOriginalClassName();
        String makefile = this.pogo.projectFiles.getPath() + "/Makefile";
        String main = this.pogo.projectFiles.getPath() + "/main.cpp";
        String cfactory = this.pogo.projectFiles.getPath() + "/ClassFactory.cpp";
        String server = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".cpp";
        String server_h = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".h";
        String serverclass = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "Class.cpp";
        String serverclass_h = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "Class.h";
        String state_machine = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "StateMachine.cpp";
        String old_server = this.pogo.projectFiles.getPath() + "/" + old_classname + ".cpp";
        String old_server_h = this.pogo.projectFiles.getPath() + "/" + old_classname + ".h";
        String old_serverclass = this.pogo.projectFiles.getPath() + "/" + old_classname + "Class.cpp";
        String old_serverclass_h = this.pogo.projectFiles.getPath() + "/" + old_classname + "Class.h";
        String old_state_machine = this.pogo.projectFiles.getPath() + "/" + old_classname + "StateMachine.cpp";
        if (PogoGeneCpp.already_exists(makefile)) {
            this.replacePatternFile(makefile, makefile, old_classname, this.pogo.class_name);
        }
        if (PogoGeneCpp.already_exists(main)) {
            this.replacePatternFile(main, main, old_classname, this.pogo.class_name);
        }
        if (PogoGeneCpp.already_exists(cfactory)) {
            this.replacePatternFile(cfactory, cfactory, old_classname, this.pogo.class_name);
        }
        if (PogoGeneCpp.already_exists(old_server)) {
            this.changeClassName(old_server, server, old_classname, this.pogo.class_name);
        }
        if (PogoGeneCpp.already_exists(old_server_h)) {
            this.changeClassName(old_server_h, server_h, old_classname, this.pogo.class_name);
            this.changeClassName(server_h, server_h, old_classname.toUpperCase(), this.pogo.class_name.toUpperCase());
        }
        if (PogoGeneCpp.already_exists(old_serverclass)) {
            this.changeClassName(old_serverclass, serverclass, old_classname, this.pogo.class_name);
        }
        if (PogoGeneCpp.already_exists(old_serverclass_h)) {
            this.changeClassName(old_serverclass_h, serverclass_h, old_classname, this.pogo.class_name);
            this.changeClassName(serverclass_h, serverclass_h, old_classname.toUpperCase(), this.pogo.class_name.toUpperCase());
        }
        if (PogoGeneCpp.already_exists(old_state_machine)) {
            this.changeClassName(old_state_machine, state_machine, old_classname, this.pogo.class_name);
        }
        this.pogo.projectFiles.updateOriginalFields();
    }

    public static boolean makefileExists(PogoClass server) {
        return PogoGeneCpp.already_exists(server.projectFiles.getPath() + "/Makefile");
    }

    public static boolean windowsProjectExists(PogoClass server) {
        return PogoGeneCpp.already_exists(server.projectFiles.getPath() + "/" + vc_proj_dir);
    }
}

