/*
 * Decompiled with CFR 0.152.
 */
package pogo.class2www;

import pogo.class2www.Class2www;
import pogo.class2www.Family;
import pogo.class2www.InstituteList;
import pogo.class2www.Repository;
import pogo.class2www.Utils;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoUtil;

public class Module {
    public String name;
    public String cvs_path;
    public String html_path;
    public PogoClass server;
    public Family family;
    public Repository repository;
    public int repos_type = 0;
    public boolean doc_done = false;
    public String tag = "";

    public Module(String name, String cvs_path, Repository repository, Family family, int repos_type) {
        this.name = name;
        this.cvs_path = cvs_path;
        this.repository = repository;
        this.family = family;
        this.repos_type = repos_type;
    }

    public void setHtmlPath(String path) {
        this.html_path = path;
    }

    public String getSummary() {
        String institute;
        String author;
        InstituteList.Institute in;
        String hosted_url;
        String description = this.server.class_desc;
        if (description == null || description.length() == 0) {
            description = "Tango Device Class";
        }
        String doc_url = "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/" + this.html_path + "/" + "index.html";
        if (this.repository.remote) {
            hosted_url = this.repository.url + this.cvs_path;
            if (this.repos_type == 1) {
                hosted_url = PogoUtil.strReplace(hosted_url, "cvs", "svn");
            }
        } else {
            hosted_url = doc_url;
        }
        if ((in = Class2www.instituteList.getInstituteByAuthor(author = this.server.author == null ? "........" : this.server.author)) == null) {
            institute = "??";
        } else {
            institute = in.name;
            if (in.address != null) {
                institute = institute + ":  <a href=mailto:" + in.address + "?subject=" + this.server.class_name + "> " + in.address + "</a>";
            }
        }
        String revision = this.server.revision;
        if (revision == null) {
            revision = "";
        }
        String str = "<Br /><Br /><A Name=\"$CLASS_NAME\" /><HR WIDTH=\"100%\" />\n<Table>\n\t<Tr><Td>Class:   </Td> <Td> <b> $CLASS_NAME  </b></Td></Tr>\n\t<Tr><Td>Module:  </Td> <Td> <b><a href=\"$HOSTED_URL\"> $MODULE_NAME </a></b></Td></Tr>\n\t<Tr><Td>Family:  </Td> <Td> <b> $FAMILY      </b></Td></Tr>\n\t<Tr><Td>Author:  </Td> <Td> <b> $AUTHOR   ($INSTITUTE)</b></Td> </Tr>\n\t<Tr><Td>Revision:</Td> <Td> <b> $REVISION    </b></Td> </Tr>\n\t<Tr><Td>Language:</Td> <Td> <b> $LANGUAGE    </b></Td></Tr>\n\t<Tr><Td>Hosted:  </Td> <Td> <b> $REPOSITORY ($REPOS_TYPE)</b> repository</Td></Tr>\n\t<Tr><Td>Doc.:   </Td> <Td> <b> <a HREF=\"$WEB_URL\">$WEB_URL </a </b></Td></Tr>\n</Table>\n<Br><b>Description:</b>\n<ul>\n\t$DESCRIPTION\n</ul>\n";
        str = PogoUtil.strReplace(str, "$CLASS_NAME", this.server.class_name);
        str = PogoUtil.strReplace(str, "$MODULE_NAME", this.name);
        str = PogoUtil.strReplace(str, "$AUTHOR", author);
        str = PogoUtil.strReplace(str, "$INSTITUTE", institute);
        str = PogoUtil.strReplace(str, "$REVISION", revision);
        str = PogoUtil.strReplace(str, "$HOSTED_URL", hosted_url);
        str = PogoUtil.strReplace(str, "$FAMILY", this.family.name);
        str = PogoUtil.strReplace(str, "$LANGUAGE", PogoDefs.languageStr[this.server.language]);
        str = PogoUtil.strReplace(str, "$REPOSITORY", this.repository.name);
        str = PogoUtil.strReplace(str, "$REPOS_TYPE", Repository.RepositoryTypeStr[this.repos_type].toLowerCase());
        str = PogoUtil.strReplace(str, "$DESCRIPTION", description);
        str = PogoUtil.strReplace(str, "$WEB_URL", doc_url);
        if (this.repository.remote) {
            StringBuffer sb = new StringBuffer("<Br><b>Check out command:</b>\n<ul>\t");
            if (this.repos_type == 0) {
                sb.append("cvs  -d:pserver:anonymous@").append(this.repository.name).append(".cvs.sourceforge.net:/cvsroot/").append(this.repository.name).append(" co &nbsp&nbsp ");
                if (this.server.revision != null && this.server.revision.length() > 0) {
                    sb.append("  -r ").append(this.server.revision).append(" &nbsp&nbsp ");
                }
                sb.append(this.name);
                sb.append("\n</ul>\n");
                str = str + sb.toString();
            }
        }
        return str;
    }

    public String getTableLine() {
        String description;
        String hosted_url;
        if (this.server == null) {
            System.err.println(this.name + "  server field is null !!!!");
            return "";
        }
        if (this.repository.name.toLowerCase().indexOf("esrf") < 0) {
            hosted_url = this.repository.url + this.cvs_path + "/";
            if (this.repos_type == 1) {
                hosted_url = PogoUtil.strReplace(hosted_url, "cvs", "svn");
            }
        } else {
            hosted_url = this.name + "/" + "index.html";
        }
        if ((description = Utils.removeHtmlTag(this.server.class_desc)) == null || description.length() == 0) {
            description = "Tango Device Class";
        } else if (description.length() > 180) {
            description = description.substring(0, 180) + "...";
        }
        String str_repos_type = Repository.RepositoryTypeStr[this.repos_type];
        String alpha_home = this.repository.remote ? "../.." : "..";
        String str = "<Tr><Td><b><Font size=-1 COLOR=\"#0000FF\"> <a href=\"$HOSTED_URL\" target=new> $CLASS_NAME </a> </b></Font></Td>\n<Td><Center><Font size=-2 COLOR=\"#0000FF\"><b> $LANGUAGE </b></Font></Center></Td>\n<Td><Center><Font size=-2 COLOR=\"#0000FF\"><b> $REPOS_TYPE </b></Font></Center></Td>\n<Td><b><Font size=-1><a href=$REPOS_HOME/Alphabetical.html#$CLASS_NAME> $DESCRIPTION </a></Font></b></Td></Tr> \n";
        str = PogoUtil.strReplace(str, "$LANGUAGE", PogoDefs.languageStr[this.server.language]);
        str = PogoUtil.strReplace(str, "$REPOS_TYPE", str_repos_type);
        str = PogoUtil.strReplace(str, "$REPOS_HOME", alpha_home);
        str = PogoUtil.strReplace(str, "$CLASS_NAME", this.server.class_name);
        str = PogoUtil.strReplace(str, "$DESCRIPTION", description);
        str = PogoUtil.strReplace(str, "$DOC_URL", this.name + "/" + "index.html");
        str = PogoUtil.strReplace(str, "$HOSTED_URL", hosted_url);
        return str;
    }

    public String toString() {
        return this.name;
    }
}

