/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.appli.PogoTree;
import pogo.gene.Cmd;
import pogo.gene.PogoDefs;
import pogo.gene.PogoUtil;

public class TreePopupMenu
extends JPopupMenu
implements PogoDefs,
PogoAppliDefs {
    private PogoAppli appli;
    private PogoTree parent;
    private boolean osIsUnix;
    private static String[] pMenuLabels = new String[]{"Edit Item", "Edit code", "Clone", "Delete", "Move Up", "Move Down", "Create new ", "Sort items", "Edit State Machine", "Edit descriptions", "Edit Class", "Edit Abstract Class", "Class summary"};
    private static final int OFFSET = 2;
    private static final int EDIT_ITEM = 0;
    private static final int EDIT_CODE = 1;
    private static final int CLONE_OBJ = 2;
    private static final int DELETE_ITEM = 3;
    private static final int MOVE_UP = 4;
    private static final int MOVE_DOWN = 5;
    private static final int NEW_ITEM = 6;
    private static final int SORT_ITEMS = 7;
    private static final int EDIT_ST_MACH = 8;
    private static final int EDIT_DESC = 9;
    private static final int EDIT_CLASS = 10;
    private static final int EDIT_ABSTRACT = 11;
    private static final int CLASS_SUMMARY = 12;

    public TreePopupMenu(PogoAppli appli, PogoTree parent) {
        this.appli = appli;
        this.parent = parent;
        this.osIsUnix = PogoUtil.osIsUnix();
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        JLabel title = new JLabel("Edit Menu :");
        title.setFont(new Font("Dialog", 1, 16));
        this.add(title);
        this.add(new JPopupMenu.Separator());
        for (int i = 0; i < pMenuLabels.length; ++i) {
            JMenuItem btn = new JMenuItem(pMenuLabels[i]);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TreePopupMenu.this.itemActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    public void showMenu(MouseEvent evt) {
        DefaultMutableTreeNode node = this.parent.getSelectedNode();
        if (node == null) {
            return;
        }
        for (int i = 0; i < pMenuLabels.length; ++i) {
            ((JMenuItem)this.getComponent(2 + i)).setVisible(true);
            ((JMenuItem)this.getComponent(2 + i)).setEnabled(true);
        }
        Object obj = node.getUserObject();
        JMenuItem new_item = (JMenuItem)this.getComponent(8);
        JMenuItem sort_items = (JMenuItem)this.getComponent(9);
        JMenuItem edit_desc = (JMenuItem)this.getComponent(11);
        JMenuItem clone_item = (JMenuItem)this.getComponent(4);
        clone_item.setText("Clone");
        this.getComponent(12).setVisible(false);
        this.getComponent(13).setVisible(false);
        this.getComponent(14).setVisible(false);
        switch (PogoUtil.instanceOf(obj)) {
            case -1: {
                for (int i = 0; i < pMenuLabels.length; ++i) {
                    this.getComponent(2 + i).setVisible(false);
                }
                this.getComponent(12).setVisible(true);
                this.getComponent(14).setVisible(true);
                if (this.parent.server.inheritedClassName().equals("Device_4Impl")) break;
                this.getComponent(13).setVisible(true);
                break;
            }
            case 2: {
                Cmd cmd = (Cmd)obj;
                boolean enabled = !cmd.virtual_method;
                this.getComponent(4).setEnabled(enabled);
                this.getComponent(5).setEnabled(enabled);
                this.getComponent(6).setEnabled(enabled);
                this.getComponent(7).setEnabled(enabled);
                enabled = enabled || cmd.override_method == 0;
                this.getComponent(2).setEnabled(enabled);
                enabled = enabled || cmd.override_method == 2;
                this.getComponent(3).setEnabled(enabled && this.osIsUnix);
                new_item.setVisible(false);
                sort_items.setVisible(false);
                edit_desc.setVisible(false);
                break;
            }
            case 4: {
                boolean edit_state = this.osIsUnix && this.appli.getLanguage() == 1;
                this.getComponent(2).setEnabled(true);
                this.getComponent(3).setEnabled(edit_state);
                this.getComponent(4).setEnabled(true);
                this.getComponent(5).setEnabled(true);
                this.getComponent(6).setEnabled(true);
                this.getComponent(7).setEnabled(true);
                new_item.setVisible(false);
                sort_items.setVisible(false);
                edit_desc.setVisible(false);
                break;
            }
            case 0: 
            case 3: {
                this.getComponent(2).setEnabled(true);
                this.getComponent(3).setEnabled(this.osIsUnix);
                this.getComponent(4).setEnabled(true);
                this.getComponent(5).setEnabled(true);
                this.getComponent(6).setEnabled(true);
                this.getComponent(7).setEnabled(true);
                new_item.setVisible(false);
                sort_items.setVisible(false);
                edit_desc.setVisible(false);
                if (node.getParent().toString().indexOf("Class") >= 0) {
                    clone_item.setText("Clone as Device Property");
                    break;
                }
                if (node.getParent().toString().indexOf("Device") < 0) break;
                clone_item.setText("Clone as Class Property");
                break;
            }
            case 5: {
                if (node.getParent().getChildCount() > 2) {
                    sort_items.setVisible(true);
                } else {
                    sort_items.setVisible(false);
                }
                new_item.setVisible(true);
                new_item.setText(pMenuLabels[6] + obj.toString());
                edit_desc.setVisible(true);
                this.getComponent(2).setEnabled(false);
                this.getComponent(3).setEnabled(false);
                this.getComponent(4).setEnabled(false);
                this.getComponent(5).setEnabled(false);
                this.getComponent(6).setEnabled(false);
                this.getComponent(7).setEnabled(false);
            }
        }
        this.show(this.parent, evt.getX(), evt.getY());
    }

    private void itemActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = this.parent.getSelectedNode();
        Object obj = evt.getSource();
        int cmdidx = 0;
        for (int i = 0; i < pMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != obj) continue;
            cmdidx = i;
        }
        switch (cmdidx) {
            case 0: {
                this.parent.editItem();
                break;
            }
            case 1: {
                this.parent.editCode();
                break;
            }
            case 2: {
                this.parent.cloneLeaf(node);
                break;
            }
            case 3: {
                this.parent.removeSelectedLeaf();
                break;
            }
            case 4: {
                this.parent.moveSelection("Up");
                break;
            }
            case 5: {
                this.parent.moveSelection("Down");
                break;
            }
            case 6: {
                this.parent.createItem();
                break;
            }
            case 7: {
                this.parent.sortItems(node);
                break;
            }
            case 8: {
                this.parent.editStateMachine(node);
                break;
            }
            case 9: {
                this.parent.editDescriptions(node);
                break;
            }
            case 10: {
                this.parent.editClassObject();
                break;
            }
            case 11: {
                this.parent.editAbstractClass();
                break;
            }
            case 12: {
                this.parent.showClassSummary();
            }
        }
    }
}

