/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import app_util.PopupError;
import app_util.PopupMessage;
import fr.esrf.Tango.DispLevel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pogo.appli.AttributeDialog;
import pogo.appli.ClassDialog;
import pogo.appli.CommandDialog;
import pogo.appli.CommentsDialog;
import pogo.appli.EditPogoCode;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.appli.PropertyDialog;
import pogo.appli.StateDialog;
import pogo.appli.StateMachineDialog;
import pogo.appli.TreePopupMenu;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.DevState;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.Property;
import pogo.gene.ServerDefinitions;

public class PogoTree
extends JTree
implements PogoAppliDefs,
PogoDefs {
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode[] collection;
    private PogoAppli parent;
    private DefaultTreeModel treeModel;
    PogoClass server;
    private boolean modified;
    private TreePopupMenu pMenu;
    private boolean creating = false;
    private static final String[] collectionNames = new String[]{"Class  Properties", "Device Properties", "Commands", "Scalar Attributes", "Spectrum Attributes", "Image  Attributes", "States"};
    private static final int COLLEC_CLASS_PROPERTIES = 0;
    private static final int COLLEC_DEV_PROPERTIES = 1;
    private static final int COLLEC_COMMANDS = 2;
    private static final int COLLEC_SCALAR_ATTRIBUTES = 3;
    private static final int COLLEC_SPECTR_ATTRIBUTES = 4;
    private static final int COLLEC_IMAGE_ATTRIBUTES = 5;
    private static final int COLLEC_STATES = 6;
    private static final String remove_message = "The ITEM NAME has been taken off the ITEM factory.\n\nBut, for safety reason, if code for this ITEM has been already generated,\nthe 'METHOD' method will not be automaticaly removed !!!\nPlease do it by yourself.";

    public PogoTree(PogoAppli parent) {
        this.parent = parent;
        Color background = new Color(255, 255, 204);
        this.setBackground(background);
        this.root = new DefaultMutableTreeNode("Tango Device Server");
        this.collection = new DefaultMutableTreeNode[collectionNames.length];
        for (int i = 0; i < collectionNames.length; ++i) {
            this.collection[i] = new DefaultMutableTreeNode(collectionNames[i]);
            this.root.add(this.collection[i]);
        }
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new PogoRenderer(background));
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                PogoTree.this.collapsedPerfomed(e);
            }

            public void treeExpanded(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PogoTree.this.treeMouseClicked(evt);
            }
        });
        this.pMenu = new TreePopupMenu(parent, this);
    }

    public void clear() {
        for (int i = 0; i < this.collection.length; ++i) {
            int nb = this.collection[i].getChildCount();
            for (int j = 0; j < nb; ++j) {
                this.removeLeaf((DefaultMutableTreeNode)this.collection[i].getChildAt(0));
            }
            this.collection[i].removeAllChildren();
        }
        this.root.setUserObject("");
        this.modified = false;
    }

    public void setPogoClass(PogoClass server, boolean expand) {
        Property prop;
        int i;
        this.creating = true;
        this.server = server;
        this.clear();
        this.root.setUserObject(new ServerDefinitions(server.class_name, server.inherited_from, server.class_desc, server.title));
        int nb_rows = collectionNames.length;
        if (server.class_properties != null) {
            i = 0;
            while (i < server.class_properties.size()) {
                prop = server.class_properties.propertyAt(i);
                this.createLeaf(this.collection[0], prop);
                ++i;
                ++nb_rows;
            }
        }
        if (server.dev_properties != null) {
            i = 0;
            while (i < server.dev_properties.size()) {
                prop = server.dev_properties.propertyAt(i);
                this.createLeaf(this.collection[1], prop);
                ++i;
                ++nb_rows;
            }
        }
        if (server.commands != null) {
            i = 0;
            while (i < server.commands.size()) {
                Cmd cmd = server.commands.cmdAt(i);
                this.createLeaf(this.collection[2], cmd);
                ++i;
                ++nb_rows;
            }
        }
        if (server.attributes != null) {
            i = 0;
            while (i < server.attributes.size()) {
                Attrib attr = server.attributes.attributeAt(i);
                this.createLeaf(this.getAttributeCollectionNode(attr), attr);
                ++i;
                ++nb_rows;
            }
        }
        if (server.states != null) {
            i = 0;
            while (i < server.states.size()) {
                DevState state = server.states.stateAt(i);
                this.createLeaf(this.collection[6], state);
                ++i;
                ++nb_rows;
            }
        }
        if (expand) {
            for (i = 0; i < nb_rows; ++i) {
                this.expandRow(i);
            }
        }
        this.updateInheritanceTree();
        this.modified = false;
        this.creating = false;
    }

    void setSelectionNode(DefaultMutableTreeNode node) {
        Object[] path = node.getPath();
        this.setSelectionPath(new TreePath(path));
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    boolean isLeafSelected() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node != null) {
            TreeNode[] path = node.getPath();
            return path.length == 3;
        }
        return this.getSelectedNode() != null;
    }

    void removeLeaf(DefaultMutableTreeNode node) {
        this.treeModel.removeNodeFromParent(node);
        this.modified = true;
    }

    private DefaultMutableTreeNode getAttributeCollectionNode(Attrib attr) {
        if (attr.attrType == 2) {
            return this.collection[5];
        }
        if (attr.attrType == 1) {
            return this.collection[4];
        }
        return this.collection[3];
    }

    private void changeLeaf(DefaultMutableTreeNode node, Object obj) {
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        if (PogoUtil.instanceOf(obj) == 3) {
            parent_node = this.getAttributeCollectionNode((Attrib)obj);
        }
        int pos = 0;
        for (int i = 0; i < parent_node.getChildCount(); ++i) {
            if (!parent_node.getChildAt(i).equals(node)) continue;
            pos = i;
        }
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(obj);
        this.treeModel.insertNodeInto(new_node, parent_node, pos);
        this.removeLeaf(node);
        this.setSelectionNode(new_node);
    }

    private void createLeaf(DefaultMutableTreeNode parent_node, Object obj) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(obj);
        if (PogoUtil.instanceOf(obj) == 3) {
            parent_node = this.getAttributeCollectionNode((Attrib)obj);
        }
        this.treeModel.insertNodeInto(node, parent_node, parent_node.getChildCount());
        if (!this.creating) {
            this.setSelectionNode(node);
        }
    }

    void cloneLeaf(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        DefaultMutableTreeNode new_node = null;
        if (parent_node == this.collection[0]) {
            new_node = new DefaultMutableTreeNode(node.getUserObject());
            parent_node = this.collection[1];
        } else if (parent_node == this.collection[1]) {
            new_node = new DefaultMutableTreeNode(node.getUserObject());
            parent_node = this.collection[0];
        } else {
            this.createItem(node);
        }
        if (new_node != null) {
            Property prop = (Property)node.getUserObject();
            for (int i = 0; i < parent_node.getChildCount(); ++i) {
                if (!parent_node.getChildAt(i).toString().equals(prop.name)) continue;
                PopupError.show((Component)this.parent, prop.name + " Already Exists !");
                return;
            }
            this.treeModel.insertNodeInto(new_node, parent_node, parent_node.getChildCount());
            Object[] path = new_node.getPath();
            this.setSelectionPath(new TreePath(path));
            this.modified = true;
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        int mask = evt.getModifiers();
        if ((mask & 8) != 0) {
            return;
        }
        int selRow = this.getRowForLocation(evt.getX(), evt.getY());
        TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
        if (path == null) {
            return;
        }
        this.setSelectionPath(path);
        if (evt.getClickCount() != 2) {
            if ((mask & 4) != 0) {
                switch (path.getPathCount() - 1) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.pMenu.showMenu(evt);
                    }
                }
            }
            return;
        }
        if (selRow == -1) {
            return;
        }
        if ((mask & 0x10) != 0) {
            evt.consume();
            switch (path.getPathCount() - 1) {
                case 0: {
                    this.editClassObject();
                    break;
                }
                case 1: {
                    this.createItem();
                    break;
                }
                case 2: {
                    this.editItem();
                }
            }
        }
    }

    private void updateInheritanceTree() {
        this.parent.inheritanceTree.updateInheritance(this.server);
        this.parent.inheritanceTree.setVisible(true);
        if (this.parent.isInheritanceVisible()) {
            this.parent.setInheritanceVisible(true);
        }
        this.parent.pack();
    }

    public void editClassObject() {
        ServerDefinitions sd = (ServerDefinitions)this.root.getUserObject();
        ClassDialog dialog = new ClassDialog(this.parent, sd);
        if (dialog.showDialog() == 1) {
            sd = dialog.getInput();
            this.root.setUserObject(sd);
            this.updateInheritanceTree();
            this.modified = true;
        }
    }

    void createItem(DefaultMutableTreeNode node) {
        Object obj = node.getUserObject();
        switch (PogoUtil.instanceOf(obj)) {
            case 2: {
                CommandDialog dialog = new CommandDialog(this.parent, this.server, (Cmd)obj, 0);
                if (dialog.showDialog() != 1) break;
                Cmd newCmd = dialog.getInput();
                this.server.commands.add(newCmd);
                newCmd.cmd_class = newCmd.name + "Cmd";
                this.createLeaf((DefaultMutableTreeNode)node.getParent(), newCmd);
                this.modified = true;
                break;
            }
            case 3: {
                AttributeDialog att_dialog = new AttributeDialog(this.parent, this.server, (Attrib)obj, 0);
                if (att_dialog.showDialog() != 1) break;
                Attrib new_attr = att_dialog.getInput();
                this.server.attributes.add(new_attr);
                this.createLeaf((DefaultMutableTreeNode)node.getParent(), new_attr);
                this.modified = true;
                break;
            }
            case 0: {
                StateDialog st_dialog = new StateDialog(this.parent, this.server, (DevState)obj, 0);
                if (st_dialog.showDialog() != 1) break;
                DevState state = st_dialog.getInput();
                this.server.states.add(state);
                this.createLeaf((DefaultMutableTreeNode)node.getParent(), state);
                this.modified = true;
            }
        }
    }

    void createItem() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        int item = 0;
        for (int i = 0; i < this.collection.length; ++i) {
            if (!this.collection[i].equals(node)) continue;
            item = i;
        }
        this.server = this.getPogoClass();
        switch (item) {
            case 2: {
                CommandDialog dialog = new CommandDialog(this.parent, this.server, null, 0);
                if (dialog.showDialog() != 1) break;
                Cmd newCmd = dialog.getInput();
                newCmd.cmd_class = newCmd.name + "Class";
                this.server.commands.add(newCmd);
                this.createLeaf(node, newCmd);
                this.modified = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                AttributeDialog att_dialog = new AttributeDialog(this.parent, this.server, null, 0);
                att_dialog.setType(item - 3);
                if (att_dialog.showDialog() != 1) break;
                Attrib newAtt = att_dialog.getInput();
                this.server.attributes.add(newAtt);
                this.createLeaf(node, newAtt);
                this.modified = true;
                break;
            }
            case 6: {
                StateDialog st_dialog = new StateDialog(this.parent, this.server, null, 0);
                if (st_dialog.showDialog() != 1) break;
                DevState state = st_dialog.getInput();
                this.server.states.add(state);
                this.createLeaf(node, state);
                this.modified = true;
                break;
            }
            case 0: 
            case 1: {
                PropertyDialog prop_dialog = new PropertyDialog(this.parent, null, this.collection[item].toString());
                if (prop_dialog.showDialog() != 1) break;
                this.createLeaf(node, prop_dialog.getInput());
                this.modified = true;
            }
        }
    }

    void editItem() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        this.server = this.getPogoClass();
        switch (PogoUtil.instanceOf(obj)) {
            case 2: {
                this.editCommand(node);
                break;
            }
            case 3: {
                Attrib newAttr;
                Attrib attr = (Attrib)obj;
                AttributeDialog att_dialog = new AttributeDialog(this.parent, this.server, attr, 1);
                if (att_dialog.showDialog() != 1 || attr.equals(newAttr = att_dialog.getInput())) break;
                this.changeLeaf(node, newAttr);
                this.modified = true;
                break;
            }
            case 4: {
                DevState newState;
                DevState state = (DevState)obj;
                StateDialog st_dialog = new StateDialog(this.parent, this.server, state, 1);
                if (st_dialog.showDialog() != 1 || state.equals(newState = st_dialog.getInput())) break;
                this.changeLeaf(node, newState);
                this.modified = true;
                break;
            }
            case 0: {
                Property newProp;
                Property property = (Property)obj;
                PropertyDialog prop_dialog = new PropertyDialog(this.parent, property, node.getParent().toString());
                if (prop_dialog.showDialog() != 1 || property.equals(newProp = prop_dialog.getInput())) break;
                this.changeLeaf(node, newProp);
                this.modified = true;
            }
        }
    }

    private void editCommand(DefaultMutableTreeNode node) {
        Cmd cmd = (Cmd)node.getUserObject();
        if (cmd.virtual_method) {
            if (cmd.override_method == 2 || cmd.override_method == 1) {
                JOptionPane.showMessageDialog(this, "This command's method override a method from DeviceImpl class !\nYou cannot change it's signature !", "Info Window", 1);
            } else {
                cmd.override_method = JOptionPane.showConfirmDialog(this, "This command's method is already defined in the DeviceImpl class !\n\nAre you sure to want to override it ?", "Info Window", 0) == 0 ? 1 : 0;
            }
        } else {
            CommandDialog dialog = new CommandDialog(this.parent, this.server, cmd, 1);
            if (dialog.showDialog() == 1) {
                System.out.println(dialog.getInput());
                Cmd newCmd = dialog.getInput();
                if (!cmd.equals(newCmd)) {
                    this.changeLeaf(node, newCmd);
                    this.modified = true;
                }
            }
        }
    }

    void showClassSummary() {
        PogoClass server = this.getPogoClass();
        String summary = "Class:  " + server.class_name + "\n";
        if (!server.inheritedClassName().equals("Device_4Impl")) {
            summary = summary + "Inherited from:  " + server.inheritedClassName() + "\n";
        }
        if (server.author != null && server.author.length() > 0) {
            summary = summary + "Author:  " + server.author + "\n";
        }
        if (server.revision != null && server.revision.length() > 0) {
            summary = summary + "Revision:  " + server.revision + "\n";
        }
        summary = summary + " \n";
        summary = summary + "   - " + server.class_properties.size() + " class properties\n";
        summary = summary + "   - " + server.dev_properties.size() + " device properties\n";
        summary = summary + "   - " + server.commands.size() + " commands\n";
        summary = summary + "   - " + server.attributes.size() + " attributes\n";
        summary = summary + "         - " + server.attributes.getScalarNumber() + " scalar(s)\n";
        summary = summary + "         - " + server.attributes.getSpectrumNumber() + " spectrum(s)\n";
        summary = summary + "         - " + server.attributes.getImageNumber() + " image(s)\n";
        summary = summary + "   - " + server.states.size() + " states\n";
        PopupMessage.show((Component)this.parent, summary);
    }

    public PogoClass getPogoClass() {
        PogoClass new_server = null;
        try {
            ServerDefinitions sd = (ServerDefinitions)this.root.getUserObject();
            new_server = new PogoClass(sd, this.parent.getLanguage(), this.server.projectFiles.getPath());
            this.server.projectFiles.setClassName(sd.name);
            new_server.commands.clear();
            for (int i = 0; i < this.collection.length; ++i) {
                int nb = this.collection[i].getChildCount();
                block9: for (int j = 0; j < nb; ++j) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.collection[i].getChildAt(j);
                    Object obj = node.getUserObject();
                    switch (PogoUtil.instanceOf(obj)) {
                        case 2: {
                            new_server.addCommand((Cmd)obj);
                            continue block9;
                        }
                        case 3: {
                            new_server.addAttribute((Attrib)obj);
                            continue block9;
                        }
                        case 4: {
                            new_server.addState((DevState)obj);
                            continue block9;
                        }
                        case 0: {
                            if (i == 0) {
                                new_server.addClassProperty((Property)obj);
                                continue block9;
                            }
                            new_server.addDevProperty((Property)obj);
                            continue block9;
                        }
                        default: {
                            System.out.println(obj.toString() + "\n Object unknown !");
                            throw new PogoException(obj.toString() + "\n Object unknown !");
                        }
                    }
                }
            }
            new_server.is_abstractclass = this.server.is_abstractclass;
            new_server.revision = this.server.revision;
            new_server.author = this.server.author;
            new_server.cvs_repository = this.server.cvs_repository;
            new_server.projectFiles = this.server.projectFiles;
        }
        catch (PogoException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Error Window", 0);
        }
        return new_server;
    }

    public void collapsedPerfomed(TreeExpansionEvent e) {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        TreePath path = e.getPath();
        DefaultMutableTreeNode c = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
        if (!c.equals(node)) {
            return;
        }
        if (node.getChildCount() > 0) {
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)node.getChildAt(0);
            Object[] leaf_path = leaf.getPath();
            this.setExpandedState(new TreePath(leaf_path), true);
        }
    }

    void editStateMachine(DefaultMutableTreeNode node) {
        if (this.server.states.size() < 2) {
            JOptionPane.showMessageDialog(this, "Create more than one states before !", "Error Window", 0);
            return;
        }
        if (this.server.commands.size() == 0 && this.server.attributes.size() == 0) {
            JOptionPane.showMessageDialog(this, "Create commands or attributes before !", "Error Window", 0);
            return;
        }
        new StateMachineDialog(this.parent, this.server).showDialog();
    }

    void editDescriptions(DefaultMutableTreeNode node) {
        CommentsDialog dlg = null;
        if (node.equals(this.collection[0])) {
            dlg = new CommentsDialog(this.parent, this.server.class_properties, 0);
        } else if (node.equals(this.collection[1])) {
            dlg = new CommentsDialog(this.parent, this.server.dev_properties, 1);
        } else if (node.equals(this.collection[2])) {
            dlg = new CommentsDialog((JFrame)this.parent, this.server.commands);
        } else if (node.equals(this.collection[3]) || node.equals(this.collection[4]) || node.equals(this.collection[5])) {
            dlg = new CommentsDialog((JFrame)this.parent, this.server.attributes);
        } else if (node.equals(this.collection[6])) {
            dlg = new CommentsDialog((JFrame)this.parent, this.server.states);
        }
        if (dlg != null) {
            dlg.setVisible(true);
            this.modified = dlg.getModified();
        }
    }

    void editAbstractClass() {
        new PogoAppli(this.server.inherited_from).setVisible(true);
    }

    void setLanguage(int language) {
        this.server.language = language;
    }

    void setHomeDir(String path) {
        this.server.setProjectPath(path);
    }

    void setOutputModel(boolean is_abstractclass) {
        this.server.is_abstractclass = is_abstractclass;
    }

    void editCode() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        String mess = null;
        EditPogoCode ed = new EditPogoCode(this.getPogoClass());
        try {
            switch (PogoUtil.instanceOf(obj)) {
                case 2: {
                    Cmd cmd = (Cmd)obj;
                    ed.setCommandTarget(cmd.name);
                    break;
                }
                case 3: {
                    Attrib attr = (Attrib)obj;
                    ed.setAttributeTarget(attr.name);
                    break;
                }
                case 0: {
                    TreeNode[] path = node.getPath();
                    if (path[1].toString().equals(collectionNames[0])) {
                        ed.setPropertiesTarget(0);
                        break;
                    }
                    ed.setPropertiesTarget(1);
                    break;
                }
                case 4: {
                    ed.setStateTarget();
                }
            }
            ed.start();
        }
        catch (FileNotFoundException e) {
            mess = ed.getSrcFilename() + "\nSource File Not Found !";
        }
        catch (IOException e) {
            mess = e.toString();
        }
        catch (PogoException e) {
            mess = e.toString();
        }
        if (mess != null) {
            JOptionPane.showMessageDialog(this, mess, "Error Window", 0);
        }
    }

    void sortItems(DefaultMutableTreeNode node) {
        this.server = this.getPogoClass();
        int start_idx = 0;
        if (node.equals(this.collection[2])) {
            start_idx = 2;
        }
        Vector<TreeNode> vector = new Vector<TreeNode>();
        for (int i = start_idx; i < node.getChildCount(); ++i) {
            vector.add(node.getChildAt(i));
        }
        if (vector.size() == 0) {
            return;
        }
        while (node.getChildCount() > start_idx) {
            this.removeLeaf((DefaultMutableTreeNode)node.getChildAt(start_idx));
        }
        MyCompare comp = new MyCompare();
        Collections.sort(vector, comp);
        DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)vector.elementAt(0);
        for (int i = 0; i < vector.size(); ++i) {
            leaf = (DefaultMutableTreeNode)vector.elementAt(i);
            this.treeModel.insertNodeInto(leaf, node, node.getChildCount());
        }
        Object[] path = leaf.getPath();
        this.setExpandedState(new TreePath(path), true);
        this.modified = true;
    }

    public boolean hasBeenModified() {
        return this.modified;
    }

    public void setModified(boolean state) {
        this.modified = state;
    }

    void removeSelectedLeaf() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object[] options = new Object[]{"OK", "CANCEL"};
        if (JOptionPane.showOptionDialog(this.parent, "Click OK to confirm delete " + node + " !", "Warning", -1, 2, null, options, options[0]) != 0) {
            return;
        }
        this.removeLeaf(node);
        PogoString pgs = null;
        switch (PogoUtil.instanceOf(node.getUserObject())) {
            case 2: {
                Cmd cmd = (Cmd)node.getUserObject();
                pgs = new PogoString(remove_message);
                pgs.replace("ITEM", "command");
                pgs.replace("ITEM", "command");
                pgs.replace("ITEM", "command");
                pgs.replace("NAME", cmd.name);
                pgs.replace("METHOD", cmd.exec_method);
                break;
            }
            case 3: {
                Attrib attr = (Attrib)node.getUserObject();
                pgs = new PogoString(remove_message);
                pgs.replace("ITEM", "attribute");
                pgs.replace("ITEM", "attribute");
                pgs.replace("ITEM", "attribute");
                pgs.replace("NAME", attr.name);
                pgs.replace("METHOD", "read_" + attr.name);
            }
        }
        if (pgs != null) {
            JOptionPane.showMessageDialog(this, pgs.str, "Info Window", 1);
        }
    }

    void moveSelection(String direction) {
        DefaultMutableTreeNode node = this.getSelectedNode();
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        int pos = 0;
        for (int i = 0; i < parent_node.getChildCount(); ++i) {
            if (!parent_node.getChildAt(i).equals(node)) continue;
            pos = i;
        }
        int pos_min = 0;
        int pos_max = parent_node.getChildCount() - 1;
        if (parent_node.equals(this.collection[2])) {
            pos_min = 2;
        }
        if (direction.equals("Up")) {
            if (pos > pos_min) {
                this.treeModel.removeNodeFromParent(node);
                this.treeModel.insertNodeInto(node, parent_node, pos - 1);
            }
        } else if (pos < pos_max) {
            this.treeModel.removeNodeFromParent(node);
            this.treeModel.insertNodeInto(node, parent_node, pos + 1);
        }
        this.setSelectionNode(node);
        this.modified = true;
    }

    class MyCompare
    implements Comparator {
        MyCompare() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1.toString().toLowerCase();
            String s2 = o2.toString().toLowerCase();
            return s1.compareTo(s2);
        }
    }

    class PogoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private ImageIcon rootIcon;
        private ImageIcon collecIcon;
        private ImageIcon itemIcon;
        private ImageIcon propIcon;
        private ImageIcon stateIcon;
        private ImageIcon operIcon;
        private ImageIcon expertIcon;
        private String img_path2 = "/app_util/img/";

        public PogoRenderer(Color background) {
            this.setTextSelectionColor(Color.black);
            this.setBorderSelectionColor(Color.red);
            this.setBackgroundSelectionColor(Color.lightGray);
            this.setTextNonSelectionColor(Color.blue);
            this.setBackgroundNonSelectionColor(background);
            this.rootIcon = new ImageIcon(this.getClass().getResource("/pogo/img/tg_class.jpg"));
            this.collecIcon = new ImageIcon(this.getClass().getResource("/pogo/img/arrow.gif"));
            this.itemIcon = new ImageIcon(this.getClass().getResource("/pogo/img/or_diam.gif"));
            this.propIcon = new ImageIcon(this.getClass().getResource(this.img_path2 + "leaf.gif"));
            this.operIcon = new ImageIcon(this.getClass().getResource(this.img_path2 + "event-2.jpg"));
            this.expertIcon = new ImageIcon(this.getClass().getResource(this.img_path2 + "event-3.jpg"));
            this.stateIcon = new ImageIcon(this.getClass().getResource(this.img_path2 + "blueball.gif"));
            this.fonts = new Font[3];
            this.fonts[0] = new Font("helvetica", 1, 22);
            this.fonts[1] = new Font("helvetica", 1, 18);
            this.fonts[2] = new Font("helvetica", 1, 12);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color color;
            Font font;
            ImageIcon icon;
            String tip;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            TreePath tp = tree.getPathForRow(row);
            if (tp == null) {
                return this;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (row == 0) {
                if (PogoTree.this.server == null) {
                    tip = "double double click to edit class (name, description...)";
                } else {
                    tip = "Inherited from :  " + PogoTree.this.server.inheritedClassName() + "\n" + "Revision       :  " + PogoTree.this.server.revision + "\n" + "Author         :  " + PogoTree.this.server.author;
                    if (PogoTree.this.server.cvs_repository != null) {
                        tip = tip + "\nCvs Repository :  " + PogoTree.this.server.cvs_repository;
                    }
                }
                icon = this.rootIcon;
                font = this.fonts[0];
                color = Color.blue;
            } else if (obj instanceof String) {
                tip = "double click to create a new item";
                icon = this.collecIcon;
                font = this.fonts[1];
                color = Color.blue;
            } else {
                Object o = node.getUserObject();
                String collectionName = o.toString();
                switch (PogoUtil.instanceOf(obj)) {
                    case 0: {
                        icon = this.propIcon;
                        break;
                    }
                    case 2: {
                        if (((Cmd)obj).level == DispLevel.OPERATOR) {
                            icon = this.operIcon;
                            break;
                        }
                        icon = this.expertIcon;
                        break;
                    }
                    case 3: {
                        if (((Attrib)obj).disp_level == DispLevel.OPERATOR) {
                            icon = this.operIcon;
                            break;
                        }
                        icon = this.expertIcon;
                        break;
                    }
                    case 4: {
                        icon = this.stateIcon;
                        break;
                    }
                    default: {
                        icon = this.itemIcon;
                    }
                }
                tip = this.buildToolTipText(collectionName, value);
                font = this.fonts[2];
                color = Color.black;
            }
            this.setIcon(icon);
            this.setFont(font);
            this.setForeground(color);
            this.setToolTipText(tip);
            return this;
        }

        private String buildToolTipText(String collname, Object item) {
            String tooltip;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)item;
            Object obj = node.getUserObject();
            if (obj instanceof Cmd) {
                Cmd cmd = (Cmd)obj;
                tooltip = cmd.buildCppExecCmdMethodSignature(PogoTree.this.server.class_name);
            } else if (obj instanceof Attrib) {
                Attrib attr = (Attrib)obj;
                tooltip = attr.dataType.cpp + "  " + attr.toString() + "  (" + PogoDefs.AttrRWtypeArray[attr.rwType];
                if (attr.disp_level == DispLevel.EXPERT) {
                    tooltip = tooltip + "  for Expert Only";
                }
                tooltip = tooltip + ")";
            } else {
                tooltip = "Edit the " + item.toString() + " " + collname;
            }
            return tooltip;
        }
    }
}

