/*
 * Decompiled with CFR 0.152.
 */
package app_util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class TangoWindow
extends JWindow {
    private String title = "  TANGO  Client Application  ";
    private String author = "ESRF  -  Software Engineering Group  ";
    private JLabel authorLabel;
    private JLabel collaborationLabel;
    private JPanel jPanel1;
    private JLabel tangoLabel;
    private JLabel titleLabel;

    private void windowFactory() {
        this.initComponents();
        this.collaborationLabel.setIcon(new ImageIcon(this.getClass().getResource("/app_util/img/collaboration.gif")));
        this.collaborationLabel.setText("");
        this.tangoLabel.setIcon(new ImageIcon(this.getClass().getResource("/app_util/img/tango.jpg")));
        this.titleLabel.setFont(new Font("Dialog", 1, 32));
        this.titleLabel.setText(this.title);
        this.authorLabel.setText(this.author);
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        Dimension appsize = this.getSize();
        Point p = new Point();
        p.x = (scrsize.width - appsize.width) / 2;
        p.y = (scrsize.height - appsize.height) / 2;
        this.setLocation(p);
        this.toFront();
    }

    public TangoWindow() {
        this.windowFactory();
    }

    public TangoWindow(String message) {
        if (this.title != null) {
            this.title = "  " + message + "  ";
        }
        this.windowFactory();
    }

    public TangoWindow(String message, String author) {
        if (this.title != null) {
            this.title = "  " + message + "  ";
        }
        if (author != null) {
            this.author = "  " + author + "  ";
        }
        this.windowFactory();
    }

    private void initComponents() {
        this.tangoLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.collaborationLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.authorLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TangoWindow.this.exitForm(evt);
            }
        });
        this.getContentPane().add((Component)this.tangoLabel, "East");
        JLabel dummy = new JLabel("   ");
        dummy.setFont(new Font("Dialog", 1, 84));
        this.getContentPane().add((Component)dummy, "South");
        this.jPanel1.setLayout(new GridBagLayout());
        this.collaborationLabel.setText("    ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel1.add((Component)this.collaborationLabel, gridBagConstraints);
        this.titleLabel.setForeground(Color.red);
        this.titleLabel.setText("titleLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.titleLabel, gridBagConstraints);
        this.authorLabel.setFont(new Font("Dialog", 1, 12));
        this.authorLabel.setHorizontalAlignment(0);
        this.authorLabel.setText("authorLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.jPanel1.add((Component)this.authorLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        new TangoWindow().setVisible(true);
    }
}

