/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.text.TextPanel;
import ij.util.Java2;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

class TextCanvas
extends Canvas {
    TextPanel tp;
    Font fFont;
    FontMetrics fMetrics;
    Graphics gImage;
    Image iImage;
    boolean antialiased;

    TextCanvas(TextPanel tp) {
        this.tp = tp;
        this.addMouseListener(tp);
        this.addMouseMotionListener(tp);
        this.addKeyListener(tp);
        this.addMouseWheelListener(tp);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.tp.adjustVScroll();
        this.tp.adjustHScroll();
        this.iImage = null;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int y;
        if (this.tp == null || g == null) {
            return;
        }
        Dimension d = this.getSize();
        int iWidth = d.width;
        int iHeight = d.height;
        if (iWidth <= 0 || iHeight <= 0) {
            return;
        }
        g.setColor(Color.lightGray);
        if (this.iImage == null) {
            this.makeImage(iWidth, iHeight);
        }
        if (this.tp.iRowHeight == 0 || this.tp.iColWidth[0] == 0 && this.tp.iRowCount > 0) {
            this.tp.iRowHeight = this.fMetrics.getHeight() + 2;
            for (int i = 0; i < this.tp.iColCount; ++i) {
                this.calcAutoWidth(i);
            }
            this.tp.adjustHScroll();
            this.tp.adjustVScroll();
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, iWidth, iHeight);
        if (this.tp.headings) {
            this.drawColumnLabels(iWidth);
        }
        int j = 0;
        for (y = this.tp.iRowHeight + 1 - this.tp.iY; y < this.tp.iRowHeight + 1; y += this.tp.iRowHeight) {
            ++j;
        }
        this.tp.iFirstRow = j;
        for (y = this.tp.iRowHeight + 1; y < iHeight && j < this.tp.iRowCount; ++j, y += this.tp.iRowHeight) {
            int x = -this.tp.iX;
            for (int i = 0; i < this.tp.iColCount; ++i) {
                int w = this.tp.iColWidth[i];
                Color b2 = Color.white;
                Color t = Color.black;
                if (j >= this.tp.selStart && j <= this.tp.selEnd) {
                    int w2 = w;
                    if (this.tp.iColCount == 1) {
                        w2 = iWidth;
                    }
                    b2 = Color.black;
                    t = Color.white;
                    this.gImage.setColor(b2);
                    this.gImage.fillRect(x, y, w2 - 1, this.tp.iRowHeight);
                }
                this.gImage.setColor(t);
                char[] chars = this.getChars(i, j);
                if (chars != null) {
                    this.gImage.drawChars(chars, 0, chars.length, x + 2, y + this.tp.iRowHeight - 5);
                }
                x += w;
            }
        }
        if (this.iImage != null) {
            g.drawImage(this.iImage, 0, 0, null);
        }
    }

    void makeImage(int iWidth, int iHeight) {
        this.iImage = this.createImage(iWidth, iHeight);
        if (this.gImage != null) {
            this.gImage.dispose();
        }
        this.gImage = this.iImage.getGraphics();
        this.gImage.setFont(this.fFont);
        Java2.setAntialiasedText(this.gImage, this.antialiased);
        if (this.fMetrics == null) {
            this.fMetrics = this.gImage.getFontMetrics();
        }
    }

    void drawColumnLabels(int iWidth) {
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, this.tp.iRowHeight, iWidth, this.tp.iRowHeight);
        int x = -this.tp.iX;
        for (int i = 0; i < this.tp.iColCount; ++i) {
            int w = this.tp.iColWidth[i];
            this.gImage.setColor(Color.lightGray);
            this.gImage.fillRect(x + 1, 0, w, this.tp.iRowHeight);
            this.gImage.setColor(Color.black);
            if (this.tp.sColHead[i] != null) {
                this.gImage.drawString(this.tp.sColHead[i], x + 2, this.tp.iRowHeight - 5);
            }
            if (this.tp.iColCount > 1) {
                this.gImage.setColor(Color.darkGray);
                this.gImage.drawLine(x + w - 1, 0, x + w - 1, this.tp.iRowHeight - 1);
                this.gImage.setColor(Color.white);
                this.gImage.drawLine(x + w, 0, x + w, this.tp.iRowHeight - 1);
            }
            x += w;
        }
        this.gImage.setColor(Color.lightGray);
        this.gImage.fillRect(0, 0, 1, this.tp.iRowHeight);
        this.gImage.fillRect(x + 1, 0, iWidth - x, this.tp.iRowHeight);
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, 0, iWidth, 0);
    }

    char[] getChars(int column, int row) {
        int end;
        if (row >= this.tp.vData.size()) {
            return null;
        }
        char[] chars = (char[])this.tp.vData.elementAt(row);
        if (chars.length == 0) {
            return null;
        }
        if (this.tp.iColCount == 1) {
            return chars;
        }
        int start = 0;
        int tabs = 0;
        int length = chars.length;
        while (column > tabs) {
            if (chars[start] == '\t') {
                ++tabs;
            }
            if (++start < length) continue;
            return null;
        }
        if (start < 0 || start >= chars.length) {
            System.out.println("start=" + start + ", chars.length=" + chars.length);
            return null;
        }
        if (chars[start] == '\t') {
            return null;
        }
        for (end = start; chars[end] != '\t' && end < length - 1; ++end) {
        }
        if (chars[end] == '\t') {
            --end;
        }
        char[] chars2 = new char[end - start + 1];
        int i = 0;
        int j = start;
        while (i < chars2.length) {
            chars2[i] = chars[j];
            ++i;
            ++j;
        }
        return chars2;
    }

    void calcAutoWidth(int column) {
        int maxRows;
        if (this.tp.sColHead == null || column >= this.tp.iColWidth.length) {
            return;
        }
        if (this.fMetrics == null) {
            this.fMetrics = this.gImage.getFontMetrics();
        }
        int w = 15;
        if (this.tp.iColCount == 1) {
            maxRows = 100;
        } else {
            maxRows = 20;
            if (column == 0 && this.tp.sColHead[0].equals(" ")) {
                w += 5;
            } else {
                char[] chars = this.tp.sColHead[column].toCharArray();
                w = Math.max(w, this.fMetrics.charsWidth(chars, 0, chars.length));
            }
        }
        int rowCount = Math.min(this.tp.iRowCount, maxRows);
        for (int row = 0; row < rowCount; ++row) {
            char[] chars = this.getChars(column, row);
            if (chars == null) continue;
            w = Math.max(w, this.fMetrics.charsWidth(chars, 0, chars.length));
        }
        this.tp.iColWidth[column] = w + 15;
    }
}

