/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;
import fr.esrf.tangoatk.core.attribute.NumberAttributeHelper;

class UShortImageHelper
extends ANumberImageHelper {
    public UShortImageHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    protected void insert(double[][] dArray) {
        double d = 1.0;
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        d = this.attribute.getDisplayUnitFactor();
        double[] dArray2 = NumberAttributeHelper.flatten(dArray);
        int[] nArray = new int[dArray2.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)(dArray2[i] / d);
        }
        deviceAttribute.insert_us(nArray, dArray.length, dArray[0].length);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Short((short)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Short((short)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Short((short)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Short((short)d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Short((short)d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Short((short)d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Short((short)d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Short((short)d));
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Short((short)d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Short((short)d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Short((short)d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Short((short)d), bl);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Short((short)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Short((short)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Short((short)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Short((short)d), bl);
    }

    double[][] getNumberImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        int[] nArray = deviceAttribute.extractUShortArray();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = nArray[n3++];
            }
        }
        return this.retval;
    }

    double[][] getNumberImageDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractUShortArray();
        double d = this.attribute.getDisplayUnitFactor();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = (double)nArray[n3++] * d;
            }
        }
        return this.retval;
    }

    String[][] getImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractUShortArray();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        String[][] stringArray = new String[n][n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j] = Integer.toString(nArray[n3++]);
            }
        }
        return stringArray;
    }

    public String getVersion() {
        return "$Id: UShortImageHelper.java,v 1.7 2009/01/26 17:54:52 poncet Exp $";
    }
}

