/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;
import fr.esrf.tangoatk.core.attribute.NumberAttributeHelper;

class ULongImageHelper
extends ANumberImageHelper {
    public ULongImageHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    protected void insert(double[][] dArray) {
        double d = 1.0;
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        d = this.attribute.getDisplayUnitFactor();
        double[] dArray2 = NumberAttributeHelper.flatten(dArray);
        long[] lArray = new long[dArray2.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = (long)(dArray2[i] / d);
        }
        deviceAttribute.insert_ul(lArray, dArray.length, dArray[0].length);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Long((long)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Long((long)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Long((long)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Long((long)d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Long((long)d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Long((long)d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Long((long)d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Long((long)d));
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Long((long)d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Long((long)d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Long((long)d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Long((long)d), bl);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Long((long)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Long((long)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Long((long)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Long((long)d), bl);
    }

    double[][] getNumberImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        long[] lArray = deviceAttribute.extractULongArray();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = lArray[n3++];
            }
        }
        return this.retval;
    }

    double[][] getNumberImageDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        long[] lArray = deviceAttribute.extractULongArray();
        double d = this.attribute.getDisplayUnitFactor();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new double[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = (double)lArray[n3++] * d;
            }
        }
        return this.retval;
    }

    String[][] getImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        long[] lArray = deviceAttribute.extractULongArray();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        String[][] stringArray = new String[n][n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j] = Long.toString(lArray[n3++]);
            }
        }
        return stringArray;
    }

    public String getVersion() {
        return "$Id: ULongImageHelper.java,v 1.1 2009/03/12 15:22:16 poncet Exp $";
    }
}

