/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.ITangoPeriodicListener;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.tangoatk.core.AtkEventListenerList;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DisplayLevelProperty;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.PropertyStorage;
import fr.esrf.tangoatk.util.AtkTimer;
import java.io.IOException;
import java.util.Map;

public abstract class AAttribute
implements IAttribute,
ITangoPeriodicListener,
ITangoChangeListener {
    static final String RAW_IMAGE_FORMAT = "RawImage";
    protected transient AttributeInfoEx config;
    protected PropertyStorage propertyStorage = null;
    protected EventSupport propChanges;
    protected Device device;
    protected DeviceAttribute attribute;
    protected String error;
    protected String nameSansDevice;
    protected String name;
    protected transient AtkTimer timer;
    protected String state = "OK";
    protected long timeStamp;
    protected boolean skippingRefresh = false;
    protected String alias;
    protected long refreshCount = 0L;
    protected long changeCount = 0L;
    protected long periodicCount = 0L;
    protected DevFailed eventError = null;
    private boolean hasEvents = false;
    protected boolean attPropertiesLoaded = false;
    private static String VERSION = "$Id: AAttribute.java,v 1.41 2009/04/23 16:00:59 poncet Exp $";

    public String getVersion() {
        return VERSION;
    }

    protected AAttribute() {
        if (this.propChanges == null) {
            this.propChanges = new EventSupport();
        }
    }

    protected void serializeInit() throws IOException {
        System.out.print(this.name + "...");
        this.timer = AtkTimer.getInstance();
        try {
            AttributeInfoEx attributeInfoEx = this.getDevice().getAttributeInfo(this.name);
            this.init(this.device, this.nameSansDevice, attributeInfoEx, true);
            System.out.println("Done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    protected void init(Device device, String string, AttributeInfoEx attributeInfoEx, boolean bl) {
        AAttribute aAttribute = this;
        this.timer = aAttribute.timer.getInstance();
        this.propertyStorage = new PropertyStorage();
        this.setDevice(device);
        this.nameSansDevice = string;
        this.setName(this.device + "/" + string);
        this.setConfiguration(attributeInfoEx);
        if (bl && device.doesEvent()) {
            this.subscribeAttributeEvent();
        }
        if (!this.hasEvents) {
            try {
                this.readFirstValueFromNetwork();
            }
            catch (DevFailed devFailed) {
                this.readAttError("Couldn't read from network", new ConnectionException(devFailed));
            }
        }
    }

    private void subscribeAttributeEvent() {
        TangoEventsAdapter tangoEventsAdapter = null;
        String[] stringArray = new String[]{};
        try {
            tangoEventsAdapter = new TangoEventsAdapter((DeviceProxy)this.getDevice());
        }
        catch (DevFailed devFailed) {
            this.hasEvents = false;
            return;
        }
        long l = System.currentTimeMillis();
        try {
            tangoEventsAdapter.addTangoChangeListener((ITangoChangeListener)this, this.nameSansDevice, stringArray);
            this.hasEvents = true;
            this.trace(2, "AATtribute.subscribeAttributeChangeEvent(" + this.name + ") ok:", l);
            return;
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_EventPropertiesNotSet")) {
                try {
                    tangoEventsAdapter.addTangoPeriodicListener((ITangoPeriodicListener)this, this.nameSansDevice, stringArray);
                    this.hasEvents = true;
                    this.trace(2, "AATtribute.subscribeAttributePeriodicEvent(" + this.name + ") ok:", l);
                    return;
                }
                catch (DevFailed devFailed2) {
                    this.hasEvents = false;
                    this.eventError = devFailed2;
                    this.trace(1, "AATtribute.subscribeAttributePeriodicEvent(" + this.name + ") failed:", l);
                    return;
                }
            }
            this.hasEvents = false;
            this.eventError = devFailed;
            this.trace(1, "AATtribute.subscribeAttributeEvent(" + this.name + ") failed:", l);
            return;
        }
    }

    public boolean hasEvents() {
        return this.hasEvents;
    }

    public long getRefreshCount() {
        return this.refreshCount;
    }

    public long getChangeCount() {
        return this.changeCount;
    }

    public long getPeriodicCount() {
        return this.periodicCount;
    }

    public String getSubscriptionError() {
        if (!this.getDevice().doesEvent()) {
            return "ATK does not manage event for the parent device " + this.getDevice().getName() + " (IDL<3)";
        }
        if (this.eventError != null) {
            return this.eventError.errors[0].desc;
        }
        return "";
    }

    public DeviceAttribute getDeviceAttribute() {
        return this.attribute;
    }

    public String toString() {
        return this.name;
    }

    public EventSupport getPropChanges() {
        return this.propChanges;
    }

    public String getType() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.config.data_type;
        switch (n) {
            case 2: {
                stringBuffer.append("Short");
                break;
            }
            case 6: {
                stringBuffer.append("UShort");
                break;
            }
            case 19: {
                stringBuffer.append("State");
                break;
            }
            case 1: {
                stringBuffer.append("Boolean");
                break;
            }
            case 5: {
                stringBuffer.append("Double");
                break;
            }
            case 3: {
                stringBuffer.append("Long");
                break;
            }
            case 7: {
                stringBuffer.append("ULong");
                break;
            }
            case 8: {
                stringBuffer.append("String");
                break;
            }
            case 22: {
                stringBuffer.append("UChar");
                break;
            }
            case 4: {
                stringBuffer.append("Float");
            }
        }
        AttrDataFormat attrDataFormat = this.config.data_format;
        switch (attrDataFormat.value()) {
            case 0: {
                stringBuffer.append("Scalar");
                break;
            }
            case 1: {
                stringBuffer.append("Spectrum");
                break;
            }
            case 2: {
                stringBuffer.append("Image");
            }
        }
        return stringBuffer.toString();
    }

    public int getTangoDataType() {
        int n = this.config.data_type;
        return n;
    }

    public AttrDataFormat getTangoDataFormat() {
        AttrDataFormat attrDataFormat = this.config.data_format;
        return attrDataFormat;
    }

    public void storeConfig() {
        Property property;
        if (this.getProperty("unit").isSpecified()) {
            this.config.unit = this.getProperty("unit").getStringValue();
        }
        if (this.getProperty("standard_unit").isSpecified()) {
            this.config.standard_unit = this.getProperty("standard_unit").getStringValue();
        }
        if (this.getProperty("format").isSpecified()) {
            this.config.format = this.getProperty("format").getStringValue();
        }
        if (this.getProperty("data_type").isSpecified()) {
            this.config.data_type = this.getProperty("data_type").getIntValue();
        }
        if (this.getProperty("max_dim_x").isSpecified()) {
            this.config.max_dim_x = this.getProperty("max_dim_x").getIntValue();
        }
        if (this.getProperty("max_dim_y").isSpecified()) {
            this.config.max_dim_y = this.getProperty("max_dim_y").getIntValue();
        }
        if (this.getProperty("description").isSpecified()) {
            this.config.description = this.getProperty("description").getStringValue();
        }
        if (this.getProperty("label").isSpecified()) {
            this.config.label = this.getProperty("label").getStringValue();
        }
        if (this.getProperty("display_unit").isSpecified()) {
            this.config.display_unit = this.getProperty("display_unit").getStringValue();
        }
        if ((property = this.getProperty("min_value")) != null && property.isSpecified()) {
            this.config.min_value = property.getStringValue();
        }
        if ((property = this.getProperty("max_value")) != null && property.isSpecified()) {
            this.config.max_value = property.getStringValue();
        }
        if ((property = this.getProperty("min_alarm")) != null && property.isSpecified()) {
            if (this.config.alarms != null) {
                this.config.alarms.min_alarm = property.getStringValue();
            } else {
                this.config.min_alarm = property.getStringValue();
            }
        }
        if ((property = this.getProperty("max_alarm")) != null && property.isSpecified()) {
            if (this.config.alarms != null) {
                this.config.alarms.max_alarm = property.getStringValue();
            } else {
                this.config.max_alarm = property.getStringValue();
            }
        }
        if ((property = this.getProperty("min_warning")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.min_warning = property.getStringValue();
        }
        if ((property = this.getProperty("max_warning")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.max_warning = property.getStringValue();
        }
        if ((property = this.getProperty("delta_t")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.delta_t = property.getStringValue();
        }
        if ((property = this.getProperty("delta_val")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.delta_val = property.getStringValue();
        }
        try {
            this.device.storeInfo(this.config);
            this.setConfiguration(this.device.getAttributeInfo(this.getName()));
            this.getState();
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't store config", new AttributeSetException(devFailed));
        }
    }

    public String getFormat() {
        return this.getProperty("format").getStringValue();
    }

    public void addErrorListener(IErrorListener iErrorListener) {
        this.propChanges.addErrorListener(iErrorListener);
    }

    public void removeErrorListener(IErrorListener iErrorListener) {
        this.propChanges.removeErrorListener(iErrorListener);
    }

    public void addSetErrorListener(ISetErrorListener iSetErrorListener) {
        this.propChanges.addSetErrorListener(iSetErrorListener);
    }

    public void removeSetErrorListener(ISetErrorListener iSetErrorListener) {
        this.propChanges.removeSetErrorListener(iSetErrorListener);
    }

    public void addStateListener(IAttributeStateListener iAttributeStateListener) {
        this.propChanges.addAttributeStateListener(iAttributeStateListener);
    }

    public void removeStateListener(IAttributeStateListener iAttributeStateListener) {
        this.propChanges.removeAttributeStateListener(iAttributeStateListener);
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public Device getDevice() {
        return this.device;
    }

    protected void readAttError(String string, Throwable throwable) {
        this.propChanges.fireReadErrorEvent(this, throwable);
    }

    protected void setAttError(String string, Throwable throwable) {
        this.propChanges.fireSetErrorEvent(this, throwable);
    }

    public String getUnit() {
        return this.getProperty("unit").getStringValue();
    }

    public String getStandardUnit() {
        return this.getProperty("standard_unit").getStringValue();
    }

    public double getStandardUnitFactor() {
        double d = (Double)this.getProperty("standard_unit").getValue();
        return d;
    }

    public String getDisplayUnit() {
        return this.getProperty("display_unit").getStringValue();
    }

    public double getDisplayUnitFactor() {
        double d = (Double)this.getProperty("display_unit").getValue();
        return d;
    }

    public String getLabel() {
        return this.getProperty("label").getStringValue();
    }

    public void setLabel(String string) {
        this.propertyStorage.setProperty((IEntity)this, "label", string, true);
    }

    public void setName(String string) {
        this.name = string;
        this.propertyStorage.setProperty((IEntity)this, "name", string, false);
    }

    public void setDescription(String string) {
        this.propertyStorage.setProperty((IEntity)this, "description", string, true);
    }

    public String getDescription() {
        return this.propertyStorage.getProperty("description").getStringValue();
    }

    public int getLevel() {
        return this.propertyStorage.getProperty("level").getIntValue();
    }

    public boolean isOperator() {
        Property property = this.getProperty("level");
        if (property != null && property instanceof DisplayLevelProperty) {
            DisplayLevelProperty displayLevelProperty = (DisplayLevelProperty)property;
            return displayLevelProperty.isOperator();
        }
        return false;
    }

    public boolean isExpert() {
        Property property = this.getProperty("level");
        if (property != null && property instanceof DisplayLevelProperty) {
            DisplayLevelProperty displayLevelProperty = (DisplayLevelProperty)property;
            return displayLevelProperty.isExpert();
        }
        return false;
    }

    protected void setConfiguration(AttributeInfoEx attributeInfoEx) {
        double d;
        double d2;
        this.timer.startTimer(Thread.currentThread());
        this.config = attributeInfoEx;
        this.propertyStorage.setProperty((IEntity)this, "unit", this.config.unit, false);
        this.propertyStorage.setProperty((IAttribute)this, "data_format", this.config.data_format, false);
        this.propertyStorage.setProperty((IEntity)this, "format", this.config.format, true);
        this.propertyStorage.setProperty((IEntity)this, "data_type", new Integer(this.config.data_type), false);
        this.propertyStorage.setProperty((IEntity)this, "description", this.config.description, true);
        this.propertyStorage.setProperty((IEntity)this, "label", this.config.label, true);
        this.propertyStorage.setProperty((IAttribute)this, "writable", this.config.writable, false);
        this.propertyStorage.setProperty((IEntity)this, "writable_attr_name", this.config.writable_attr_name, false);
        if ("None".equals(this.config.writable_attr_name)) {
            this.propertyStorage.getProperty("writable_attr_name").setSpecified(false);
        }
        try {
            d2 = Double.parseDouble(this.config.display_unit);
            if (d2 <= 0.0) {
                d2 = 1.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            d2 = 1.0;
        }
        this.propertyStorage.setProperty((IEntity)this, "display_unit", new Double(d2), false);
        this.propertyStorage.setProperty((IEntity)this, "max_dim_x", new Integer(this.config.max_dim_x), false);
        this.propertyStorage.setProperty((IEntity)this, "max_dim_y", new Integer(this.config.max_dim_y), false);
        this.propertyStorage.setProperty((IEntity)this, "level", this.config.level, false);
        try {
            d = Double.parseDouble(this.config.standard_unit);
            if (d <= 0.0) {
                d = 1.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            d = 1.0;
        }
        this.setProperty("standard_unit", new Double(d), false);
        this.timer.endTimer(Thread.currentThread());
    }

    public static String[] getPropertyNames() {
        String[] stringArray = new String[]{"name", "unit", "data_format", "data_type", "description", "label", "writable", "writable_attr_name", "display_unit", "max_dim_x", "max_dim_y", "level", "standard_unit", "min_value", "max_value", "min_alarm", "max_alarm", "min_warning", "max_warning", "delta_t", "delta_val"};
        return stringArray;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public String getName() {
        return this.name;
    }

    public String getNameSansDevice() {
        return this.nameSansDevice;
    }

    public boolean isWritable() {
        AttrWriteType attrWriteType = (AttrWriteType)this.getProperty("writable").getValue();
        return attrWriteType == AttrWriteType.WRITE || attrWriteType == AttrWriteType.READ_WRITE;
    }

    private final void readFirstValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttribute(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
    }

    protected final DeviceAttribute readValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttribute(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
        return this.attribute;
    }

    protected final DeviceAttribute readDeviceValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttributeFromDevice(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
        return this.attribute;
    }

    protected void setState() throws DevFailed {
        AttrQuality attrQuality = this.attribute.getQuality();
        if (0 == attrQuality.value()) {
            this.setState("VALID");
            return;
        }
        if (1 == attrQuality.value()) {
            this.setState("INVALID");
            return;
        }
        if (2 == attrQuality.value()) {
            this.setState("ALARM");
            return;
        }
        if (4 == attrQuality.value()) {
            this.setState("WARNING");
            return;
        }
        if (3 == attrQuality.value()) {
            this.setState("CHANGING");
            return;
        }
        this.setState("UNKNOWN");
    }

    protected void setState(DeviceAttribute deviceAttribute) throws DevFailed {
        AttrQuality attrQuality = deviceAttribute.getQuality();
        if (0 == attrQuality.value()) {
            this.setState("VALID");
            return;
        }
        if (1 == attrQuality.value()) {
            this.setState("INVALID");
            return;
        }
        if (2 == attrQuality.value()) {
            this.setState("ALARM");
            return;
        }
        if (4 == attrQuality.value()) {
            this.setState("WARNING");
            return;
        }
        if (3 == attrQuality.value()) {
            this.setState("CHANGING");
            return;
        }
        this.setState("UNKNOWN");
    }

    public DeviceAttribute getAttribute() {
        return this.attribute;
    }

    protected void setState(String string) {
        this.state = string;
        this.propChanges.fireAttributeStateEvent(this, string);
    }

    public String getState() {
        try {
            this.readValueFromNetwork();
        }
        catch (DevFailed devFailed) {
            this.readAttError("Couldn't read from network", new ConnectionException(devFailed));
            return "UNKNOWN";
        }
        catch (Exception exception) {
            this.readAttError("Couldn't read from network", exception);
            return "UNKNOWN";
        }
        return this.state;
    }

    protected void writeAtt() throws DevFailed {
        this.device.writeAttribute(this.attribute);
    }

    public int getMaxXDimension() {
        return this.getProperty("max_dim_x").getIntValue();
    }

    public int getMaxYDimension() {
        return this.getProperty("max_dim_y").getIntValue();
    }

    public int getYDimension() {
        try {
            return this.attribute.getDimY();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getHeight() {
        return this.getYDimension();
    }

    public int getXDimension() {
        try {
            return this.attribute.getDimX();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getWidth() {
        return this.getYDimension();
    }

    public void setSkippingRefresh(boolean bl) {
        this.skippingRefresh = bl;
    }

    public boolean isSkippingRefresh() {
        return this.skippingRefresh;
    }

    protected void checkDimensions(Object[][] objectArray) {
        if (objectArray.length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (objectArray[0].length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkDimensions(double[][] dArray) {
        if (dArray[0].length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (dArray.length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkDimensions(boolean[][] blArray) {
        if (blArray[0].length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (blArray.length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static String[] flatten(String[][] stringArray) {
        int n = stringArray.length * stringArray[0].length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            System.arraycopy(stringArray[i], 0, stringArray2, i * stringArray.length, stringArray.length);
        }
        return stringArray2;
    }

    protected final DeviceDataHistory[] readAttHistoryFromNetwork() throws DevFailed {
        return this.device.attribute_history(this.nameSansDevice);
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public AtkEventListenerList getListenerList() {
        if (this.propChanges == null) {
            return null;
        }
        return this.propChanges.getListenerList();
    }

    public void freeInternalData() {
        this.attribute = null;
    }

    public Property getProperty(String string) {
        return this.propertyStorage.getProperty(string);
    }

    public Map getPropertyMap() {
        return this.propertyStorage.getPropertyMap();
    }

    public void setProperty(String string, Number number) {
        this.propertyStorage.setProperty(string, number);
    }

    public void setProperty(String string, Number number, boolean bl) {
        this.propertyStorage.setProperty((IEntity)this, string, number, bl);
    }

    public PropertyStorage getPropertyStorage() {
        return this.propertyStorage;
    }

    public void setPropertyStorage(PropertyStorage propertyStorage) {
        this.propertyStorage = propertyStorage;
    }

    public boolean areAttPropertiesLoaded() {
        return this.attPropertiesLoaded;
    }

    public void loadAttProperties() {
        this.attPropertiesLoaded = true;
    }
}

