/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import pogo.gene.PogoDefs;
import pogo.gene.PogoException;

public class ProjectFiles
implements PogoDefs {
    private String orig_path = null;
    private String orig_class_name = null;
    private String path;
    private String class_name;
    private int language;
    private String extention;
    private String doc_path = "";

    public ProjectFiles(String path, String class_name, int language) {
        this.path = path;
        this.class_name = class_name;
        this.language = language;
        this.extention = language == 0 ? ".java" : ".cpp";
    }

    public ProjectFiles(String filename) throws PogoException {
        int ext_idx;
        for (ext_idx = filename.length() - 1; ext_idx > 0 && filename.charAt(ext_idx) != '.'; --ext_idx) {
        }
        if (ext_idx == 0) {
            throw new PogoException(filename + ": Not Available File's Name !");
        }
        this.extention = filename.substring(ext_idx);
        if (this.extention.equals(".java")) {
            this.language = 0;
        } else if (this.extention.equals(".py")) {
            this.language = 2;
        } else if (this.extention.equals(".cpp") || this.extention.equals(".h")) {
            this.language = 1;
            this.extention = ".cpp";
        } else {
            throw new PogoException("File's extention unknown !");
        }
        int end_path = filename.lastIndexOf("/", ext_idx);
        if (end_path < 0 && (end_path = filename.lastIndexOf("\\", ext_idx)) < 0) {
            this.path = ".";
            this.class_name = filename.substring(0, ext_idx);
        }
        if (end_path > 0) {
            this.path = filename.substring(0, end_path);
            this.class_name = filename.substring(end_path + 1, ext_idx);
        }
        this.orig_path = this.path;
        this.orig_class_name = this.class_name;
    }

    public void updateOriginalFields() {
        this.orig_path = this.path;
        this.orig_class_name = this.class_name;
    }

    public int getLanguage() {
        return this.language;
    }

    public String getPath() {
        return this.path;
    }

    public String getOriginalPath() {
        return this.orig_path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setOriginalPath(String orig_path) {
        this.orig_path = orig_path;
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getOriginalClassName() {
        return this.orig_class_name;
    }

    public void setClassName(String class_name) {
        this.orig_class_name = this.class_name;
        this.class_name = class_name;
    }

    public void setOriginalClassName(String orig_class_name) {
        this.orig_class_name = orig_class_name;
    }

    public String getServer() {
        return this.path + "/" + this.class_name + this.extention;
    }

    public String getServer_h() {
        return this.path + "/" + this.class_name + ".h";
    }

    public String getServerClass() {
        if (this.language == 2) {
            return this.getServer();
        }
        return this.path + "/" + this.class_name + "Class" + this.extention;
    }

    public String getServerClass_h() {
        return this.path + "/" + this.class_name + "Class.h";
    }

    public String getAllowed() {
        if (this.language == 0) {
            return "";
        }
        return this.path + "/" + this.class_name + "StateMachine" + this.extention;
    }

    public String getDocHtml() {
        if (!this.doc_path.equals("")) {
            return this.doc_path;
        }
        this.doc_path = System.getProperty("HTML_DIR");
        if (this.doc_path == null) {
            this.doc_path = this.path + "/doc_html";
        } else if (!this.doc_path.startsWith("/")) {
            this.doc_path = this.path + "/" + this.doc_path;
        }
        return this.doc_path;
    }

    public String getHtmlServerslist() {
        return "ServersList";
    }

    public String toString() {
        return "ProjectFiles:\nPath:\t" + this.path + "\nClass: \t" + this.getClassName() + "\nServer:\t" + this.getServer() + "\nServer.h:\t" + this.getServer_h() + "\nServerC:\t" + this.getServerClass() + "\nServerC.h:\t" + this.getServerClass_h() + "\n\norig_path       = " + this.orig_path + "\norig_class_name = " + this.orig_class_name;
    }

    public static void main(String[] args) {
        String filename = "/segfs/tango/tools/pogo/test/cpp/PowerSupply/PowerSupply.h";
        try {
            ProjectFiles p = new ProjectFiles(filename);
            System.out.println(p);
            System.out.println();
            System.out.println();
            p = new ProjectFiles("../template", "Test", 1);
            System.out.println(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

