/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.Property;
import pogo.gene.PropertyTable;

public class CppServerClass
extends PogoGene
implements PogoDefs,
TangoConst {
    private String classname;
    private PropertyTable properties;
    private boolean is_abstractclass;
    private static final String sigletonPattern = "Initialize pointer for singleton pattern";

    public CppServerClass(PogoClass pogo) {
        super(pogo);
        this.properties = pogo.class_properties;
        this.classname = pogo.class_name;
        this.is_abstractclass = pogo.is_abstractclass;
    }

    protected String addCmdClassDefs(PogoString code) throws PogoException {
        int i;
        String target = "Define classes for attributes";
        int start = code.str.indexOf(target);
        if (start < 0) {
            throw new PogoException("Input File Syntax error !\n\"" + target + "\" Not Found !");
        }
        int end = code.indexOf("\n", start);
        end = code.indexOf("\n", end + 1);
        start = code.lastIndexOf("//==============", start);
        String attr_title = code.substring(start, end);
        start = end;
        end = code.inMethod(start);
        end = code.outMethod(end);
        String attr_block = code.substring(start, end);
        code = new PogoString(code.str.substring(end));
        target = "Define classes for commands";
        start = code.str.indexOf(target);
        if (start < 0) {
            throw new PogoException("Input File Syntax error !\n\"" + target + "\" Not Found !");
        }
        end = code.indexOf("\n", start);
        end = code.indexOf("\n", end + 1);
        start = code.lastIndexOf("\n", start);
        start = code.lastIndexOf("\n", start - 1);
        String cmd_title = code.substring(start, end);
        start = end;
        end = code.inMethod(start);
        end = code.outMethod(end);
        String cmd_block = code.substring(start, end);
        code = new PogoString(code.str.substring(end));
        for (i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method) continue;
            code.insert(0, cmd.buildCppClassesDefs(cmd_block, this.pogo.class_name));
        }
        code.insert(0, cmd_title);
        for (i = 0; i < this.pogo.attributes.size(); ++i) {
            Attrib attr = this.pogo.attributes.attributeAt(i);
            code.insert(0, attr.buildCppClassesDefs(attr_block, this.pogo.class_name));
        }
        code.insert(0, attr_title);
        if (this.pogo.attributes.size() > 0 && code.str.indexOf("attribute_factory") < 0 && (start = code.str.indexOf("command_factory")) > 0) {
            start = code.nextCr(start) + 1;
            code.insert(start, "\tvoid attribute_factory(vector<Tango::Attr *> &);\n");
        }
        StringBuffer sb = new StringBuffer("//\tproperties member data\n");
        for (int i2 = 0; i2 < this.properties.size(); ++i2) {
            Property property = this.properties.propertyAt(i2);
            sb.append(property.buildDefinition(1));
        }
        start = code.str.indexOf(": public Tango::DeviceClass");
        if (start < 0) {
            throw new PogoException("Input File Syntax error !");
        }
        if ((start = code.str.indexOf("public:", start)) < 0) {
            throw new PogoException("Input File Syntax error !");
        }
        start = code.nextCr(start) + 1;
        code.insert(start, sb.toString());
        start = code.str.indexOf("command_factory", start);
        if (start < 0) {
            throw new PogoException("Input File Syntax error !");
        }
        start = code.nextCr(start) + 1;
        code.insert(start, "\tvoid get_class_property();\n");
        return code.toString();
    }

    private PogoString toAbstractClassHeader(PogoString code) {
        int start = code.str.indexOf("add your own data members here");
        start = code.str.indexOf("public:\n", start) + "public:\n".length();
        start = code.str.indexOf("\n", start) + 1;
        int end = code.str.indexOf("protected:", start);
        code.remove(code.str.substring(start, end));
        code.remove("\tTango::DbData\tcl_prop;");
        code.remove("\tTango::DbData\tclass_def_prop;");
        code.remove("\tTango::DbData\tdev_def_prop;");
        code.remove("\tvoid write_class_property();\n");
        code.remove("\tvoid set_default_property();\n");
        code.remove("\tstatic " + this.classname + "Class *_instance;\n");
        code.remove("\tvoid device_factory(const Tango::DevVarStringArray *);\n");
        return code;
    }

    public void generateHeader(String serverclass_h) throws FileNotFoundException, SecurityException, IOException, PogoException {
        System.out.println("Generating " + serverclass_h + "....");
        String head_of_file = null;
        String data_members = "";
        if (CppServerClass.already_exists(serverclass_h)) {
            int start;
            String include_server_h;
            PogoString pgs = new PogoString(PogoUtil.readFile(serverclass_h));
            String namespace = "namespace " + this.pogo.namespace();
            int end = pgs.str.indexOf(namespace);
            if (end < 0) {
                end = pgs.str.indexOf("namespace " + this.pogo.class_name);
            }
            if (end < 0) {
                throw new PogoException("Syntax error in reading " + serverclass_h + "\n " + namespace + " Not Found !");
            }
            int tmp = pgs.str.indexOf("Define classes for attributes", end);
            if (tmp > 0) {
                end = pgs.str.lastIndexOf("//==========", tmp);
            }
            if ((head_of_file = pgs.str.substring(0, end)).indexOf(include_server_h = "#include <" + this.pogo.class_name + ".h>") < 0) {
                start = head_of_file.indexOf("<tango.h>");
                start = head_of_file.indexOf("\n", start) + 1;
                String s1 = head_of_file.substring(0, start);
                String s2 = head_of_file.substring(start);
                head_of_file = s1 + include_server_h + "\n" + s2;
            }
            if ((start = pgs.str.indexOf("//\tadd your own data members here")) > 0) {
                end = pgs.str.indexOf("public:", start);
                data_members = pgs.str.substring(start, end);
            }
        }
        String templname = this.pogo.templates_dir + "/cpp/" + "DevServ" + "Class.h";
        PogoString templcode = new PogoString(PogoUtil.readFile(templname));
        templcode = PogoUtil.removeLogMessages(templcode);
        while (templcode.str.indexOf("TemplateDevServ".toUpperCase()) >= 0) {
            templcode.replace("TemplateDevServ".toUpperCase(), this.pogo.class_name.toUpperCase());
        }
        while (templcode.str.indexOf("TemplateDevServ") >= 0) {
            templcode.replace("TemplateDevServ", this.pogo.class_name);
        }
        int start = templcode.str.indexOf("namespace ");
        if (start < 0) {
            throw new PogoException("Syntax error in reading " + serverclass_h);
        }
        start = templcode.inMethod(start);
        start = templcode.nextCr(start);
        if (head_of_file == null) {
            head_of_file = templcode.str.substring(0, start);
        }
        templcode = new PogoString(templcode.str.substring(start));
        PogoString new_code = new PogoString(this.addCmdClassDefs(templcode));
        if (data_members.length() > 0 && (start = new_code.str.indexOf("//\tadd your own data members here")) > 0) {
            int end = new_code.str.indexOf("public:", start);
            String tmp = new_code.str.substring(start, end);
            new_code.replace(tmp, data_members);
        }
        if (this.is_abstractclass) {
            new_code = this.toAbstractClassHeader(new_code);
        }
        PogoUtil.writeFile(serverclass_h, head_of_file + new_code.str);
    }

    public void generateSource(String serverclass) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String get_property;
        String classes;
        System.out.println("Generating " + serverclass + "....");
        String templname = this.pogo.templates_dir + "/cpp/" + "DevServ" + "Class.cpp";
        PogoString templcode = new PogoString(PogoUtil.readFile(templname, "TemplateDevServ", this.pogo.class_name));
        templcode = PogoUtil.removeLogMessages(templcode);
        String def_property = "";
        String put_property = "";
        String class_constructor = null;
        String user_code = "";
        PogoString code = null;
        if (CppServerClass.already_exists(serverclass)) {
            code = new PogoString(PogoUtil.readFile(serverclass));
            code = this.checkCVStags(code, templcode);
            classes = this.updateCmdClass(code, templcode);
            classes = this.correctOldTrace(classes);
            class_constructor = this.getClassConstructor(code);
            get_property = this.getGetPropertyMethod(code);
            user_code = this.getUserCode(code);
        } else {
            classes = this.createCmdClass(templcode);
            get_property = this.getGetPropertyMethod(null);
        }
        System.out.println("generating for deviceImpl = " + this.pogo.deviceImpl);
        if (this.pogo.deviceImpl < 3) {
            classes = this.updateIsAllowedMethods(classes);
        }
        String factories = this.buildFactories(templcode, code);
        if (!this.is_abstractclass && class_constructor != null) {
            PogoString tmp = new PogoString(factories);
            String s = this.getClassConstructor(tmp);
            tmp.replace(s, class_constructor);
            factories = tmp.str;
        }
        if (!this.is_abstractclass) {
            get_property = this.updatePropertyMethod(get_property);
            factories = this.addPutGetPropertyCall(factories, "write_class");
            factories = this.addPutGetPropertyCall(factories, "get_class");
            factories = this.addPutGetPropertyCall(factories, "set_default");
            put_property = this.buildPutPropertyMethod();
            def_property = this.buildDefaultPropertyMethod();
        }
        if (this.is_abstractclass) {
            factories = this.toAbstractClass(factories);
        }
        String newcode = classes + factories;
        if (!this.is_abstractclass) {
            newcode = newcode + get_property;
            newcode = newcode + def_property;
            newcode = newcode + put_property;
        }
        newcode = newcode + user_code;
        newcode = newcode + "\n}\t// namespace\n";
        PogoUtil.writeFile(serverclass, newcode);
    }

    private String toAbstractClass(String str) throws PogoException {
        String constr;
        int start;
        PogoString code = new PogoString(str);
        String init_ptr = this.classname + "Class *" + this.classname + "Class::_instance";
        int end = code.str.indexOf(init_ptr);
        if (end > 0) {
            end = code.str.indexOf("//", end);
            code.remove(code.str.substring(0, end));
        }
        if ((start = code.str.indexOf(constr = this.classname + "Class::" + this.classname + "Class(string &s):DeviceClass(s)")) < 0) {
            throw new PogoException(constr + "\nNot found in source file");
        }
        start = code.inMethod(start);
        start = code.outMethod(start);
        String cmd_fact = "void " + this.classname + "Class::command_factory()";
        end = code.str.indexOf(cmd_fact, start);
        if (end > 0) {
            end = code.str.lastIndexOf("//+--------------", end);
            code.remove(code.str.substring(start, end));
        }
        if ((start = code.str.indexOf(cmd_fact, start)) > 0) {
            start = code.inMethod(start);
            start = code.outMethod(start);
            String attr_fact = "void " + this.classname + "Class::attribute_factory(vector<Tango::Attr *> &att_list)";
            end = code.str.indexOf(attr_fact, start);
            if (end > 0) {
                end = code.str.lastIndexOf("//+--------------", end);
                code.remove(code.str.substring(start, end));
            }
        }
        return code.str;
    }

    protected String getUserCode(PogoString code) {
        String signature = "void " + this.classname + "Class::write_class_property()";
        int start = code.str.indexOf(signature);
        if (start < 0) {
            return "";
        }
        start = code.inMethod(start);
        start = code.outMethod(start);
        int end = code.str.indexOf("}\t// namespace");
        if (end < 0) {
            return "";
        }
        end = code.str.lastIndexOf(10, end);
        return code.str.substring(start, end);
    }

    protected String addPutGetPropertyCall(String readcode, String putget) throws PogoException {
        String method_call = putget + "_property();";
        String s = this.getClassConstructor(new PogoString(readcode));
        PogoString method_core = new PogoString(s);
        if (s.indexOf(method_call) > 0) {
            return readcode;
        }
        int start = method_core.str.indexOf("{");
        String target = "Entering " + this.pogo.class_name + "Class constructor";
        int tmp = method_core.str.indexOf(target, start);
        if (tmp > 0) {
            start = tmp;
        }
        start = method_core.nextCr(start) + 1;
        method_core.insert(start, "\t" + method_call + "\n");
        PogoString newcode = new PogoString(readcode);
        newcode.replace(s, method_core.str);
        return newcode.str;
    }

    protected String updateCmdClass(PogoString readcode, PogoString templcode) throws PogoException {
        int end = readcode.str.indexOf(sigletonPattern);
        if (end < 0) {
            if (!this.is_abstractclass) {
                throw new PogoException("Initialize pointer for singleton pattern not found in source file");
            }
            String constr = this.classname + "Class::" + this.classname + "Class(string &s):DeviceClass(s)";
            end = readcode.str.indexOf(constr);
            if (end < 0) {
                throw new PogoException(constr + "\nNot found in source file");
            }
            end = readcode.str.lastIndexOf("//+---------", end);
        } else {
            boolean found = false;
            while (!found) {
                String s = readcode.str.substring((end = readcode.str.lastIndexOf(10, end - 1)) + 1);
                found = !s.startsWith("//");
            }
            end = readcode.str.indexOf("//", end);
        }
        PogoString pgs = new PogoString(readcode.str.substring(0, end));
        for (int i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method) continue;
            String method = "CORBA::Any *" + cmd.cmd_class + "::execute(Tango::DeviceImpl ";
            int start_meth = pgs.str.indexOf(method);
            if (start_meth < 0) {
                System.out.println("\t-> creating...");
                pgs.str = this.insertNewCmdClass(cmd, pgs, templcode.str);
                continue;
            }
            start_meth = pgs.inMethod(start_meth);
            int end_meth = pgs.outMethod(start_meth + 1);
            String oldCore = pgs.str.substring(start_meth, end_meth);
            PogoString templ = new PogoString(this.getCmdBlockFromTemplate(templcode.str, 0));
            start_meth = templ.inMethod(0);
            end_meth = templ.outMethod(start_meth + 1);
            String newCore = cmd.buildCppCmdClassBlock(templ.str.substring(start_meth, end_meth), this.pogo.class_name);
            pgs.replace(oldCore, newCore);
        }
        return this.removeDeletedCmdClasses(pgs);
    }

    protected String removeDeletedCmdClasses(PogoString code) {
        String ret_type = "CORBA::Any *";
        int start = 0;
        while ((start = code.indexOf(ret_type, start)) >= 0) {
            String expected_sig;
            int end = code.indexOf("::execute", start);
            String class_name = code.substring(start + ret_type.length(), end);
            String signature = code.substring(start, end = code.indexOf("\n", end));
            if (signature.equals(expected_sig = ret_type + class_name + "::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)")) {
                boolean still_exists = false;
                for (int i = 0; i < this.pogo.commands.size() && !still_exists; ++i) {
                    if (!this.pogo.commands.cmdAt((int)i).cmd_class.equals(class_name)) continue;
                    still_exists = true;
                }
                if (!still_exists) {
                    System.out.println(class_name + " has been removed !");
                    end = code.inMethod(end);
                    end = code.outMethod(end);
                    int idx = code.lastIndexOf("}", start);
                    if (idx < 0) {
                        idx = code.lastIndexOf("{", start);
                    }
                    start = code.indexOf("//", idx);
                    code.remove(code.substring(start, end));
                }
            }
            start = end;
        }
        return code.str;
    }

    protected String createCmdClass(PogoString templcode) throws PogoException {
        int start = templcode.str.indexOf("TemplateBlock");
        if (start < 0) {
            throw new PogoException("Input File Syntax error 1!");
        }
        String head = templcode.str.substring(0, start);
        String exec_templ = this.getCmdBlockFromTemplate(templcode.str, 0);
        String str = "";
        for (int i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method) continue;
            String s = cmd.setCmdClass(exec_templ);
            str = str + cmd.buildCppCmdClassBlock(s, this.pogo.class_name);
        }
        str = str + "\n\n";
        return head + str;
    }

    protected String buildFactories(PogoString templcode, PogoString old_code) throws PogoException {
        String str = "";
        int start = templcode.str.indexOf(sigletonPattern);
        if (start < 0) {
            throw new PogoException("Initialize pointer for singleton pattern not found in source file");
        }
        start = templcode.previousCr(start);
        start -= 2;
        start = templcode.previousCr(start);
        start -= 2;
        start = templcode.previousCr(start);
        int end = templcode.str.indexOf("command_factory");
        if (end < 0) {
            throw new PogoException("command_factory() method not found !");
        }
        end = templcode.inMethod(end);
        str = str + templcode.str.substring(start, end);
        str = str + this.pogo.commands.buildCommandFactoryMethod(1);
        start = templcode.outMethod(end + 1);
        start = templcode.nextCr(start);
        end = templcode.str.indexOf("device_factory(const Tango::DevVarStringArray *devlist_ptr)");
        if (end < 0) {
            throw new PogoException("device_factory() method not found !");
        }
        end = templcode.inMethod(end);
        end = templcode.outMethod(end + 1);
        end = templcode.nextCr(end);
        str = str + templcode.str.substring(start, end);
        if (this.pogo.attributes.size() > 0) {
            str = str + "//+----------------------------------------------------------------------------\n//\tMethod: " + this.pogo.class_name + "Class::attribute_factory(vector<Tango::Attr *> &att_list)\n" + "//-----------------------------------------------------------------------------\n" + "void " + this.pogo.class_name + "Class::attribute_factory(vector<Tango::Attr *> &att_list)\n" + this.pogo.attributes.buildFactory(1);
            if (old_code != null && (start = old_code.indexOf("Class::attribute_factory(vector<Tango::Attr *> &att_list)")) > 0) {
                start = old_code.inMethod(start);
                end = old_code.outMethod(start);
                String method = old_code.substring(start, end);
                if ((start = method.indexOf("End of Automatic code generation")) > 0) {
                    start = method.indexOf("\n", start) + 1;
                    start = method.indexOf("\n", start) + 1;
                    String user_part = method.substring(start);
                    str = str.substring(0, str.length() - 2) + user_part;
                }
            }
        }
        if (old_code == null) {
            return str;
        }
        if (this.pogo.is_abstractclass) {
            return str;
        }
        PogoString new_code = new PogoString(str);
        start = old_code.str.indexOf("device_factory(const Tango::DevVarStringArray *devlist_ptr)");
        if (start < 0) {
            throw new PogoException("device_factory() method not found !");
        }
        start = old_code.inMethod(start);
        end = old_code.str.indexOf("\t//\tCreate all devices.(Automatic code generation)", start = old_code.str.indexOf("\n", start) + 1);
        if (end < 0) {
            System.out.println("\"Create all devices.(Automatic code generation)\"  NOT found !");
            return str;
        }
        String user_code = old_code.substring(start, end);
        start = new_code.str.indexOf("device_factory(const Tango::DevVarStringArray *devlist_ptr)");
        start = new_code.inMethod(start);
        start = new_code.str.indexOf("\n", start) + 1;
        end = new_code.str.indexOf("\t//\tCreate all devices.(Automatic code generation)", start);
        new_code.replace(start, new_code.str.substring(start, end), user_code);
        start = old_code.str.indexOf("device_factory(const Tango::DevVarStringArray *devlist_ptr)");
        if (start < 0) {
            throw new PogoException("device_factory() method not found !");
        }
        start = old_code.inMethod(start);
        end = old_code.outMethod(start);
        start = old_code.indexOf("\t//\tEnd of Automatic code generation", start);
        user_code = old_code.substring(start, end);
        start = new_code.str.indexOf("device_factory(const Tango::DevVarStringArray *devlist_ptr)");
        start = new_code.inMethod(start);
        end = new_code.outMethod(start);
        start = new_code.indexOf("\t//\tEnd of Automatic code generation", start);
        new_code.replace(start, new_code.str.substring(start, end), user_code);
        return new_code.str;
    }

    protected String insertNewCmdClass(Cmd cmd, PogoString pgs, String templcode) throws PogoException {
        String exec_templ = this.getCmdBlockFromTemplate(templcode, 0);
        int idx = pgs.str.indexOf("namespace " + this.pogo.namespace());
        if (idx < 0) {
            idx = pgs.str.indexOf("namespace " + this.pogo.class_name);
        }
        if (idx < 0) {
            int i = 0;
            while ((i = pgs.str.indexOf("#include", i)) >= 0) {
                idx = i++;
            }
        }
        idx = pgs.nextCr(idx) + 2;
        String s = cmd.setCmdClass(exec_templ);
        String new_cmd = cmd.buildCppCmdClassBlock(s, this.pogo.class_name);
        pgs.insert(idx, new_cmd);
        return pgs.str;
    }

    protected String getCmdBlockFromTemplate(String templcode, int num) throws PogoException {
        int start = 0;
        for (int i = 0; i <= num; ++i) {
            if ((start = templcode.indexOf("TemplateBlock", start + 1)) >= 0) continue;
            throw new PogoException("Input File Syntax error 1!TemplateBlockNot found");
        }
        start = templcode.indexOf("\n", start);
        int end = templcode.indexOf("TemplateBlock", start);
        return templcode.substring(start, end);
    }

    protected String updateIsAllowedMethods(String readcode) throws PogoException {
        PogoString pgs = new PogoString(readcode);
        for (int i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method) continue;
            String pattern = "bool " + cmd.cmd_class + "::is_allowed";
            int start = pgs.str.indexOf(pattern);
            if (start < 0) {
                throw new PogoException("\"" + pattern + "\" Not Found in source file !");
            }
            start = pgs.previousCr(start);
            int end = pgs.nextCr(start) + 1;
            String line = pgs.str.substring(start, end);
            start = pgs.inMethod(start);
            end = pgs.outMethod(start);
            String method = pgs.str.substring(start, end);
            String newMethod = cmd.buildIsAllowedMethod(new PogoString(method), 1);
            pgs.replace(line + method, line + newMethod);
        }
        return pgs.str;
    }

    protected String getClassConstructor(PogoString readcode) throws PogoException {
        String constr = this.classname + "Class::" + this.classname + "Class(string &s):DeviceClass(s)";
        int start = readcode.str.indexOf(constr);
        if (start < 0 && (start = readcode.str.indexOf(constr = this.classname + "Class::" + this.classname + "Class(string &s):Tango::DeviceClass(s)")) < 0) {
            throw new PogoException(constr + "\nNot found in source file");
        }
        int end = start = readcode.str.lastIndexOf("//+-----", start);
        while (readcode.str.charAt(end) != '{') {
            ++end;
        }
        end = readcode.outMethod(end);
        end = readcode.inMethod(end + 1);
        end = readcode.outMethod(end);
        return readcode.str.substring(start, end);
    }

    protected String getGetPropertyMethod(PogoString readcode) throws FileNotFoundException, SecurityException, IOException {
        int start;
        String get_property_signature = "void " + this.pogo.class_name + "Class::get_class_property()";
        if (readcode == null || (start = readcode.str.indexOf(get_property_signature)) < 0) {
            String templname = this.pogo.templates_dir + "/cpp/" + "readPropMethodName.cpp";
            PogoString templcode = new PogoString(PogoUtil.readFile(templname));
            templcode = PogoUtil.removeLogMessages(templcode);
            while (templcode.str.indexOf("TemplateDevServ") >= 0) {
                templcode.replace("TemplateDevServ", this.pogo.class_name + "Class");
            }
            while (templcode.str.indexOf("target") >= 0) {
                templcode.replace("target", "class");
            }
            return templcode.str;
        }
        int end = readcode.inMethod(start);
        end = readcode.outMethod(end + 1);
        while (readcode.str.charAt(start) != '}') {
            --start;
        }
        return readcode.str.substring(start += 2, end);
    }

    protected String updatePropertyMethod(String readcode) throws PogoException {
        Property property;
        int i;
        PogoString core = new PogoString(readcode);
        String pattern = "Automatic code generation";
        int start = core.str.indexOf(pattern);
        if (start < 0) {
            throw new PogoException("Input File Syntax error 1!\"" + pattern + "\" Not found");
        }
        start = core.nextCr(start) + 1;
        start = core.nextCr(start) + 1;
        int end = core.str.indexOf("End of Automatic code generation", start);
        end = core.previousCr(end);
        String str = core.str.substring(0, start);
        for (i = 0; i < this.properties.size(); ++i) {
            property = this.properties.propertyAt(i);
            str = str + "\tcl_prop.push_back(Tango::DbDatum(\"" + property.name + "\"));\n";
        }
        str = str + "\n\t//\tCall database and extract values\n\t//--------------------------------------------\n\tif (Tango::Util::instance()->_UseDb==true)\n\t\tget_db_class()->get_property(cl_prop);\n\tTango::DbDatum\tdef_prop;\n\tint\ti = -1;\n\n";
        for (i = 0; i < this.properties.size(); ++i) {
            property = this.properties.propertyAt(i);
            str = str + "\t//\tTry to extract " + property.name + " value\n" + "\tif (cl_prop[++i].is_empty()==false)" + "\tcl_prop[i]  >>  " + property.getVarName() + ";\n" + "\telse\n" + "\t{\n" + "\t\t//\tCheck default value for " + property.name + "\n" + "\t\tdef_prop = get_default_class_property(cl_prop[i].name);\n" + "\t\tif (def_prop.is_empty()==false)\n" + "\t\t{\n" + "\t\t\tdef_prop  >>  " + property.getVarName() + ";\n" + "\t\t\tcl_prop[i]  <<  " + property.getVarName() + ";\n" + "\t\t}\n" + "\t}\n";
            if (i >= this.properties.size() - 1) continue;
            str = str + "\n";
        }
        return str + "\n" + core.str.substring(end);
    }

    protected String buildDefaultPropertyMethod() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String templname = this.pogo.templates_dir + "/cpp/set_default_property.cpp";
        String readcode = PogoUtil.readFile(templname, "TemplateDevServ", this.pogo.class_name);
        String cl_prop = "\tvector<string>\tvect_data;\n";
        cl_prop = cl_prop + "\t//\tSet Default Class Properties\n";
        for (int i = 0; i < this.pogo.class_properties.size(); ++i) {
            Property prop = this.pogo.class_properties.propertyAt(i);
            cl_prop = cl_prop + prop.geneDefaultValue(0);
        }
        String dev_prop = "\t//\tSet Default Device Properties\n";
        for (int i = 0; i < this.pogo.dev_properties.size(); ++i) {
            Property prop = this.pogo.dev_properties.propertyAt(i);
            dev_prop = dev_prop + prop.geneDefaultValue(1);
        }
        int idx = readcode.indexOf("}");
        if (idx < 0) {
            throw new PogoException("Syntax error in:\n" + templname);
        }
        return readcode.substring(0, idx) + cl_prop + dev_prop + "}\n";
    }

    protected String buildPutPropertyMethod() throws FileNotFoundException, SecurityException, IOException, PogoException {
        int end;
        String templname = this.pogo.templates_dir + "/cpp/write_property.cpp";
        PogoString readcode = new PogoString(PogoUtil.readFile(templname, "TemplateDevServ", this.pogo.class_name));
        readcode = PogoUtil.removeLogMessages(readcode);
        String tag = "PogoProjectTitle";
        String pattern = "\"" + this.pogo.title + "\"";
        while (readcode.str.indexOf(tag) >= 0) {
            readcode.replace(tag, pattern);
        }
        tag = "PogoClassDescription;";
        PogoString desc = new PogoString(this.pogo.class_desc);
        desc.manageDoubleCotes();
        if (desc.str == null || desc.str.length() == 0) {
            desc.str = "  ";
        }
        String newcode = "vector<string>\tstr_desc;\n";
        int start = 0;
        while ((end = desc.str.indexOf(10, start)) >= 0) {
            newcode = newcode + "\tstr_desc.push_back(\"";
            newcode = newcode + desc.str.substring(start, end) + "\");\n";
            start = end + 1;
        }
        newcode = newcode + "\tstr_desc.push_back(\"";
        newcode = newcode + desc.substring(start) + "\");";
        while (readcode.str.indexOf(tag) >= 0) {
            readcode.replace(tag, newcode);
        }
        start = readcode.indexOf("get_db_class()->put_property(data);");
        if (start > 0) {
            for (int i = 0; i < 3; ++i) {
                start = readcode.str.lastIndexOf("\n", start - 1);
            }
            String inheritance = "\n\t//  Put inheritance\n\tTango::DbDatum\tinher_datum(\"InheritedFrom\");\n\tvector<string> inheritance;\n";
            if (!this.pogo.inheritedClassName().equals("Device_4Impl")) {
                inheritance = inheritance + "\tinheritance.push_back(\"" + this.pogo.inheritedClassName() + "\");\n";
            }
            inheritance = inheritance + "\tinheritance.push_back(\"Device_4Impl\");\n";
            inheritance = inheritance + "\tinher_datum << inheritance;\n\tdata.push_back(inher_datum);\n";
            readcode.insert(start, inheritance);
        }
        return readcode.str;
    }

    private String correctOldTrace(String str) {
        int start;
        PogoString code = new PogoString(str);
        String ret_type = "CORBA::Any *";
        while ((start = code.str.indexOf("DevTemplateCmd")) > 0) {
            start = code.str.lastIndexOf(ret_type, start);
            String cmdname = code.str.substring(start += ret_type.length(), code.str.indexOf("::", start));
            code.replace("DevTemplateCmd", cmdname);
        }
        return code.str;
    }

    private PogoString checkCVStags(PogoString code, PogoString templcode) {
        String s = templcode.substring(0, templcode.str.indexOf("//+====================="));
        StringTokenizer st = new StringTokenizer(s, "\n");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            int pos = tmp.indexOf("$");
            if (pos > 0) {
                pos = tmp.indexOf(" ", pos);
                v.add(0, tmp.substring(0, pos) + " $\";");
                continue;
            }
            v.add(0, tmp);
        }
        while (v.size() > 0) {
            s = (String)v.remove(0);
            String declar = s.substring(0, s.indexOf("=")).trim();
            if (code.str.indexOf(declar) >= 0) continue;
            code.insert(0, s + "\n");
        }
        return code;
    }
}

