/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.ProjectFiles;

public class AttribTable
extends Vector
implements PogoDefs {
    Exception except = null;

    public AttribTable() {
    }

    public AttribTable(Vector v_in) {
        for (int i = 0; i < v_in.size(); ++i) {
            this.addElement(v_in.elementAt(i));
        }
    }

    public AttribTable(ProjectFiles prjfiles, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        boolean toWWW = System.getProperty("CVSROOT") != null;
        String filename = prjfiles.getServerClass();
        int devimpl = 2;
        if (lang == 1) {
            devimpl = PogoUtil.deviceImplRevisionNumber(prjfiles.getServer_h());
        }
        PogoString pgs = new PogoString(PogoUtil.readFile(filename));
        if (toWWW) {
            System.out.println("Reading " + filename);
        }
        if (lang == 2) {
            this.parsePyAttributes(pgs);
            return;
        }
        int start = pgs.str.indexOf("attribute_factory(");
        if (start < 0) {
            System.out.println("Attribute factory not found in :\n" + filename);
            return;
        }
        PogoString method = new PogoString(pgs.extractMethodCore(start));
        if (lang == 0 || devimpl < 3) {
            start = 0;
            String patern = "Attr(\"";
            while ((start = method.str.indexOf(patern, start)) >= 0) {
                Attrib attr;
                int xSize;
                start = method.str.lastIndexOf("\n", start);
                int end = method.str.indexOf("(", start) + 1;
                String constructor = method.str.substring(start, end);
                start = end;
                end = method.str.indexOf(")", start);
                PogoString s = new PogoString(method.str.substring(start, end));
                String[] params = s.getParams();
                int type = 0;
                if (constructor.indexOf("Image") >= 0) {
                    int ySize;
                    if (params.length > 4) {
                        for (int i = 0; i < AttrRWtypeArray.length; ++i) {
                            String target = lang == 0 ? "AttrWriteType." + AttrRWtypeArray[i] : "Tango::" + AttrRWtypeArray[i];
                            if (!params[2].equals(target)) continue;
                            type = i;
                        }
                        try {
                            xSize = Integer.parseInt(params[3]);
                            ySize = Integer.parseInt(params[4]);
                        }
                        catch (NumberFormatException e) {
                            if (toWWW) {
                                ySize = 1;
                                xSize = 1;
                            }
                            throw e;
                        }
                    } else {
                        try {
                            xSize = Integer.parseInt(params[2]);
                            ySize = Integer.parseInt(params[3]);
                        }
                        catch (NumberFormatException e) {
                            if (toWWW) {
                                ySize = 1;
                                xSize = 1;
                            }
                            throw e;
                        }
                    }
                    attr = new Attrib(params[0], 2, params[1], type, xSize, ySize);
                } else if (constructor.indexOf("Spectrum") >= 0) {
                    if (params.length > 3) {
                        for (int i = 0; i < AttrRWtypeArray.length; ++i) {
                            String target = lang == 0 ? "AttrWriteType." + AttrRWtypeArray[i] : "Tango::" + AttrRWtypeArray[i];
                            if (!params[2].equals(target)) continue;
                            type = i;
                        }
                        try {
                            xSize = Integer.parseInt(params[3]);
                        }
                        catch (NumberFormatException e) {
                            if (toWWW) {
                                xSize = 1;
                            }
                            throw e;
                        }
                    } else {
                        try {
                            xSize = Integer.parseInt(params[2]);
                        }
                        catch (NumberFormatException e) {
                            if (toWWW) {
                                xSize = 1;
                            }
                            throw e;
                        }
                    }
                    attr = new Attrib(params[0], 1, params[1], type, xSize);
                } else {
                    for (int i = 0; i < AttrRWtypeArray.length; ++i) {
                        String target = lang == 0 ? "AttrWriteType." + AttrRWtypeArray[i] : "Tango::" + AttrRWtypeArray[i];
                        if (params.length <= 2 || !params[2].equals(target)) continue;
                        type = i;
                    }
                    attr = params.length == 4 && type == 3 ? new Attrib(params[0], 0, params[1], type, params[3]) : new Attrib(params[0], 0, params[1], type, "");
                }
                attr.getDefaultProperties(method, lang);
                this.addElement(attr);
            }
        } else {
            String header = PogoUtil.readFile(prjfiles.getServerClass_h());
            String pattern = "Attribute : ";
            start = 0;
            while ((start = method.indexOf(pattern, start)) > 0) {
                if (!method.isCommentLine(start)) continue;
                int end = method.nextCr(start += pattern.length());
                String name = method.substring(start, end);
                Attrib attr = new Attrib(name, header);
                attr.getDefaultProperties(method, lang);
                this.addElement(attr);
            }
        }
    }

    private void parsePyAttributes(PogoString code) throws PogoException {
        int start = code.str.indexOf("Class(PyTango.PyDeviceClass):");
        if (start < 0) {
            throw new PogoException("No DeviceClass class found !");
        }
        if ((start = code.str.indexOf("attr_list", start)) < 0) {
            throw new PogoException("No Attribute list found !");
        }
        start = code.inMethod(start);
        int end = code.outMethod(start);
        String attr_list = code.str.substring(start, end);
        String target = "[[";
        end = 0;
        while ((start = attr_list.indexOf(target, end)) > 0) {
            end = attr_list.lastIndexOf("'", start - 1);
            start = attr_list.lastIndexOf("'", end - 1);
            String name = attr_list.substring(start + 1, end).trim();
            start = end + target.length();
            end = attr_list.indexOf(",", start);
            start = attr_list.lastIndexOf(".", end);
            String type = "Tango::" + attr_list.substring(start + 1, end).trim();
            start = end + 1;
            end = attr_list.indexOf(",", start);
            start = attr_list.lastIndexOf(".", end);
            String s_att_type = attr_list.substring(start + 1, end).trim();
            int att_type = 0;
            for (int i = 0; i < AttrTypeArray.length; ++i) {
                if (!s_att_type.equals(AttrTypeArray[i])) continue;
                att_type = i;
            }
            start = end + 1;
            end = attr_list.indexOf("]", start);
            start = attr_list.lastIndexOf(".", end);
            int dim_x = 1;
            int dim_y = 1;
            int idx = end;
            switch (att_type) {
                case 0: {
                    break;
                }
                case 1: {
                    end = attr_list.lastIndexOf(",", end);
                    try {
                        dim_x = Integer.parseInt(attr_list.substring(end + 1, idx).trim());
                    }
                    catch (NumberFormatException e) {
                        System.out.println(e);
                    }
                    break;
                }
                case 2: {
                    int idx2 = end = attr_list.lastIndexOf(",", end);
                    end = attr_list.lastIndexOf(",", end - 1);
                    try {
                        dim_x = Integer.parseInt(attr_list.substring(end + 1, idx2).trim());
                        dim_y = Integer.parseInt(attr_list.substring(idx2 + 1, idx).trim());
                        break;
                    }
                    catch (NumberFormatException e) {
                        System.out.println(e);
                    }
                }
            }
            String s_rw_type = attr_list.substring(start + 1, end).trim();
            int rw_type = 0;
            for (int i = 0; i < AttrRWtypeArray.length; ++i) {
                if (!s_rw_type.equals(AttrRWtypeArray[i])) continue;
                rw_type = i;
            }
            Attrib attr = new Attrib(name, att_type, type, rw_type, dim_x, dim_y);
            start = idx + 1;
            end = attr_list.indexOf("]", start);
            String str_prop = attr_list.substring(start, end);
            attr.setPyProperties(str_prop);
            attr.notAllowedFor.setPyNotAllowedFor(code.str, name);
            this.add(attr);
        }
    }

    void setAllowedState(String class_name, String filename, boolean is_abstractclass) throws FileNotFoundException, SecurityException, IOException, PogoException {
        PogoString readcode;
        try {
            readcode = new PogoString(PogoUtil.readFile(filename));
        }
        catch (FileNotFoundException e) {
            if (is_abstractclass) {
                return;
            }
            this.except = e;
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            Attrib attr = this.attributeAt(i);
            String signature = attr.allowedFullSignatureMethod(class_name);
            int start = readcode.indexOf(signature);
            if (start <= 0) continue;
            String method = readcode.extractMethodCore(start);
            attr.notAllowedFor = new DevStateTable(method);
        }
    }

    public Attrib attributeAt(int idx) {
        return (Attrib)this.elementAt(idx);
    }

    public String buildFactory(int lang) {
        if (lang == 2) {
            String str = "";
            for (int i = 0; i < this.size(); ++i) {
                Attrib attr = this.attributeAt(i);
                str = str + attr.buildCodeForAttributeConstructor(lang);
            }
            return str;
        }
        String tab = lang == 0 ? "\t" : "";
        String str = tab + "{\n";
        String addKeyWord = lang == 0 ? "att_list.addElement" : "att_list.push_back";
        for (int i = 0; i < this.size(); ++i) {
            Attrib attr = this.attributeAt(i);
            str = str + tab + "\t" + "//\tAttribute : " + attr.name + "\n";
            str = str + attr.buildCodeForAttributeConstructor(lang);
            str = str + attr.buildCodeForDefaultProperties(lang);
            str = str + tab + "\t" + addKeyWord + "(" + attr.getLowerName() + ");\n\n";
        }
        if (lang == 1) {
            str = str + "\t//\tEnd of Automatic code generation\n\t//-------------------------------------------------------------\n";
        }
        str = str + tab + "}\n";
        return str;
    }

    String readHardwareFullSignatureMethod(String class_name) {
        return this.signature(class_name, true);
    }

    String readHardwareSignatureMethod(String class_name) {
        return this.signature(class_name, false);
    }

    private String signature(String class_name, boolean full) {
        int start;
        String target;
        PogoString pgs = new PogoString("/**\n *\tHardware acquisition for attributes.\n */\n\tvirtual void CLASS::read_attr_hardware(vector<long> &attr_list)");
        if (class_name == null) {
            pgs.replace("CLASS::", "");
        } else {
            pgs.replace("CLASS", class_name);
            if (full) {
                target = " *\t";
                start = pgs.indexOf(target, "/**".length());
                int end = pgs.nextCr(start += target.length());
                String desc = pgs.substring(start, end);
                PogoString separator = new PogoString("//+----------------------------------------------------------------------------\n//\n// method : \t\tCLASS::METHOD\n// \n// description : \tDESCRIPTION\n//\n//-----------------------------------------------------------------------------\n");
                separator.replace("CLASS", class_name);
                separator.replace("METHOD", "read_attr_hardware");
                separator.replace("DESCRIPTION", desc);
                target = " */\n\tvirtual ";
                end = pgs.indexOf(target);
                String comments = pgs.substring(0, end + target.length());
                pgs.replace(comments, separator.str);
            }
        }
        if (!full) {
            target = " */\n\tvirtual ";
            start = pgs.indexOf(target);
            return pgs.substring(start += target.length());
        }
        return pgs.str;
    }

    public String[] isJavaCompatible() {
        String[] AttrDataArray = new String[]{"Tango::DEV_BOOLEAN", "Tango::DEV_SHORT", "Tango::DEV_USHORT", "Tango::DEV_LONG", "Tango::DEV_ULONG", "Tango::DEV_LONG64", "Tango::DEV_ULONG64", "Tango::DEV_DOUBLE", "Tango::DEV_STRING", "Tango::DEV_STATE"};
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.size(); ++i) {
            Attrib attr = this.attributeAt(i);
            if (attr.memorized) {
                v.add("Attribute memorized  (" + attr.name + ")");
            }
            boolean found = false;
            for (int t = 0; !found && t < AttrDataArray.length; ++t) {
                found = attr.dataType.cpp_code_str.equals(AttrDataArray[t]);
            }
            if (!found) {
                v.add("Attribute type " + attr.dataType.cpp_code_str + "  (" + attr.name + ")");
            }
            if (!attr.getWritable() || attr.attrType == 0) continue;
            v.add("Write an attribute " + AttrTypeArray[attr.attrType] + "  (" + attr.name + ")");
        }
        if (v.size() == 0) {
            return null;
        }
        String[] problems = new String[v.size()];
        System.out.println("Java Servers API do not support:");
        for (int i = 0; i < v.size(); ++i) {
            problems[i] = (String)v.elementAt(i);
            System.out.println(problems[i]);
        }
        return problems;
    }

    String updatePyAttributes(String code, String readcode, String template, String class_name) throws PogoException {
        String target = "attr.set_value(";
        int start = template.indexOf(target);
        if (start < 0) {
            throw new PogoException("Attribute template syntax error.");
        }
        start = template.indexOf("\n", start) + 1;
        String read_templ = template.substring(0, start);
        int idx = start;
        target = "#\tAdd your own code here";
        if ((start = template.indexOf(target, start)) < 0) {
            throw new PogoException("Attribute template syntax error.");
        }
        String write_templ = template.substring(idx, start += target.length() + 1);
        String stm_templ = "\t" + template.substring(start).trim();
        int insert_pos = code.indexOf("def read_attr_hardware(self,");
        insert_pos = PogoUtil.endOfPythonMethod(code, insert_pos);
        code = code.substring(0, insert_pos) + "\n\n" + code.substring(insert_pos);
        insert_pos += 2;
        for (int i = this.size() - 1; i >= 0; --i) {
            Attrib attr = this.attributeAt(i);
            String signature = "def read_" + attr.name + "(self, attr):";
            String read_method = readcode.indexOf(signature) > 0 ? PogoUtil.pythonMethod(readcode, signature) : attr.buildPyReadMethod(read_templ);
            read_method = "\n" + read_method.trim() + "\n\n";
            String write_method = null;
            if (attr.rwType == 1 || attr.rwType == 2) {
                signature = "def write_" + attr.name + "(self, attr):";
                write_method = readcode.indexOf(signature) > 0 ? PogoUtil.pythonMethod(readcode, signature) : attr.buildPyWriteMethod(write_templ);
                write_method = "\n" + write_method.trim() + "\n\n";
            }
            String stm_method = null;
            signature = "def is_" + attr.name + "_allowed(self, req_type):";
            int sigpos = readcode.indexOf(signature);
            if (sigpos > 0 || attr.notAllowedFor.size() > 0) {
                stm_method = sigpos > 0 ? PogoUtil.pythonMethod(readcode, signature) : attr.buildPyStateMachineMethod(stm_templ);
                stm_method = attr.pyUpdateAllowedStates(stm_method, signature);
                stm_method = "\n" + stm_method.trim() + "\n\n";
            }
            if (stm_method != null) {
                code = code.substring(0, insert_pos) + stm_method + code.substring(insert_pos);
            }
            if (write_method != null) {
                code = code.substring(0, insert_pos) + write_method + code.substring(insert_pos);
            }
            code = code.substring(0, insert_pos) + read_method + code.substring(insert_pos);
        }
        return code;
    }

    public int getScalarNumber() {
        int cnt = 0;
        for (int i = 0; i < this.size(); ++i) {
            Attrib attr = this.attributeAt(i);
            if (attr.attrType != 0) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getSpectrumNumber() {
        int cnt = 0;
        for (int i = 0; i < this.size(); ++i) {
            Attrib attr = this.attributeAt(i);
            if (attr.attrType != 1) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getImageNumber() {
        int cnt = 0;
        for (int i = 0; i < this.size(); ++i) {
            Attrib attr = this.attributeAt(i);
            if (attr.attrType != 2) continue;
            ++cnt;
        }
        return cnt;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.size(); ++i) {
            Attrib attr = this.attributeAt(i);
            str = str + attr.name + "\t";
            str = str + attr.dataType.cpp_code_str + "\n";
        }
        return str;
    }

    public static void main(String[] args) {
        String filename = "/segfs/tango/tools/pogo/test/cpp/PowerSupply/PowerSupply.h";
        try {
            ProjectFiles prj = new ProjectFiles(filename);
            AttribTable table = new AttribTable(prj, 1);
            System.out.println(table);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }
}

