/*
 * Decompiled with CFR 0.152.
 */
package pogo.class2www;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.io.File;
import pogo.class2www.Authors;
import pogo.class2www.CheckNewClasses;
import pogo.class2www.EsrfRepository;
import pogo.class2www.Family;
import pogo.class2www.HtmlMainPage;
import pogo.class2www.InstituteList;
import pogo.class2www.Module;
import pogo.class2www.Repositories;
import pogo.class2www.TangoCsRepository;
import pogo.class2www.TangoDsRepository;
import pogo.gene.PogoUtil;

public class Class2www {
    static final String web_home = "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc";
    private Repositories repositories;
    private TangoCsRepository cs;
    private TangoDsRepository ds;
    private EsrfRepository esrf;
    private String backup_home = System.getProperty("_BACKUP_HOME_");
    private long t0;
    private static final boolean do_cs = true;
    private static final boolean do_ds = true;
    private static final boolean do_esrf = true;
    public static InstituteList instituteList;

    public Class2www() throws DevFailed {
        if (PogoUtil.osIsUnix() && this.backup_home == null) {
            Except.throw_exception((String)"BACKUP_HOME_NOT_SET", (String)"_BACKUP_HOME_ has not been set", (String)"Class2www.Class2www()");
        }
        instituteList = new InstituteList(this.backup_home);
        this.t0 = System.currentTimeMillis();
        this.repositories = new Repositories();
        this.cs = new TangoCsRepository(this.backup_home, false);
        this.repositories.add(this.cs);
        this.ds = new TangoDsRepository(this.backup_home, true);
        this.repositories.add(this.ds);
        this.esrf = new EsrfRepository(this.backup_home, false);
        this.repositories.add(this.esrf);
    }

    private void parseModules() {
        this.cs.parseCvsModule();
        this.ds.parseCvsModule();
        this.esrf.parseCvsModule();
    }

    private void buildServerDoc() throws DevFailed {
        int i;
        for (i = 0; i < this.repositories.size(); ++i) {
            this.repositories.getRepository(i).buildServerDoc();
        }
        for (i = 0; i < this.repositories.size(); ++i) {
            this.repositories.getRepository(i).sort();
        }
        String[] use_rep = new String[]{this.cs.name, this.ds.name};
        String[] link_to = new String[]{this.esrf.name};
        new HtmlMainPage("Sourceforge", this.repositories, use_rep, link_to).generate();
        use_rep = new String[]{this.esrf.name};
        link_to = new String[]{};
        new HtmlMainPage("Local Repository", this.repositories, use_rep, link_to).generate();
    }

    private void checkNewClases() {
        new CheckNewClasses(this.backup_home, this.repositories).check();
    }

    private void moveToWWW() {
        String classes_dir = System.getProperty("_CLASSES_DIR_");
        if (classes_dir == null) {
            return;
        }
        String[] filenames = new String[]{this.cs.name, this.ds.name, this.esrf.name, "index.html", "ClassList.html", "Alphabetical.html"};
        File doc_dir = new File(classes_dir);
        try {
            if (!doc_dir.exists()) {
                doc_dir.mkdir();
                for (String filename : filenames) {
                    new File(filename).renameTo(new File(doc_dir + "/" + filename));
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void showResults() {
        long t1 = System.currentTimeMillis();
        long dt = (t1 - this.t0) / 1000L;
        long min = dt / 60L;
        long sec = dt - 60L * min;
        System.out.println("Duration: " + min + ":" + sec + "  (" + dt + " sec.)");
        for (int i = 0; i < this.repositories.size(); ++i) {
            System.out.println(this.repositories.getRepository(i).getSummary());
        }
    }

    public void logAuthors() {
        Module module;
        Family family;
        Authors authors = new Authors();
        for (Object o : this.cs.families) {
            family = (Family)o;
            for (Object o2 : family) {
                module = (Module)o2;
                if (module.server == null || module.server.author == null || module.server.author.length() <= 0) continue;
                authors.addClass(module);
            }
        }
        for (Object o : this.ds.families) {
            family = (Family)o;
            for (Object o2 : family) {
                module = (Module)o2;
                if (module.server == null || module.server.author == null || module.server.author.length() <= 0) continue;
                authors.addClass(module);
            }
        }
        try {
            PogoUtil.writeFile(this.backup_home + "/log/authors.txt", authors.toString());
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void logEsrfAuthors() {
        Authors authors = new Authors();
        for (Object o : this.esrf.families) {
            Family family = (Family)o;
            for (Object o2 : family) {
                Module module = (Module)o2;
                if (module.server == null || module.server.author == null || module.server.author.length() <= 0) continue;
                authors.addClass(module);
            }
        }
        try {
            PogoUtil.writeFile(this.backup_home + "/log/esrf_authors.txt", authors.toString());
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void main(String[] args) {
        try {
            Class2www c2w = new Class2www();
            c2w.parseModules();
            c2w.buildServerDoc();
            c2w.checkNewClases();
            c2w.moveToWWW();
            c2w.logAuthors();
            c2w.logEsrfAuthors();
            c2w.showResults();
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
    }
}

