/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoAppender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class TangoDeviceAppender
extends AppenderSkeleton
implements TangoAppender {
    private DeviceProxy lc_dev_proxy = null;
    private String dev_name = null;

    public TangoDeviceAppender(String string, String string2, String string3) throws DevFailed {
        this.setName(string2);
        this.dev_name = string;
        this.lc_dev_proxy = new DeviceProxy(string3);
        try {
            DeviceData deviceData = new DeviceData();
            deviceData.insert(this.dev_name);
            this.lc_dev_proxy.command_inout_asynch("Register", deviceData, true);
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
        if (this.lc_dev_proxy != null) {
            try {
                DeviceData deviceData = new DeviceData();
                deviceData.insert(this.dev_name);
                this.lc_dev_proxy.command_inout_asynch("UnRegister", deviceData, true);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
        this.lc_dev_proxy = null;
        this.dev_name = null;
    }

    public void append(LoggingEvent loggingEvent) {
        if (this.lc_dev_proxy == null) {
            return;
        }
        try {
            String[] stringArray = new String[]{String.valueOf(loggingEvent.timeStamp), loggingEvent.getLevel().toString(), loggingEvent.getLoggerName(), loggingEvent.getRenderedMessage(), "", loggingEvent.getThreadName()};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            this.lc_dev_proxy.command_inout_asynch("Log", deviceData, true);
        }
        catch (DevFailed devFailed) {
            this.close();
        }
    }

    public boolean isValid() {
        if (this.lc_dev_proxy == null) {
            return false;
        }
        try {
            this.lc_dev_proxy.ping();
        }
        catch (DevFailed devFailed) {
            this.close();
            return false;
        }
        return true;
    }
}

