/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;

class AccessProxy
extends DeviceProxy {
    protected static String user = null;
    protected static String host = null;
    protected boolean forced = false;
    protected Hashtable dev_right_table = null;
    protected Hashtable allowed_cmd_table = null;

    AccessProxy(String string) throws DevFailed {
        super(string, false);
        this.ping();
        String string2 = System.getProperty("SUPER_TANGO");
        if (string2 != null) {
            this.forced = string2.equals("true");
        }
        this.dev_right_table = new Hashtable();
        this.allowed_cmd_table = new Hashtable();
        System.out.println(string + " -> Forced to write access = " + this.forced);
    }

    int checkAccessControl(String string) throws DevFailed {
        if (this.forced) {
            return 1;
        }
        try {
            if (user == null) {
                user = System.getProperty("user.name").toLowerCase();
            }
            if (host == null) {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            DeviceData deviceData = new DeviceData();
            deviceData.insert(new String[]{user, host, string});
            String string2 = this.command_inout("GetAccess", deviceData).extractString();
            this.dev_right_table.put(string, string2);
            if (string2.equals("write")) {
                return 1;
            }
            return 0;
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("TangoApi_DEVICE_NOT_EXPORTED")) {
                Except.re_throw_exception(devFailed, "TangoApi_CANNOT_CHECK_ACCESS_CONTROL", "Cannot import Access Control device !", "AccessProxy.checkAccessControl()");
            }
            throw devFailed;
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println(unknownHostException);
            return 0;
        }
        return 0;
    }

    boolean isCommandAllowed(String string, String string2) {
        String[] stringArray = (String[])this.allowed_cmd_table.get(string);
        if (stringArray == null) {
            stringArray = this.getAllowedCommands(string);
        }
        if (stringArray.length == 0) {
            return false;
        }
        for (String string3 : stringArray) {
            if (!string3.toLowerCase().equals(string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected String[] getAllowedCommands(String string) {
        try {
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            DeviceData deviceData2 = this.command_inout("GetAllowedCommands", deviceData);
            String[] stringArray = deviceData2.extractStringArray();
            this.allowed_cmd_table.put(string, stringArray);
            return stringArray;
        }
        catch (DevFailed devFailed) {
            String[] stringArray = new String[]{};
            this.allowed_cmd_table.put(string, stringArray);
            return stringArray;
        }
    }
}

