/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDSlider;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class JDFileLoader {
    static final int NUMBER = 1;
    static final int STRING = 2;
    static final int COMA = 3;
    static final int COLON = 4;
    static final int OPENBRACE = 5;
    static final int CLOSEBRACE = 6;
    private final String[] lexical_word = new String[]{"NULL", "NUMBER", "STRING", "COMA", "COLON", "'{'", "'}'"};
    private int CrtLine;
    private int StartLine;
    private char CurrentChar;
    private String word;
    private String version;
    InputStreamReader f;
    Color globalBackground = JDrawEditor.defaultBackground;

    public JDFileLoader(FileReader fileReader) {
        this.f = fileReader;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
    }

    public JDFileLoader(InputStreamReader inputStreamReader) {
        this.f = inputStreamReader;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
    }

    private void read_char() throws IOException {
        this.CurrentChar = this.f.ready() ? (char)this.f.read() : (char)'\u0000';
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    private void jump_space() throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char();
        }
    }

    private String read_word() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.jump_space();
        this.StartLine = this.CrtLine;
        if (this.CurrentChar == ':' || this.CurrentChar == '{' || this.CurrentChar == '}' || this.CurrentChar == ',') {
            stringBuffer.append(this.CurrentChar);
            this.read_char();
            return stringBuffer.toString();
        }
        if (this.CurrentChar == '\"') {
            stringBuffer.append(this.CurrentChar);
            this.read_char();
            while (this.CurrentChar != '\"' && this.CurrentChar != '\u0000' && this.CurrentChar != '\n') {
                stringBuffer.append(this.CurrentChar);
                this.read_char();
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n') {
                IOException iOException = new IOException("String too long at line " + this.StartLine);
                throw iOException;
            }
            stringBuffer.append(this.CurrentChar);
            this.read_char();
            return stringBuffer.toString();
        }
        while (this.CurrentChar > ' ' && this.CurrentChar != ':' && this.CurrentChar != '{' && this.CurrentChar != '}' && this.CurrentChar != ',') {
            stringBuffer.append(this.CurrentChar);
            this.read_char();
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private boolean isNumber(String string) {
        char c;
        boolean bl = true;
        for (int i = 0; i < string.length() && bl; bl &= (c = string.charAt(i)) >= '0' && c <= '9' || c == '.' || c == 'e' || c == 'E' || c == '-', ++i) {
        }
        return bl;
    }

    private int class_lex(String string) {
        if (string == null) {
            return 0;
        }
        if (string.length() == 0) {
            return 2;
        }
        if (string.charAt(0) == '\"') {
            return 2;
        }
        if (string.equals(",")) {
            return 3;
        }
        if (string.equals(":")) {
            return 4;
        }
        if (string.equals("{")) {
            return 5;
        }
        if (string.equals("}")) {
            return 6;
        }
        if (this.isNumber(string)) {
            return 1;
        }
        return 2;
    }

    private void CHECK_LEX(int n, int n2) throws IOException {
        if (n != n2) {
            throw new IOException("Invalid syntyax at line " + this.StartLine + ", " + this.lexical_word[n2] + " expected");
        }
    }

    int getCurrentLine() {
        return this.StartLine;
    }

    void jumpPropertyValue() throws IOException {
        int n = this.class_lex(this.word);
        if (n == 5) {
            this.jumpBlock();
            return;
        }
        boolean bl = true;
        while (bl && this.word != null) {
            if (n != 1 && n != 2) {
                throw new IOException("Invalid syntyax at line " + this.StartLine + ": Number or String expected.");
            }
            this.word = this.read_word();
            n = this.class_lex(this.word);
            bl = n == 3;
            if (!bl) continue;
            this.word = this.read_word();
            n = this.class_lex(this.word);
        }
    }

    void jumpBlock() throws IOException {
        int n = this.class_lex(this.word);
        this.CHECK_LEX(n, 5);
        int n2 = 1;
        while (n2 > 0 && this.word != null) {
            this.word = this.read_word();
            n = this.class_lex(this.word);
            if (n == 5) {
                ++n2;
            }
            if (n != 6) continue;
            --n2;
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file");
        }
        this.word = this.read_word();
    }

    void startBlock() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 5);
        this.word = this.read_word();
    }

    void jumpLexem(int n) throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), n);
        this.word = this.read_word();
    }

    void endBlock() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 6);
        this.word = this.read_word();
    }

    boolean isEndBlock() {
        return this.class_lex(this.word) == 6;
    }

    double parseDouble() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 1);
        double d = 0.0;
        try {
            d = Double.parseDouble(this.word);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Invalid number at line " + this.StartLine);
        }
        this.word = this.read_word();
        return d;
    }

    private String extractQuote(String string) {
        if (string.charAt(0) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    String parseString() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 2);
        String string = this.extractQuote(this.word);
        this.word = this.read_word();
        return string;
    }

    boolean parseBoolean() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 2);
        String string = this.word;
        this.word = this.read_word();
        return string.equalsIgnoreCase("true");
    }

    Point2D.Double parsePoint() throws IOException {
        double d = this.parseDouble();
        this.jumpLexem(3);
        double d2 = this.parseDouble();
        return new Point2D.Double(d, d2);
    }

    Point2D.Double[] parseSummitArray() throws IOException {
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        boolean bl = false;
        this.CHECK_LEX(this.class_lex(this.word), 2);
        if (!this.word.equals("summit")) {
            throw new IOException("summit keyword missing at line " + this.StartLine);
        }
        this.word = this.read_word();
        this.jumpLexem(4);
        while (!bl && this.word != null) {
            double d = this.parseDouble();
            this.jumpLexem(3);
            double d2 = this.parseDouble();
            vector.add(new Point2D.Double(d, d2));
            bl = this.class_lex(this.word) != 3;
            if (bl) continue;
            this.word = this.read_word();
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file");
        }
        Point2D.Double[] doubleArray = new Point2D.Double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            doubleArray[i] = (Point2D.Double)vector.get(i);
        }
        return doubleArray;
    }

    Point2D.Double[] parseRectangularSummitArray() throws IOException {
        Point2D.Double[] doubleArray;
        Point2D.Double[] doubleArray2 = this.parseSummitArray();
        if (this.version.compareTo("v11") >= 0) {
            if (doubleArray2.length != 2) {
                throw new IOException("Invalid summit number for JDRectangular at line " + this.StartLine);
            }
            double d = doubleArray2[0].x;
            double d2 = doubleArray2[0].y;
            double d3 = doubleArray2[1].x - doubleArray2[0].x;
            double d4 = doubleArray2[1].y - doubleArray2[0].y;
            doubleArray = new Point2D.Double[8];
            doubleArray[0] = doubleArray2[0];
            doubleArray[4] = doubleArray2[1];
            doubleArray[1] = new Point2D.Double(d + d3 / 2.0, d2);
            doubleArray[2] = new Point2D.Double(d + d3, d2);
            doubleArray[3] = new Point2D.Double(d + d3, d2 + d4 / 2.0);
            doubleArray[5] = new Point2D.Double(d + d3 / 2.0, d2 + d4);
            doubleArray[6] = new Point2D.Double(d, d2 + d4);
            doubleArray[7] = new Point2D.Double(d, d2 + d4 / 2.0);
        } else {
            doubleArray = doubleArray2;
        }
        return doubleArray;
    }

    String parseProperyName() throws IOException {
        String string = this.parseString();
        this.jumpLexem(4);
        return string;
    }

    Color parseColor() throws IOException {
        int n = (int)this.parseDouble();
        this.jumpLexem(3);
        int n2 = (int)this.parseDouble();
        this.jumpLexem(3);
        int n3 = (int)this.parseDouble();
        return new Color(n, n2, n3);
    }

    String parseStringArray() throws IOException {
        String string;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        while (!bl && this.word != null) {
            string = this.parseString();
            vector.add(string);
            bl = this.class_lex(this.word) != 3;
            if (bl) continue;
            this.word = this.read_word();
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file");
        }
        string = "";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + (String)vector.get(i) + "\n";
        }
        return string;
    }

    Font parseFont() throws IOException {
        String string = this.parseString();
        this.jumpLexem(3);
        int n = (int)this.parseDouble();
        this.jumpLexem(3);
        int n2 = (int)this.parseDouble();
        return new Font(string, n, n2);
    }

    void parseGlobalSection() throws IOException {
        this.startBlock();
        while (!this.isEndBlock()) {
            String string = this.parseProperyName();
            if (string.equals("background")) {
                this.globalBackground = this.parseColor();
                continue;
            }
            System.out.println("Unknown global property found:" + string);
            this.jumpPropertyValue();
        }
        this.endBlock();
    }

    JDObject parseObject() throws IOException {
        String string = this.parseString();
        if (string.equals("JDEllipse")) {
            return new JDEllipse(this);
        }
        if (string.equals("JDRectangle")) {
            return new JDRectangle(this);
        }
        if (string.equals("JDRoundRectangle")) {
            return new JDRoundRectangle(this);
        }
        if (string.equals("JDLabel")) {
            return new JDLabel(this);
        }
        if (string.equals("JDLine")) {
            return new JDLine(this);
        }
        if (string.equals("JDPolyline")) {
            return new JDPolyline(this);
        }
        if (string.equals("JDSpline")) {
            return new JDSpline(this);
        }
        if (string.equals("JDGroup")) {
            return new JDGroup(this);
        }
        if (string.equals("JDImage")) {
            return new JDImage(this);
        }
        if (string.equals("JDSwingObject")) {
            return new JDSwingObject(this);
        }
        if (string.equals("JDAxis")) {
            return new JDAxis(this);
        }
        if (string.equals("JDBar")) {
            return new JDBar(this);
        }
        if (string.equals("JDSlider")) {
            return new JDSlider(this);
        }
        if (string.equals("Global")) {
            this.parseGlobalSection();
            return null;
        }
        System.out.println("JDFileLoader.parseObject() Unknown class found:" + string + " at line " + this.StartLine);
        this.jumpBlock();
        return null;
    }

    String parseParamString() throws IOException {
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        while (!bl && this.word != null) {
            int n = this.class_lex(this.word);
            if (n != 2 && n != 1) {
                throw new IOException("Error at line " + this.StartLine + ", '" + this.lexical_word[1] + "' or '" + this.lexical_word[2] + "' expected");
            }
            vector.add(this.extractQuote(this.word));
            this.word = this.read_word();
            bl = this.class_lex(this.word) != 3;
            if (bl) continue;
            this.word = this.read_word();
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file");
        }
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + (String)vector.get(i);
            if (i >= vector.size() - 1) continue;
            string = string + "\n";
        }
        return string;
    }

    public Vector parseFile() throws IOException {
        boolean bl = false;
        Vector<JDObject> vector = new Vector<JDObject>();
        this.word = this.read_word();
        if (this.word == null) {
            throw new IOException("File empty !");
        }
        if (!this.word.equalsIgnoreCase("jdfile")) {
            throw new IOException("Invalid header !");
        }
        this.jumpLexem(2);
        this.version = this.parseString();
        this.jumpLexem(5);
        int n = this.class_lex(this.word);
        while (!bl) {
            switch (n) {
                case 2: {
                    JDObject jDObject = this.parseObject();
                    if (jDObject == null) break;
                    vector.add(jDObject);
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    throw new IOException("Invalid syntyax at line " + this.StartLine + ": Class name or '}' expected.");
                }
            }
            n = this.class_lex(this.word);
            bl = this.word == null || n == 6;
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file at line " + this.StartLine + ".");
        }
        this.CHECK_LEX(this.class_lex(this.word), 6);
        return vector;
    }
}

