/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IRefresherListener;
import fr.esrf.tangoatk.core.util.AttrDualSpectrum;
import fr.esrf.tangoatk.core.util.INonAttrNumberSpectrum;
import fr.esrf.tangoatk.core.util.INonAttrSpectrumListener;
import fr.esrf.tangoatk.core.util.NonAttrNumberSpectrumEvent;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.SearchInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;

public class NonAttrNumberSpectrumViewer
extends JLChart
implements INonAttrSpectrumListener,
IJLChartActionListener {
    protected int current_model_number = 0;
    protected int maximum_model_number = 9;
    protected INonAttrNumberSpectrum[] models = new INonAttrNumberSpectrum[this.maximum_model_number];
    protected JLDataView[] dvy = new JLDataView[this.maximum_model_number];
    protected JLDataView dvx;
    protected String lastConfig = "";
    public static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black};
    public static final int Y1_AXIS = 0;
    public static final int Y2_AXIS = 1;

    public NonAttrNumberSpectrumViewer() {
        this.setBorder(new EtchedBorder());
        this.setBackground(new Color(180, 180, 180));
        this.getY1Axis().setAutoScale(true);
        this.getY2Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.getXAxis().setLabelFormat(0);
        this.dvx = new JLDataView();
        this.getXAxis().addDataView(this.dvx);
        this.addUserAction("Save Settings");
        this.addUserAction("Load Settings");
        this.addJLChartActionListener(this);
    }

    public void reset() {
        for (int i = 0; i < this.current_model_number; ++i) {
            this.models[i].removeNonAttrSpectrumListener((INonAttrSpectrumListener)this);
            if (this.getY1Axis().getViews().contains(this.dvy[i])) {
                this.getY1Axis().removeDataView(this.dvy[i]);
                continue;
            }
            this.getY2Axis().removeDataView(this.dvy[i]);
        }
        this.current_model_number = 0;
    }

    protected String[] buildPanelString(SearchInfo searchInfo) {
        String[] stringArray = new String[]{searchInfo.dataView.getExtendedName() + " " + searchInfo.axis.getAxeName(), "Index= " + new Double(searchInfo.value.x).intValue(), "X= " + searchInfo.xdataView.formatValue(searchInfo.xdataView.getTransformedValue(searchInfo.xvalue.y)), "Y= " + searchInfo.dataView.formatValue(searchInfo.dataView.getTransformedValue(searchInfo.value.y)) + " " + searchInfo.dataView.getUnit()};
        return stringArray;
    }

    protected int findModelIndex(INonAttrNumberSpectrum iNonAttrNumberSpectrum) {
        int n = -1;
        while (++n < this.current_model_number && this.models[n] != iNonAttrNumberSpectrum) {
        }
        if (n == this.current_model_number) {
            n = -1;
        }
        return n;
    }

    public void spectrumChange(NonAttrNumberSpectrumEvent nonAttrNumberSpectrumEvent) {
        INonAttrNumberSpectrum iNonAttrNumberSpectrum = (INonAttrNumberSpectrum)nonAttrNumberSpectrumEvent.getSource();
        int n = this.findModelIndex(iNonAttrNumberSpectrum);
        if (n != -1) {
            double[] dArray = nonAttrNumberSpectrumEvent.getXValue();
            double[] dArray2 = nonAttrNumberSpectrumEvent.getYValue();
            int n2 = dArray.length;
            this.dvx.reset();
            for (int i = 0; i < n2; ++i) {
                this.dvx.add(i, dArray[i]);
            }
            n2 = dArray2.length;
            JLDataView jLDataView = this.dvy[n];
            jLDataView.reset();
            for (int i = 0; i < n2; ++i) {
                jLDataView.add(i, dArray2[i]);
            }
            this.repaint();
        }
    }

    public void addModel(INonAttrNumberSpectrum iNonAttrNumberSpectrum) {
        this.addModel(iNonAttrNumberSpectrum, 0);
    }

    public void addModel(INonAttrNumberSpectrum iNonAttrNumberSpectrum, int n) {
        if (n != 0 && n != 1) {
            return;
        }
        if (iNonAttrNumberSpectrum != null && this.current_model_number < this.maximum_model_number && this.findModelIndex(iNonAttrNumberSpectrum) == -1) {
            this.models[this.current_model_number] = iNonAttrNumberSpectrum;
            if (this.current_model_number == 0) {
                this.dvx.setName(iNonAttrNumberSpectrum.getXName());
            }
            JLDataView jLDataView = new JLDataView();
            jLDataView.setUnit(iNonAttrNumberSpectrum.getYUnit());
            jLDataView.setName(iNonAttrNumberSpectrum.getYName());
            jLDataView.setColor(defaultColor[this.current_model_number]);
            jLDataView.setMarkerColor(defaultColor[this.current_model_number]);
            if (n == 0) {
                this.getY1Axis().addDataView(jLDataView);
            } else {
                this.getY2Axis().addDataView(jLDataView);
            }
            this.dvy[this.current_model_number] = jLDataView;
            ++this.current_model_number;
            iNonAttrNumberSpectrum.addNonAttrSpectrumListener((INonAttrSpectrumListener)this);
        }
    }

    public String setSettings(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.parseText(string)) {
            return "NumberSpectrumViewer.setSettings: Failed to parse given config";
        }
        Vector<String> vector = cfFileReader.getParam("graph_title");
        if (vector != null) {
            this.setHeader(OFormat.getName(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("label_visible")) != null) {
            this.setLabelVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("graph_background")) != null) {
            this.setBackground(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam("title_font")) != null) {
            this.setHeaderFont(OFormat.getFont(vector));
        }
        JLAxis jLAxis = this.getXAxis();
        vector = cfFileReader.getParam("xgrid");
        if (vector != null) {
            jLAxis.setGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xsubgrid")) != null) {
            jLAxis.setSubGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xgrid_style")) != null) {
            jLAxis.setGridStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xmin")) != null) {
            jLAxis.setMinimum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xmax")) != null) {
            jLAxis.setMaximum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xautoscale")) != null) {
            jLAxis.setAutoScale(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xcale")) != null) {
            jLAxis.setScale(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xformat")) != null) {
            jLAxis.setLabelFormat(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xtitle")) != null) {
            jLAxis.setName(OFormat.getName(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("xcolor")) != null) {
            jLAxis.setAxisColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam("xlabel_font")) != null) {
            jLAxis.setFont(OFormat.getFont(vector));
        }
        jLAxis = this.getY1Axis();
        vector = cfFileReader.getParam("y1grid");
        if (vector != null) {
            jLAxis.setGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1subgrid")) != null) {
            jLAxis.setSubGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1grid_style")) != null) {
            jLAxis.setGridStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1min")) != null) {
            jLAxis.setMinimum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1max")) != null) {
            jLAxis.setMaximum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1autoscale")) != null) {
            jLAxis.setAutoScale(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1cale")) != null) {
            jLAxis.setScale(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1format")) != null) {
            jLAxis.setLabelFormat(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1title")) != null) {
            jLAxis.setName(OFormat.getName(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y1color")) != null) {
            jLAxis.setAxisColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam("y1label_font")) != null) {
            jLAxis.setFont(OFormat.getFont(vector));
        }
        jLAxis = this.getY2Axis();
        vector = cfFileReader.getParam("y2grid");
        if (vector != null) {
            jLAxis.setGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y2subgrid")) != null) {
            jLAxis.setSubGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y2grid_style")) != null) {
            jLAxis.setGridStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y2min")) != null) {
            jLAxis.setMinimum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y2max")) != null) {
            jLAxis.setMaximum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y2autoscale")) != null) {
            jLAxis.setAutoScale(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y2cale")) != null) {
            jLAxis.setScale(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y2format")) != null) {
            jLAxis.setLabelFormat(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y2title")) != null) {
            jLAxis.setName(OFormat.getName(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("y2color")) != null) {
            jLAxis.setAxisColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam("y2label_font")) != null) {
            jLAxis.setFont(OFormat.getFont(vector));
        }
        return "";
    }

    public String getSettings() {
        String string = "";
        string = string + "graph_title:'" + this.getHeader() + "'\n";
        string = string + "label_visible:" + this.isLabelVisible() + "\n";
        string = string + "graph_background:" + OFormat.color(this.getBackground()) + "\n";
        string = string + "title_font:" + OFormat.font(this.getHeaderFont()) + "\n";
        string = string + "xgrid:" + this.getXAxis().isGridVisible() + "\n";
        string = string + "xsubgrid:" + this.getXAxis().isSubGridVisible() + "\n";
        string = string + "xgrid_style:" + this.getXAxis().getGridStyle() + "\n";
        string = string + "xmin:" + this.getXAxis().getMinimum() + "\n";
        string = string + "xmax:" + this.getXAxis().getMaximum() + "\n";
        string = string + "xautoscale:" + this.getXAxis().isAutoScale() + "\n";
        string = string + "xcale:" + this.getXAxis().getScale() + "\n";
        string = string + "xformat:" + this.getXAxis().getLabelFormat() + "\n";
        string = string + "xtitle:'" + this.getXAxis().getName() + "'\n";
        string = string + "xcolor:" + OFormat.color(this.getXAxis().getAxisColor()) + "\n";
        string = string + "xlabel_font:" + OFormat.font(this.getXAxis().getFont()) + "\n";
        string = string + "y1grid:" + this.getY1Axis().isGridVisible() + "\n";
        string = string + "y1subgrid:" + this.getY1Axis().isSubGridVisible() + "\n";
        string = string + "y1grid_style:" + this.getY1Axis().getGridStyle() + "\n";
        string = string + "y1min:" + this.getY1Axis().getMinimum() + "\n";
        string = string + "y1max:" + this.getY1Axis().getMaximum() + "\n";
        string = string + "y1autoscale:" + this.getY1Axis().isAutoScale() + "\n";
        string = string + "y1cale:" + this.getY1Axis().getScale() + "\n";
        string = string + "y1format:" + this.getY1Axis().getLabelFormat() + "\n";
        string = string + "y1title:'" + this.getY1Axis().getName() + "'\n";
        string = string + "y1color:" + OFormat.color(this.getY1Axis().getAxisColor()) + "\n";
        string = string + "y1label_font:" + OFormat.font(this.getY1Axis().getFont()) + "\n";
        string = string + "y2grid:" + this.getY2Axis().isGridVisible() + "\n";
        string = string + "y2subgrid:" + this.getY2Axis().isSubGridVisible() + "\n";
        string = string + "y2grid_style:" + this.getY2Axis().getGridStyle() + "\n";
        string = string + "y2min:" + this.getY2Axis().getMinimum() + "\n";
        string = string + "y2max:" + this.getY2Axis().getMaximum() + "\n";
        string = string + "y2autoscale:" + this.getY2Axis().isAutoScale() + "\n";
        string = string + "y2cale:" + this.getY2Axis().getScale() + "\n";
        string = string + "y2format:" + this.getY2Axis().getLabelFormat() + "\n";
        string = string + "y2title:'" + this.getY2Axis().getName() + "'\n";
        string = string + "y2color:" + OFormat.color(this.getY2Axis().getAxisColor()) + "\n";
        string = string + "y2label_font:" + OFormat.font(this.getY2Axis().getFont()) + "\n";
        Vector<JLDataView> vector = new Vector<JLDataView>();
        if (this.getXAxis().isXY()) {
            vector.addAll(this.getXAxis().getViews());
        }
        vector.addAll(this.getY1Axis().getViews());
        vector.addAll(this.getY2Axis().getViews());
        string = string + "dv_number:" + vector.size() + "\n";
        for (int i = 0; i < vector.size(); ++i) {
            JLDataView jLDataView = (JLDataView)vector.get(i);
            string = string + "dv" + i + "_name:'" + jLDataView.getName() + "'\n";
            string = string + jLDataView.getConfiguration("dv" + i);
            jLDataView = null;
        }
        vector.clear();
        vector = null;
        return string;
    }

    public String setSetting(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.parseText(string)) {
            return "NonAttrNumberSpectrumViewer.setSettings: Failed to parse given text";
        }
        return this.applySettings(cfFileReader);
    }

    public void saveSetting(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            String string2 = this.getSettings();
            fileWriter.write(string2, 0, string2.length());
            fileWriter.close();
            this.lastConfig = string;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Failed to write " + string, "Error", 0);
        }
    }

    public String loadSetting(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.readFile(string)) {
            return "Failed to read " + string;
        }
        this.lastConfig = string;
        return this.applySettings(cfFileReader);
    }

    protected String applySettings(CfFileReader cfFileReader) {
        String string = "";
        this.setMaxDisplayDuration(Double.POSITIVE_INFINITY);
        this.setDisplayDuration(Double.POSITIVE_INFINITY);
        Vector<String> vector = cfFileReader.getParam("dv_number");
        Vector<JLDataView> vector2 = new Vector<JLDataView>();
        if (this.getXAxis().isXY()) {
            vector2.addAll(this.getXAxis().getViews());
        }
        vector2.addAll(this.getY1Axis().getViews());
        vector2.addAll(this.getY2Axis().getViews());
        if (vector != null) {
            int n;
            try {
                n = Integer.parseInt(vector.get(0).toString());
            }
            catch (NumberFormatException numberFormatException) {
                string = string + "dv_number: invalid number\n";
                return string;
            }
            for (int i = 0; i < n; ++i) {
                vector = cfFileReader.getParam("dv" + i + "_name");
                if (vector == null) {
                    string = string + "Unable to find dv" + i + "_name param\n";
                    return string;
                }
                String string2 = vector.get(0).toString();
                for (int j = 0; j < vector2.size(); ++j) {
                    JLDataView jLDataView = (JLDataView)vector2.get(j);
                    if (string2.equals(jLDataView.getName())) {
                        jLDataView.applyConfiguration("dv" + i, cfFileReader);
                        break;
                    }
                    jLDataView = null;
                }
                string2 = null;
            }
        } else {
            boolean bl = false;
        }
        vector2.clear();
        vector2 = null;
        this.applyConfiguration(cfFileReader);
        this.getXAxis().applyConfiguration("x", cfFileReader);
        this.getY1Axis().applyConfiguration("y1", cfFileReader);
        this.getY2Axis().applyConfiguration("y2", cfFileReader);
        return string;
    }

    protected void loadButtonActionPerformed() {
        File file;
        int n;
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = NonAttrNumberSpectrumViewer.this.getExtension(file);
                return string != null && string.equals("txt");
            }

            public String getDescription() {
                return "text files ";
            }
        });
        if (this.lastConfig.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((n = jFileChooser.showOpenDialog(null)) == 0 && (file = jFileChooser.getSelectedFile()) != null && !bl) {
            String string = this.loadSetting(file.getAbsolutePath());
            if (string.length() > 0) {
                JOptionPane.showMessageDialog(null, string, "Errors reading " + file.getName(), 0);
            }
            this.repaint();
        }
    }

    protected String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public void actionPerformed(JLChartActionEvent jLChartActionEvent) {
        if (jLChartActionEvent.getName().equals("Load Settings")) {
            this.loadButtonActionPerformed();
        } else if (jLChartActionEvent.getName().equals("Save Settings")) {
            this.saveButtonActionPerformed();
        }
    }

    protected void saveButtonActionPerformed() {
        File file;
        int n;
        int n2 = 0;
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = NonAttrNumberSpectrumViewer.this.getExtension(file);
                return string != null && string.equals("txt");
            }

            public String getDescription() {
                return "text files ";
            }
        });
        if (this.lastConfig.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((n = jFileChooser.showSaveDialog(null)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            if (this.getExtension(file) == null) {
                file = new File(file.getAbsolutePath() + ".txt");
            }
            if (file.exists()) {
                n2 = JOptionPane.showConfirmDialog(null, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
            }
            if (n2 == 0) {
                this.saveSetting(file.getAbsolutePath());
            }
        }
    }

    public boolean getActionState(JLChartActionEvent jLChartActionEvent) {
        return false;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        final NonAttrNumberSpectrumViewer nonAttrNumberSpectrumViewer = new NonAttrNumberSpectrumViewer();
        try {
            Object object;
            AttributePolledList attributePolledList = new AttributePolledList();
            String string = "";
            String string2 = "";
            IAttribute iAttribute = null;
            IAttribute iAttribute2 = null;
            AttrDualSpectrum attrDualSpectrum = null;
            final AttrDualSpectrum[] attrDualSpectrumArray = new AttrDualSpectrum[stringArray.length - 1];
            JButton jButton = new JButton("remove/add");
            jButton.setToolTipText("Removes/Adds the models of the viewer");
            if (stringArray.length >= 2) {
                int n;
                string = stringArray[0].trim();
                iAttribute = (IAttribute)attributePolledList.add(string);
                for (n = 1; n < stringArray.length; ++n) {
                    string2 = stringArray[n].trim();
                    iAttribute2 = (IAttribute)attributePolledList.add(string2);
                    attrDualSpectrum = new AttrDualSpectrum(iAttribute.getDevice(), iAttribute.getNameSansDevice(), iAttribute2.getDevice(), iAttribute2.getNameSansDevice());
                    attrDualSpectrum.setRefreshInterval(1000);
                    attrDualSpectrumArray[n - 1] = attrDualSpectrum;
                }
                for (n = 0; n < attrDualSpectrumArray.length; ++n) {
                    nonAttrNumberSpectrumViewer.addModel((INonAttrNumberSpectrum)attrDualSpectrumArray[n], 0);
                }
                attributePolledList.addRefresherListener(new IRefresherListener(){

                    public void refreshStep() {
                        for (int i = 0; i < attrDualSpectrumArray.length; ++i) {
                            attrDualSpectrumArray[i].refresh();
                        }
                        nonAttrNumberSpectrumViewer.repaint();
                    }
                });
                jButton.addActionListener(new ActionListener(){
                    int count = 1;

                    public void actionPerformed(ActionEvent actionEvent) {
                        switch (this.count) {
                            case 0: {
                                for (int i = 0; i < attrDualSpectrumArray.length; ++i) {
                                    nonAttrNumberSpectrumViewer.addModel((INonAttrNumberSpectrum)attrDualSpectrumArray[i], 0);
                                }
                                this.count = 1;
                                break;
                            }
                            case 1: {
                                nonAttrNumberSpectrumViewer.reset();
                                this.count = 0;
                            }
                        }
                    }
                });
            } else {
                string = "tango/tangotest/1/double_spectrum_ro";
                string2 = "tango/tangotest/1/float_spectrum_ro";
                String string3 = "tango/tangotest/1/short_spectrum_ro";
                iAttribute = (IAttribute)attributePolledList.add(string);
                iAttribute2 = (IAttribute)attributePolledList.add(string2);
                object = (IAttribute)attributePolledList.add(string3);
                final AttrDualSpectrum attrDualSpectrum2 = new AttrDualSpectrum(iAttribute.getDevice(), iAttribute.getNameSansDevice(), iAttribute2.getDevice(), iAttribute2.getNameSansDevice());
                attrDualSpectrum2.setYUnit("UNITE");
                attrDualSpectrum2.setYName("NOM");
                attrDualSpectrum2.setRefreshInterval(1000);
                final AttrDualSpectrum attrDualSpectrum3 = new AttrDualSpectrum(iAttribute.getDevice(), iAttribute.getNameSansDevice(), object.getDevice(), object.getNameSansDevice());
                attrDualSpectrum3.setRefreshInterval(1000);
                nonAttrNumberSpectrumViewer.addModel((INonAttrNumberSpectrum)attrDualSpectrum2, 0);
                nonAttrNumberSpectrumViewer.addModel((INonAttrNumberSpectrum)attrDualSpectrum3, 1);
                attributePolledList.addRefresherListener(new IRefresherListener(){

                    public void refreshStep() {
                        attrDualSpectrum2.refresh();
                        attrDualSpectrum3.refresh();
                        nonAttrNumberSpectrumViewer.repaint();
                    }
                });
                jButton.addActionListener(new ActionListener(){
                    int count = 1;

                    public void actionPerformed(ActionEvent actionEvent) {
                        switch (this.count) {
                            case 0: {
                                nonAttrNumberSpectrumViewer.addModel((INonAttrNumberSpectrum)attrDualSpectrum2, 0);
                                nonAttrNumberSpectrumViewer.addModel((INonAttrNumberSpectrum)attrDualSpectrum3, 1);
                                this.count = 1;
                                break;
                            }
                            case 1: {
                                nonAttrNumberSpectrumViewer.reset();
                                this.count = 0;
                            }
                        }
                    }
                });
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            object = new GridBagConstraints();
            object.fill = 2;
            object.gridx = 0;
            object.gridy = 1;
            object.weighty = 0.0;
            object.weightx = 1.0;
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jFrame.getContentPane().setLayout(new GridBagLayout());
            jFrame.getContentPane().add((Component)nonAttrNumberSpectrumViewer, gridBagConstraints);
            jFrame.getContentPane().add((Component)jButton, object);
            jFrame.setDefaultCloseOperation(3);
            jFrame.setTitle("DualSpectrumViewer:");
            jFrame.setSize(640, 480);
            jFrame.setVisible(true);
            attributePolledList.startRefresher();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

