/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoDs.Except;
import java.io.Serializable;

public class DeviceInfo
extends DbDevImportInfo
implements Serializable {
    public String last_exported;
    public String last_unexported;

    public DeviceInfo(DevVarLongStringArray devVarLongStringArray) {
        this.name = devVarLongStringArray.svalue[0];
        this.ior = devVarLongStringArray.svalue[1];
        this.version = devVarLongStringArray.svalue[2];
        boolean bl = this.exported = devVarLongStringArray.lvalue[0] == 1;
        if (devVarLongStringArray.lvalue.length > 1) {
            this.pid = devVarLongStringArray.lvalue[1];
        }
        if (devVarLongStringArray.svalue.length > 3) {
            this.server = devVarLongStringArray.svalue[3];
        }
        if (devVarLongStringArray.svalue.length > 4) {
            this.hostname = devVarLongStringArray.svalue[4];
        }
        if (devVarLongStringArray.svalue.length > 5) {
            this.last_exported = devVarLongStringArray.svalue[5];
            this.last_unexported = devVarLongStringArray.svalue[6];
        }
    }

    public String toString() {
        String string = super.toString();
        string = string + "\nlast_exported:   " + this.last_exported;
        string = string + "\nlast_unexported: " + this.last_unexported;
        return string;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Device name ?");
            System.exit(0);
        }
        try {
            String string = stringArray[0];
            Database database = ApiUtil.get_db_obj();
            DeviceInfo deviceInfo = database.get_device_info(string);
            System.out.println(deviceInfo);
        }
        catch (DevFailed devFailed) {
            if (stringArray.length < 2 || !stringArray[1].equals("-no_exception")) {
                Except.print_exception(devFailed);
            }
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

