/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsyncCallObject;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbRedundancy;
import fr.esrf.TangoApi.DevLockManager;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IApiUtilDAO;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoApi.events.IEventConsumer;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jacorb.orb.Delegate;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Request;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;

public class ApiUtilDAODefaultImpl
implements IApiUtilDAO {
    private static Vector db_list = null;
    private static Database default_dbase = null;
    private static IEventConsumer event_consumer = null;
    private static Hashtable async_request_table = null;
    private static int async_request_cnt = 0;
    private static int async_cb_sub_model = 1;
    private static boolean in_server_code = false;
    private static int reconnection_delay = -1;

    public Database get_db_obj(String string) throws DevFailed {
        int n = string.indexOf(":");
        if (n <= 0) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Cannot parse port number", "ApiUtil.get_db_obj()");
        }
        return this.get_db_obj(string.substring(0, n), string.substring(n + 1));
    }

    public Database get_default_db_obj() throws DevFailed {
        if (default_dbase == null) {
            return this.get_db_obj();
        }
        return default_dbase;
    }

    public synchronized Database get_db_obj() throws DevFailed {
        if (ApiUtil.getOrb() == null) {
            ApiUtilDAODefaultImpl.create_orb();
        }
        if (db_list == null) {
            db_list = new Vector();
        }
        if (default_dbase == null) {
            default_dbase = new Database();
            db_list.addElement(default_dbase);
        }
        return (Database)db_list.elementAt(0);
    }

    public Database get_db_obj(String string, String string2) throws DevFailed {
        if (ApiUtil.getOrb() == null) {
            ApiUtilDAODefaultImpl.create_orb();
        }
        if (db_list == null) {
            db_list = new Vector();
        }
        String string3 = new String(string + ":" + string2);
        if (default_dbase != null && default_dbase.get_tango_host().equals(string3)) {
            return default_dbase;
        }
        for (int i = 0; i < db_list.size(); ++i) {
            Database database = (Database)db_list.elementAt(i);
            if (!database.get_tango_host().equals(string3)) continue;
            return database;
        }
        Database database = new Database(string, string2);
        db_list.add(database);
        return database;
    }

    public Database change_db_obj(String string, String string2) throws DevFailed {
        Database database = this.get_db_obj(string, string2);
        db_list.remove(database);
        db_list.insertElementAt(database, 0);
        default_dbase = database;
        return database;
    }

    public Database set_db_obj(String string, String string2) throws DevFailed {
        return this.change_db_obj(string, string2);
    }

    public Database set_db_obj(String string) throws DevFailed {
        int n = string.indexOf(":");
        if (n <= 0) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Cannot parse port number", "ApiUtil.set_db_obj()");
        }
        return this.change_db_obj(string.substring(0, n), string.substring(n + 1));
    }

    private static synchronized void create_orb() throws DevFailed {
        try {
            Properties properties = System.getProperties();
            properties.put("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            properties.put("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
            properties.put("jacorb.retries", "0");
            properties.put("jacorb.retry_interval", "100");
            properties.put("jacorb.connection.client.connect_timeout", "5000");
            String string = ApiUtilDAODefaultImpl.checkORBgiopMaxMsgSize();
            properties.put("jacorb.maxManagedBufSize", string);
            properties.put("jacorb.config.log.verbosity", "0");
            System.setProperties(properties);
            String[] stringArray = null;
            ApiUtil.setOrb(ORB.init(stringArray, null));
            DevLockManager.getInstance();
        }
        catch (SystemException systemException) {
            ApiUtil.setOrb(null);
            systemException.printStackTrace();
            Except.throw_connection_failed(systemException.toString(), "Initializing ORB failed !", "ApiUtil.create_orb()");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String checkORBgiopMaxMsgSize() {
        String string = "20";
        String string2 = ApiUtil.getORBgiopMaxMsgSize();
        if (string2 != null && (string2 = ApiUtilDAODefaultImpl.checkBufferSize(string2)) != null) {
            string = string2;
        }
        return string;
    }

    private static String checkBufferSize(String string) {
        long l;
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        long l2 = l = (long)n * 1024L * 1024L;
        int n2 = 0;
        while (l2 > 0L) {
            l2 >>= 1;
            ++n2;
        }
        if (Math.pow(2.0, --n2) < (double)l) {
            ++n2;
        }
        System.out.println(n + " Mbytes  (2^" + n2 + ")");
        int n3 = n2 - 4;
        return Integer.toString(n3);
    }

    public ORB get_orb() throws DevFailed {
        if (ApiUtil.getOrb() == null) {
            ApiUtilDAODefaultImpl.create_orb();
        }
        return ApiUtil.getOrb();
    }

    public void set_in_server(boolean bl) {
        in_server_code = bl;
    }

    public boolean in_server() {
        return in_server_code;
    }

    public int getReconnectionDelay() {
        if (reconnection_delay < 0) {
            try {
                DbDatum dbDatum = this.get_db_obj().get_property("CtrlSystem", "ReconnectionDelay");
                if (!dbDatum.is_empty()) {
                    reconnection_delay = dbDatum.extractLong();
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            if (reconnection_delay < 0) {
                reconnection_delay = 1000;
            }
        }
        return reconnection_delay;
    }

    public static String getUser() {
        return System.getProperty("user.name");
    }

    public synchronized int put_async_request(AsyncCallObject asyncCallObject) {
        if (async_request_table == null) {
            async_request_table = new Hashtable();
        }
        asyncCallObject.id = ++async_request_cnt;
        Integer n = new Integer(async_request_cnt);
        async_request_table.put(n, asyncCallObject);
        return async_request_cnt;
    }

    public Request get_async_request(int n) throws DevFailed {
        if (!async_request_table.containsKey(n)) {
            Except.throw_exception("ASYNC_API_ERROR", "request for id " + n + " does not exist", this.getClass().getCanonicalName() + ".get_async_request");
        }
        AsyncCallObject asyncCallObject = (AsyncCallObject)async_request_table.get(n);
        return asyncCallObject.request;
    }

    public AsyncCallObject get_async_object(int n) {
        return (AsyncCallObject)async_request_table.get(n);
    }

    public synchronized void remove_async_request(int n) {
        AsyncCallObject asyncCallObject = (AsyncCallObject)async_request_table.get(n);
        if (asyncCallObject != null) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfRequest(asyncCallObject.request);
            ((org.jacorb.orb.ORB)ApiUtil.getOrb()).removeRequest(asyncCallObject.request);
            async_request_table.remove(n);
        }
    }

    private static void removePendingReplies(Delegate delegate) {
        if (!delegate.get_pending_replies().isEmpty()) {
            delegate.get_pending_replies().clear();
        }
    }

    public static void removePendingRepliesOfRequest(Request request) {
        Delegate delegate = (Delegate)((ObjectImpl)request.target())._get_delegate();
        ApiUtilDAODefaultImpl.removePendingReplies(delegate);
    }

    public static void removePendingRepliesOfDevice(Connection connection) {
        Delegate delegate;
        if (connection.device_4 != null) {
            delegate = (Delegate)((ObjectImpl)((Object)connection.device_4))._get_delegate();
        } else if (connection.device_3 != null) {
            delegate = (Delegate)((ObjectImpl)((Object)connection.device_3))._get_delegate();
        } else if (connection.device_2 != null) {
            delegate = (Delegate)((ObjectImpl)((Object)connection.device_2))._get_delegate();
        } else if (connection.device != null) {
            delegate = (Delegate)((ObjectImpl)((Object)connection.device))._get_delegate();
        } else {
            return;
        }
        ApiUtilDAODefaultImpl.removePendingReplies(delegate);
    }

    public void set_async_reply_model(int n, int n2) {
        Integer n3 = new Integer(n);
        AsyncCallObject asyncCallObject = (AsyncCallObject)async_request_table.get(n3);
        if (asyncCallObject != null) {
            asyncCallObject.reply_model = n2;
        }
    }

    public void set_async_reply_cb(int n, CallBack callBack) {
        Integer n2 = new Integer(n);
        AsyncCallObject asyncCallObject = (AsyncCallObject)async_request_table.get(n2);
        if (asyncCallObject != null) {
            asyncCallObject.cb = callBack;
        }
    }

    public int pending_asynch_call(DeviceProxy deviceProxy, int n) {
        int n2 = 0;
        Enumeration enumeration = async_request_table.keys();
        while (enumeration.hasMoreElements()) {
            AsyncCallObject asyncCallObject = (AsyncCallObject)async_request_table.get(enumeration.nextElement());
            if (asyncCallObject.dev != deviceProxy || n != 0 && asyncCallObject.reply_model != n) continue;
            ++n2;
        }
        return n2;
    }

    public int pending_asynch_call(int n) {
        int n2 = 0;
        Enumeration enumeration = async_request_table.keys();
        while (enumeration.hasMoreElements()) {
            AsyncCallObject asyncCallObject = (AsyncCallObject)async_request_table.get(enumeration.nextElement());
            if (n != 0 && asyncCallObject.reply_model != n) continue;
            ++n2;
        }
        return n2;
    }

    public void set_asynch_cb_sub_model(int n) {
        async_cb_sub_model = n;
    }

    public int get_asynch_cb_sub_model() {
        return async_cb_sub_model;
    }

    public void get_asynch_replies() {
        Enumeration enumeration = async_request_table.keys();
        while (enumeration.hasMoreElements()) {
            AsyncCallObject asyncCallObject = (AsyncCallObject)async_request_table.get(enumeration.nextElement());
            asyncCallObject.manage_reply(-1);
        }
    }

    public void get_asynch_replies(int n) {
        Enumeration enumeration = async_request_table.keys();
        while (enumeration.hasMoreElements()) {
            AsyncCallObject asyncCallObject = (AsyncCallObject)async_request_table.get(enumeration.nextElement());
            asyncCallObject.manage_reply(n);
        }
    }

    public void get_asynch_replies(DeviceProxy deviceProxy) {
        Enumeration enumeration = async_request_table.keys();
        while (enumeration.hasMoreElements()) {
            AsyncCallObject asyncCallObject = (AsyncCallObject)async_request_table.get(enumeration.nextElement());
            if (asyncCallObject.dev != deviceProxy) continue;
            asyncCallObject.manage_reply(-1);
        }
    }

    public void get_asynch_replies(DeviceProxy deviceProxy, int n) {
        Enumeration enumeration = async_request_table.keys();
        while (enumeration.hasMoreElements()) {
            AsyncCallObject asyncCallObject = (AsyncCallObject)async_request_table.get(enumeration.nextElement());
            if (asyncCallObject.dev != deviceProxy) continue;
            asyncCallObject.manage_reply(n);
        }
    }

    public String[] toStringArray(String string, String[] stringArray) {
        String[] stringArray2 = new String[1 + stringArray.length];
        stringArray2[0] = string;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = stringArray[i];
        }
        return stringArray2;
    }

    public String[] toStringArray(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        return stringArray;
    }

    public String[] toStringArray(String string) {
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    public String[] toStringArray(String string, DbAttribute[] dbAttributeArray, int n) {
        int n2;
        int n3 = dbAttributeArray.length;
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        vector.add(new String("" + n3));
        for (int i = 0; i < n3; ++i) {
            vector.add(dbAttributeArray[i].name);
            vector.add(new String("" + dbAttributeArray[i].size()));
            for (n2 = 0; n2 < dbAttributeArray[i].size(); ++n2) {
                vector.add(dbAttributeArray[i].get_property_name(n2));
                String[] stringArray = dbAttributeArray[i].get_value(n2);
                if (n != 1) {
                    vector.add(new String("" + stringArray.length));
                }
                for (String string2 : stringArray) {
                    vector.add(string2);
                }
            }
        }
        String[] stringArray = new String[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            stringArray[n2] = (String)vector.elementAt(n2);
        }
        return stringArray;
    }

    public DbAttribute[] toDbAttributeArray(String[] stringArray, int n) throws DevFailed {
        if (n < 1 && n > 2) {
            Except.throw_non_supported_exception("API_NotSupportedMode", "Mode " + n + " to decode attribute properties is not supported", "ApiUtil.toDbAttributeArray()");
        }
        int n2 = 1;
        int n3 = Integer.parseInt(stringArray[n2++]);
        DbAttribute[] dbAttributeArray = new DbAttribute[n3];
        for (int i = 0; i < n3; ++i) {
            dbAttributeArray[i] = new DbAttribute(stringArray[n2++]);
            int n4 = Integer.parseInt(stringArray[n2++]);
            block5: for (int j = 0; j < n4; ++j) {
                String string = stringArray[n2++];
                switch (n) {
                    case 1: {
                        dbAttributeArray[i].add(string, stringArray[n2++]);
                        continue block5;
                    }
                    case 2: {
                        int n5 = Integer.parseInt(stringArray[n2++]);
                        String[] stringArray2 = new String[n5];
                        for (int k = 0; k < n5; ++k) {
                            stringArray2[k] = stringArray[n2++];
                        }
                        dbAttributeArray[i].add(string, stringArray2);
                    }
                }
            }
        }
        return dbAttributeArray;
    }

    public String stateName(DevState devState) {
        return TangoConst.Tango_DevStateName[devState.value()];
    }

    public String stateName(short s) {
        return TangoConst.Tango_DevStateName[s];
    }

    public String qualityName(AttrQuality attrQuality) {
        return TangoConst.Tango_QualityName[attrQuality.value()];
    }

    public String qualityName(short s) {
        return TangoConst.Tango_QualityName[s];
    }

    public String[] parseTangoHost(String string) throws DevFailed {
        String string2 = null;
        String string3 = null;
        try {
            Object object;
            StringTokenizer stringTokenizer = string.indexOf(",") > 0 ? new StringTokenizer(string, ",") : new StringTokenizer(string);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                object = new StringTokenizer(string4, ":");
                vector.add(((StringTokenizer)object).nextToken());
                vector.add(((StringTokenizer)object).nextToken());
            }
            int n = 0;
            string2 = (String)vector.elementAt(n++);
            string3 = (String)vector.elementAt(n++);
            Integer.parseInt(string3);
            object = string2 + ":" + string3;
            DbRedundancy dbRedundancy = DbRedundancy.get_instance();
            if (vector.size() > 3) {
                String string5 = (String)vector.elementAt(n++) + ":" + (String)vector.elementAt(n++);
                dbRedundancy.put((String)object, string5);
            }
        }
        catch (Exception exception) {
            Except.throw_exception("TangoApi_TANGO_HOST_NOT_SET", exception.toString() + " occured when parsing " + "\"TANGO_HOST\" property " + string, "TangoApi.ApiUtil.parseTangoHost()");
        }
        return new String[]{string2, string3};
    }

    public void create_event_consumer() throws DevFailed {
        event_consumer = EventConsumer.create();
    }

    public IEventConsumer get_event_consumer() {
        return event_consumer;
    }
}

